/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.accessibility.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v85.accessibility.model.AXNodeId;
import org.openqa.selenium.devtools.v85.accessibility.model.AXProperty;
import org.openqa.selenium.devtools.v85.accessibility.model.AXValue;
import org.openqa.selenium.devtools.v85.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class AXNode {
    private final AXNodeId nodeId;
    private final Boolean ignored;
    private final Optional<List<AXProperty>> ignoredReasons;
    private final Optional<AXValue> role;
    private final Optional<AXValue> name;
    private final Optional<AXValue> description;
    private final Optional<AXValue> value;
    private final Optional<List<AXProperty>> properties;
    private final Optional<List<AXNodeId>> childIds;
    private final Optional<BackendNodeId> backendDOMNodeId;

    public AXNode(AXNodeId nodeId, Boolean ignored, Optional<List<AXProperty>> ignoredReasons, Optional<AXValue> role, Optional<AXValue> name, Optional<AXValue> description, Optional<AXValue> value, Optional<List<AXProperty>> properties, Optional<List<AXNodeId>> childIds, Optional<BackendNodeId> backendDOMNodeId) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.ignored = Objects.requireNonNull(ignored, "ignored is required");
        this.ignoredReasons = ignoredReasons;
        this.role = role;
        this.name = name;
        this.description = description;
        this.value = value;
        this.properties = properties;
        this.childIds = childIds;
        this.backendDOMNodeId = backendDOMNodeId;
    }

    public AXNodeId getNodeId() {
        return this.nodeId;
    }

    public Boolean getIgnored() {
        return this.ignored;
    }

    public Optional<List<AXProperty>> getIgnoredReasons() {
        return this.ignoredReasons;
    }

    public Optional<AXValue> getRole() {
        return this.role;
    }

    public Optional<AXValue> getName() {
        return this.name;
    }

    public Optional<AXValue> getDescription() {
        return this.description;
    }

    public Optional<AXValue> getValue() {
        return this.value;
    }

    public Optional<List<AXProperty>> getProperties() {
        return this.properties;
    }

    public Optional<List<AXNodeId>> getChildIds() {
        return this.childIds;
    }

    public Optional<BackendNodeId> getBackendDOMNodeId() {
        return this.backendDOMNodeId;
    }

    private static AXNode fromJson(JsonInput input) {
        AXNodeId nodeId = null;
        Boolean ignored = false;
        Optional<List<AXProperty>> ignoredReasons = Optional.empty();
        Optional<AXValue> role = Optional.empty();
        Optional<AXValue> name = Optional.empty();
        Optional<AXValue> description = Optional.empty();
        Optional<AXValue> value = Optional.empty();
        Optional<List<AXProperty>> properties = Optional.empty();
        Optional<List<AXNodeId>> childIds = Optional.empty();
        Optional<BackendNodeId> backendDOMNodeId = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeId": {
                    nodeId = (AXNodeId)input.read((Type)((Object)AXNodeId.class));
                    continue block24;
                }
                case "ignored": {
                    ignored = input.nextBoolean();
                    continue block24;
                }
                case "ignoredReasons": {
                    ignoredReasons = Optional.ofNullable(input.readArray((Type)((Object)AXProperty.class)));
                    continue block24;
                }
                case "role": {
                    role = Optional.ofNullable((AXValue)input.read((Type)((Object)AXValue.class)));
                    continue block24;
                }
                case "name": {
                    name = Optional.ofNullable((AXValue)input.read((Type)((Object)AXValue.class)));
                    continue block24;
                }
                case "description": {
                    description = Optional.ofNullable((AXValue)input.read((Type)((Object)AXValue.class)));
                    continue block24;
                }
                case "value": {
                    value = Optional.ofNullable((AXValue)input.read((Type)((Object)AXValue.class)));
                    continue block24;
                }
                case "properties": {
                    properties = Optional.ofNullable(input.readArray((Type)((Object)AXProperty.class)));
                    continue block24;
                }
                case "childIds": {
                    childIds = Optional.ofNullable(input.readArray((Type)((Object)AXNodeId.class)));
                    continue block24;
                }
                case "backendDOMNodeId": {
                    backendDOMNodeId = Optional.ofNullable((BackendNodeId)input.read((Type)((Object)BackendNodeId.class)));
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AXNode(nodeId, ignored, ignoredReasons, role, name, description, value, properties, childIds, backendDOMNodeId);
    }
}

