/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class CheckOriginHeader
implements Filter {
    private final Set<String> allowedHosts;
    private final Set<String> skipChecksOn;

    public CheckOriginHeader(Collection<String> allowedOriginHosts, Set<String> skipChecksOn) {
        Require.nonNull("Allowed origins list", allowedOriginHosts);
        this.allowedHosts = ImmutableSet.copyOf(allowedOriginHosts);
        this.skipChecksOn = ImmutableSet.copyOf((Collection)Require.nonNull("URLs where checks are skipped", skipChecksOn));
    }

    @Override
    public HttpHandler apply(HttpHandler httpHandler) {
        Require.nonNull("Next handler", httpHandler);
        return req -> {
            if (this.skipChecksOn.contains(req.getUri())) {
                return httpHandler.execute(req);
            }
            String origin = req.getHeader("Origin");
            if (origin != null && !this.allowedHosts.contains(origin)) {
                return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(500).addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson(ImmutableMap.of("value", ImmutableMap.of("error", "unknown error", "message", "Origin not allowed: " + origin, "stacktrace", ""))));
            }
            return httpHandler.execute(req);
        };
    }
}

