/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.grid.web.NoHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;

public class CombinedHandler
implements Predicate<HttpRequest>,
Routable,
HttpHandler {
    private final Map<Routable, HttpHandler> handlers = new HashMap<Routable, HttpHandler>();

    public void addHandler(Routable handler) {
        this.handlers.put(Require.nonNull("Handler", handler), handler);
    }

    @Override
    public boolean test(HttpRequest request) {
        return this.matches(request);
    }

    @Override
    public boolean matches(HttpRequest req) {
        return this.handlers.keySet().stream().anyMatch(p -> p.matches(req));
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        return this.handlers.entrySet().stream().filter(entry -> ((Routable)entry.getKey()).matches(req)).findFirst().map(Map.Entry::getValue).orElse(new NoHandler(new Json())).execute(req);
    }
}

