/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v140.memory.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class Module {
    private final String name;
    private final String uuid;
    private final String baseAddress;
    private final Number size;

    public Module(String name, String uuid, String baseAddress, Number size) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.uuid = Objects.requireNonNull(uuid, "uuid is required");
        this.baseAddress = Objects.requireNonNull(baseAddress, "baseAddress is required");
        this.size = Objects.requireNonNull(size, "size is required");
    }

    public String getName() {
        return this.name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public Number getSize() {
        return this.size;
    }

    private static Module fromJson(JsonInput input) {
        String name = null;
        String uuid = null;
        String baseAddress = null;
        Number size = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "uuid": {
                    uuid = input.nextString();
                    continue block12;
                }
                case "baseAddress": {
                    baseAddress = input.nextString();
                    continue block12;
                }
                case "size": {
                    size = input.nextNumber();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Module(name, uuid, baseAddress, size);
    }
}

