package org.openqa.selenium.devtools.v141.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum ElementAccessibilityIssueReason {

    DISALLOWEDSELECTCHILD("DisallowedSelectChild"),
    DISALLOWEDOPTGROUPCHILD("DisallowedOptGroupChild"),
    NONPHRASINGCONTENTOPTIONCHILD("NonPhrasingContentOptionChild"),
    INTERACTIVECONTENTOPTIONCHILD("InteractiveContentOptionChild"),
    INTERACTIVECONTENTLEGENDCHILD("InteractiveContentLegendChild"),
    INTERACTIVECONTENTSUMMARYDESCENDANT("InteractiveContentSummaryDescendant");

    private String value;

    ElementAccessibilityIssueReason(String value) {
        this.value = value;
    }

    public static ElementAccessibilityIssueReason fromString(String s) {
        return java.util.Arrays.stream(ElementAccessibilityIssueReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ElementAccessibilityIssueReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ElementAccessibilityIssueReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
