package org.openqa.selenium.devtools.v141.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * CSS @position-try rule representation.
 */
public class CSSPositionTryRule {

    private final org.openqa.selenium.devtools.v141.css.model.Value name;

    private final java.util.Optional<org.openqa.selenium.devtools.v141.css.model.StyleSheetId> styleSheetId;

    private final org.openqa.selenium.devtools.v141.css.model.StyleSheetOrigin origin;

    private final org.openqa.selenium.devtools.v141.css.model.CSSStyle style;

    private final java.lang.Boolean active;

    public CSSPositionTryRule(org.openqa.selenium.devtools.v141.css.model.Value name, java.util.Optional<org.openqa.selenium.devtools.v141.css.model.StyleSheetId> styleSheetId, org.openqa.selenium.devtools.v141.css.model.StyleSheetOrigin origin, org.openqa.selenium.devtools.v141.css.model.CSSStyle style, java.lang.Boolean active) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.styleSheetId = styleSheetId;
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.style = java.util.Objects.requireNonNull(style, "style is required");
        this.active = java.util.Objects.requireNonNull(active, "active is required");
    }

    /**
     * The prelude dashed-ident name
     */
    public org.openqa.selenium.devtools.v141.css.model.Value getName() {
        return name;
    }

    /**
     * The css style sheet identifier (absent for user agent stylesheet and user-specified
     * stylesheet rules) this rule came from.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v141.css.model.StyleSheetId> getStyleSheetId() {
        return styleSheetId;
    }

    /**
     * Parent stylesheet's origin.
     */
    public org.openqa.selenium.devtools.v141.css.model.StyleSheetOrigin getOrigin() {
        return origin;
    }

    /**
     * Associated style declaration.
     */
    public org.openqa.selenium.devtools.v141.css.model.CSSStyle getStyle() {
        return style;
    }

    public java.lang.Boolean getActive() {
        return active;
    }

    private static CSSPositionTryRule fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v141.css.model.Value name = null;
        java.util.Optional<org.openqa.selenium.devtools.v141.css.model.StyleSheetId> styleSheetId = java.util.Optional.empty();
        org.openqa.selenium.devtools.v141.css.model.StyleSheetOrigin origin = null;
        org.openqa.selenium.devtools.v141.css.model.CSSStyle style = null;
        java.lang.Boolean active = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.read(org.openqa.selenium.devtools.v141.css.model.Value.class);
                    break;
                case "styleSheetId":
                    styleSheetId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v141.css.model.StyleSheetId.class));
                    break;
                case "origin":
                    origin = input.read(org.openqa.selenium.devtools.v141.css.model.StyleSheetOrigin.class);
                    break;
                case "style":
                    style = input.read(org.openqa.selenium.devtools.v141.css.model.CSSStyle.class);
                    break;
                case "active":
                    active = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CSSPositionTryRule(name, styleSheetId, origin, style, active);
    }
}
