package org.openqa.selenium.devtools.v141.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class DevicePosture {

    public enum Type {

        CONTINUOUS("continuous"), FOLDED("folded");

        private String value;

        Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return java.util.Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return value;
        }

        public String toJson() {
            return value;
        }

        private static Type fromJson(JsonInput input) {
            return fromString(input.nextString());
        }
    }

    private final Type type;

    public DevicePosture(Type type) {
        this.type = java.util.Objects.requireNonNull(type, "type is required");
    }

    /**
     * Current posture of the device
     */
    public Type getType() {
        return type;
    }

    private static DevicePosture fromJson(JsonInput input) {
        Type type = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "type":
                    type = Type.fromString(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DevicePosture(type);
    }
}
