/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v140.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v140.css.model.CSSStyle;
import org.openqa.selenium.devtools.v140.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v140.css.model.StyleSheetOrigin;
import org.openqa.selenium.devtools.v140.css.model.Value;
import org.openqa.selenium.json.JsonInput;

public class CSSPropertyRule {
    private final Optional<StyleSheetId> styleSheetId;
    private final StyleSheetOrigin origin;
    private final Value propertyName;
    private final CSSStyle style;

    public CSSPropertyRule(Optional<StyleSheetId> styleSheetId, StyleSheetOrigin origin, Value propertyName, CSSStyle style) {
        this.styleSheetId = styleSheetId;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.propertyName = Objects.requireNonNull(propertyName, "propertyName is required");
        this.style = Objects.requireNonNull(style, "style is required");
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public Value getPropertyName() {
        return this.propertyName;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    private static CSSPropertyRule fromJson(JsonInput input) {
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        StyleSheetOrigin origin = null;
        Value propertyName = null;
        CSSStyle style = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block12;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read(StyleSheetOrigin.class));
                    continue block12;
                }
                case "propertyName": {
                    propertyName = (Value)input.read(Value.class);
                    continue block12;
                }
                case "style": {
                    style = (CSSStyle)input.read(CSSStyle.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSPropertyRule(styleSheetId, origin, propertyName, style);
    }
}

