/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.visitor;

import graphql.Internal;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedInputType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.GraphQLUnionType;
import graphql.schema.visitor.GraphQLSchemaTraversalControl;
import graphql.schema.visitor.GraphQLSchemaVisitor;
import graphql.schema.visitor.GraphQLSchemaVisitorEnvironmentImpl;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.function.Supplier;

@Internal
class GraphQLSchemaVisitorAdapter
extends GraphQLTypeVisitorStub {
    private final GraphQLSchemaVisitor schemaVisitor;

    GraphQLSchemaVisitorAdapter(GraphQLSchemaVisitor schemaVisitor) {
        this.schemaVisitor = schemaVisitor;
    }

    private TraversalControl visitE(TraverserContext<GraphQLSchemaElement> context, Supplier<GraphQLSchemaTraversalControl> visitCall) {
        GraphQLSchemaTraversalControl generalCall = this.schemaVisitor.visitSchemaElement(context.thisNode(), new SchemaElementEnv(context));
        if (generalCall.isAbortive() || generalCall.isMutative()) {
            return generalCall.toTraversalControl(context);
        }
        GraphQLSchemaTraversalControl specificCall = visitCall.get();
        return specificCall.toTraversalControl(context);
    }

    @Override
    public TraversalControl visitGraphQLAppliedDirectiveArgument(GraphQLAppliedDirectiveArgument node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitAppliedDirectiveArgument(node, new AppliedDirectiveArgumentEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLAppliedDirective(GraphQLAppliedDirective node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitAppliedDirective(node, new AppliedDirectiveEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLArgument(GraphQLArgument node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitArgument(node, new ArgumentEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLDirective(GraphQLDirective node, TraverserContext<GraphQLSchemaElement> context) {
        if (context.getParentNode() == null) {
            return this.visitE(context, () -> this.schemaVisitor.visitDirective(node, new DirectiveEnv(context)));
        }
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLEnumType(GraphQLEnumType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitEnumType(node, new EnumTypeEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLEnumValueDefinition(GraphQLEnumValueDefinition node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitEnumValueDefinition(node, new EnumValueDefinitionEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitFieldDefinition(node, new FieldDefinitionEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLInputObjectField(GraphQLInputObjectField node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitInputObjectField(node, new InputObjectFieldEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLInputObjectType(GraphQLInputObjectType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitInputObjectType(node, new InputObjectTypeEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitInterfaceType(node, new InterfaceTypeEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLObjectType(GraphQLObjectType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitObjectType(node, new ObjectEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLScalarType(GraphQLScalarType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitScalarType(node, new ScalarTypeEnv(context)));
    }

    @Override
    public TraversalControl visitGraphQLUnionType(GraphQLUnionType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitE(context, () -> this.schemaVisitor.visitUnionType(node, new UnionTypeEnv(context)));
    }

    static class UnionTypeEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLUnionType>
    implements GraphQLSchemaVisitor.UnionTypeVisitorEnvironment {
        public UnionTypeEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }
    }

    static class ScalarTypeEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLScalarType>
    implements GraphQLSchemaVisitor.ScalarTypeVisitorEnvironment {
        public ScalarTypeEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }
    }

    static class ObjectEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLObjectType>
    implements GraphQLSchemaVisitor.ObjectVisitorEnvironment {
        public ObjectEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }
    }

    static class InterfaceTypeEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLInterfaceType>
    implements GraphQLSchemaVisitor.InterfaceTypeVisitorEnvironment {
        public InterfaceTypeEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }
    }

    static class InputObjectTypeEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLInputObjectType>
    implements GraphQLSchemaVisitor.InputObjectTypeVisitorEnvironment {
        public InputObjectTypeEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }
    }

    static class InputObjectFieldEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLInputObjectField>
    implements GraphQLSchemaVisitor.InputObjectFieldVisitorEnvironment {
        public InputObjectFieldEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }

        @Override
        public GraphQLInputObjectType getContainer() {
            return (GraphQLInputObjectType)this.context.getParentNode();
        }

        @Override
        public GraphQLNamedInputType getUnwrappedType() {
            return (GraphQLNamedInputType)GraphQLTypeUtil.unwrapAllAs(((GraphQLInputObjectField)this.getElement()).getType());
        }
    }

    static class FieldDefinitionEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLFieldDefinition>
    implements GraphQLSchemaVisitor.FieldDefinitionVisitorEnvironment {
        public FieldDefinitionEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }

        @Override
        public GraphQLFieldsContainer getContainer() {
            return (GraphQLFieldsContainer)this.context.getParentNode();
        }

        @Override
        public GraphQLNamedOutputType getUnwrappedType() {
            return (GraphQLNamedOutputType)GraphQLTypeUtil.unwrapAllAs(((GraphQLFieldDefinition)this.getElement()).getType());
        }
    }

    static class EnumValueDefinitionEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLEnumValueDefinition>
    implements GraphQLSchemaVisitor.EnumValueDefinitionVisitorEnvironment {
        public EnumValueDefinitionEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }

        @Override
        public GraphQLEnumType getContainer() {
            return (GraphQLEnumType)this.context.getParentNode();
        }
    }

    static class EnumTypeEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLEnumType>
    implements GraphQLSchemaVisitor.EnumTypeVisitorEnvironment {
        public EnumTypeEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }
    }

    static class DirectiveEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLDirective>
    implements GraphQLSchemaVisitor.DirectiveVisitorEnvironment {
        public DirectiveEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }
    }

    static class ArgumentEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLArgument>
    implements GraphQLSchemaVisitor.ArgumentVisitorEnvironment {
        public ArgumentEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }

        @Override
        public GraphQLNamedSchemaElement getContainer() {
            return (GraphQLNamedSchemaElement)this.context.getParentNode();
        }

        @Override
        public GraphQLNamedInputType getUnwrappedType() {
            return (GraphQLNamedInputType)GraphQLTypeUtil.unwrapAllAs(((GraphQLArgument)this.getElement()).getType());
        }
    }

    static class AppliedDirectiveEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLAppliedDirective>
    implements GraphQLSchemaVisitor.AppliedDirectiveVisitorEnvironment {
        public AppliedDirectiveEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }

        @Override
        public GraphQLDirectiveContainer getContainer() {
            return (GraphQLDirectiveContainer)this.context.getParentNode();
        }
    }

    static class AppliedDirectiveArgumentEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLAppliedDirectiveArgument>
    implements GraphQLSchemaVisitor.AppliedDirectiveArgumentVisitorEnvironment {
        public AppliedDirectiveArgumentEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }

        @Override
        public GraphQLAppliedDirective getContainer() {
            return (GraphQLAppliedDirective)this.context.getParentNode();
        }

        @Override
        public GraphQLNamedInputType getUnwrappedType() {
            return (GraphQLNamedInputType)GraphQLTypeUtil.unwrapAllAs(((GraphQLAppliedDirectiveArgument)this.getElement()).getType());
        }
    }

    static class SchemaElementEnv
    extends GraphQLSchemaVisitorEnvironmentImpl<GraphQLSchemaElement>
    implements GraphQLSchemaVisitor.SchemaElementVisitorEnvironment {
        public SchemaElementEnv(TraverserContext<GraphQLSchemaElement> context) {
            super(context);
        }
    }
}

