package rainbowPackage;

import java.awt.Dimension;

//import javafx.scene.paint.Paint.*;
import javafx.scene.paint.Color;

public class RainbowPattern2D //For All Rainbow Patterns To Be Displayed With RainbowSoftColor.java Functions Determining Rainbow/Custom Colors Variation
{//Initializers
	private final Color clear = Color.rgb(0,0,0,0);//Color.rgb(4,1,3,0);
	private final Color green = Color.rgb(0,133,50);
	private final Color red = Color.rgb(193,0,0);
	private final Color blue = Color.rgb(0,0,192);
	private final Color purple = Color.rgb(122,0,178);
	private final Color orange = Color.rgb(255,134,0);
	private final Color yellow = Color.rgb(246,252,15);
	private final Color[] fireFXcolors = new Color[] {red, orange, yellow};
	//private final Color[] imperialFXcolors = new Color[] {green, blue, purple, blue, red};
	private final double[][] imperialColorsNum = {{green.getRed()*255, green.getGreen()*255, green.getBlue()*255}, {blue.getRed()*255, blue.getGreen()*255, blue.getBlue()*255}, {purple.getRed()*255, purple.getGreen()*255, purple.getBlue()*255}, {blue.getRed()*255, blue.getGreen()*255, blue.getBlue()*255}, {red.getRed()*255, red.getGreen()*255, red.getBlue()*255}};

	//private VibrantColors vibrantColors = new VibrantColors();
	//private VibrantColorCombos vibrantColorCombos = new VibrantColorCombos();
	private double[] rgb = {0,0,0}, argb = {0,0,0,1};
	private Color fxColor;
	//private Color[] fxColorArray = { Color.PINK, Color.SKYBLUE };
	double colorBeingChecked = 0, opacityBeingChecked = 1, sliderValue = 0, originalFormulaValue = 0, numberOfTransitions = 0, numberOfStillTransitions = 0, numberOfColorTransitions = 0;
	private RainbowSoftColor color = new RainbowSoftColor( new double[]{0,0,0,1} );
	//private TransparencySlider transparencySlider = new TransparencySlider( clear );
	private ColorArrayReverser colorArrayReverser = new ColorArrayReverser();
	private TrueArcTan trueArcTan = new TrueArcTan();

	public RainbowPattern2D( Color FXColor )//Creates Class And Sets Color With JavaFX Color Class //
	{
		fxColor = FXColor;
		color = new RainbowSoftColor( FXColor );
		rgb = new double[] { FXColor.getRed() * 255, FXColor.getGreen() * 255, FXColor.getBlue() * 255 };
		argb = new double[] { FXColor.getRed() * 255, FXColor.getGreen() * 255, FXColor.getBlue() * 255, FXColor.getOpacity() };
	}
	public RainbowPattern2D( double[] ARGB )//Creates Class And Sets Color With ARGB //
	{
		for (int z = 0; z <= 2; z++)
		{
			rgb[z] = ColorValueFitterCapper(ARGB[z]);
			argb[z] = ColorValueFitterCapper(ARGB[z]);
		}
		if ( ARGB.length == 3 )
		{
			argb = new double[4];
			for (int z = 0; z <= 2; z++)
				argb[z] = ColorValueFitterCapper(rgb[z]);
			ARGB[3] = 1;
		}
		else
			argb[3] = OpacityValueFitterCapper(ARGB[3]);
		color = new RainbowSoftColor( ARGB );
		fxColor = color.ToFXColor();
	}
	public RainbowPattern2D()//Creates Class And Sets Color To Opake Black //
	{
		rgb = new double[]{0,0,0};
		argb = new double[]{0,0,0,1};
		color = new RainbowSoftColor( rgb );
		fxColor = color.ToFXColor();
	}
	public Color ToFXColor ()//Returns Color In JavaFX
	{
		//fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color ToFXColor ( double[] ARGB )//Changes Class To ARGB Value And Returns Color In JavaFX //
	{
		for (int z = 0; z <= 2; z++)
		{
			rgb[z] = ColorValueFitterCapper(ARGB[z]);
			argb[z] = ColorValueFitterCapper(ARGB[z]);
		}
		if ( ARGB.length <= 3 )
			argb[3] = 1;
		else
			argb[3] = OpacityValueFitterCapper(ARGB[3]);
		color = new RainbowSoftColor( argb );
		fxColor = color.ToFXColor();
		return fxColor;
	}

	public Color RainbowSoftColorFunction(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, RainbowSoftColor ColorBefore, RainbowSoftColor ColorAfter)//1st Square In Diagnostics Which Will Stream Sliding Then Movement Then Double Sliding Then The Same For Rainbow Segments Then Full Rainbows Then Rainbow Ribbons And A Seperate Video For Oppisite Double Sliding With vibrantColorCombos.ImperialColors For //To Use This To Access ColorSlider{Location/ColorsLength How Much From ColorBefore To ColorAfter} Though This Function //Top Bar At Top In DiagnosticsClass.java
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		for (int z = 0; z <= 2; z++)
		{
			rgb[z] = ColorValueFitterCapper( ColorAfter.ToRGB()[z] + ColorBefore.ToRGB()[z] - ColorBefore.ToRGB()[z] * sliderValue/ColorsLength - ColorAfter.ToRGB()[z] * ( ColorsLength - sliderValue )/ColorsLength );
			argb[z] = ColorValueFitterCapper( rgb[z] );
		}
		argb[3] = 1;
		color = new RainbowSoftColor( rgb );
		fxColor = color.ToFXColor();
		return fxColor;
	}

	public Color SimpleRainbow(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough)//2nd Square Make Simple Rainbow In The Same Fashion As Above, ColorsLength Length Of Rainbow Respective To Location //Choose ColorsLength To Be Same As RepeatLength For Best Rainbow //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		color.RainbowSoftColorRainbowFunction(Math.abs( ColorsLength ), sliderValue);//1st Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleRainbow(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations)//3rd Square Same As Above True And Not Mentioned Anymore BrightnessMultiplier From 0{Black}-1{Same-Color} How Dim, 1-255 How Bright To White. Graduations How Many Different Unadjusted Bars For Each Color //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		color.RainbowSoftColorRainbowFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations);//2nd Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleRainbow(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, boolean Adjusted )//4th Square Now Adjusted To Look Better At The Cost Of Speed Gradations Choice //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		if ( Adjusted )
			color.RainbowSoftColorRainbowFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations);//3rd Square In SimpleDiagnosticsClass.java
		else
			color.RainbowSoftColorRainbowFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations);//4th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleRainbowReverse(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough)//5th Square Reverse Color Directions As Rainbow With Green Flipped With Hot Pink //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		color.RainbowSoftColorRainbowFunctionReverse(Math.abs( ColorsLength ), sliderValue);//5th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleRainbowReverse(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations )//6th Square Same As Above But Reversed //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		color.RainbowSoftColorRainbowFunctionReverseAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations);//6th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleRainbowReverse(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, boolean Adjusted )//7th Square Same Adjustment //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		if ( Adjusted )
			color.RainbowSoftColorRainbowFunctionReverseAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations);//7th Square In SimpleDiagnosticsClass.java
		else
			color.RainbowSoftColorRainbowFunctionReverseUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations);//8th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, Color[] FXcolorArray)//9th Square For Colors In JavaFX //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		color.RainbowSoftCustomColorFunction(Math.abs( ColorsLength ), sliderValue, FXcolorArray);//10th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double[][] RGBcolorArray)//8th Square Put Any Amount Of Custom Colors In RGB Format Not ARGB As Opacity Variabled Funtions And Transparency Slider Can Be Implimented Seperatly For That //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		color.RainbowSoftCustomColorFunction(Math.abs( ColorsLength ), sliderValue, RGBcolorArray);//9th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, Color[] FXcolorArray, boolean Reversed )//9th Square For Colors In JavaFX //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		if (Reversed)
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsLength ), sliderValue, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true)); //
		else
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsLength ), sliderValue, FXcolorArray); //
		//color.RainbowSoftCustomColorFunction(Math.abs( ColorsLength ), sliderValue, FXcolorArray);//1?th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, double[][] ARGBcolorArray )//10th Square Things Should Follow For The Rest Of The Simple Linear Rainbows Until Opacity //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		color.RainbowSoftCustomColorFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, ARGBcolorArray);//11th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, double[][] ARGBcolorArray, boolean Adjusted )//11th Square 
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		if ( Adjusted )
			color.RainbowSoftCustomColorFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, ARGBcolorArray);//12th Square In SimpleDiagnosticsClass.java
		else
			color.RainbowSoftCustomColorFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, ARGBcolorArray);//13th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, Color[] FXcolorArray )//12th Square
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		//System.out.println( "2D FXcolors Brightnesses" + FXcolorSet[0][0].getBrightness() + FXcolorArray[1].getBrightness() + FXcolorArray[2].getBrightness() + FXcolorArray[3].getBrightness() + FXcolorArray[4].getBrightness() + FXcolorArray[5].getBrightness() );
		color.RainbowSoftCustomColorFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray);//14th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, Color[] FXcolorArray, boolean Adjusted )//13th Square
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		//System.out.println( "2D FXcolors Brightnesses" + FXcolorArray[0].getBrightness() + FXcolorArray[1].getBrightness() + FXcolorArray[2].getBrightness() + FXcolorArray[3].getBrightness() + FXcolorArray[4].getBrightness() + FXcolorArray[5].getBrightness() );
		if ( Adjusted )
			color.RainbowSoftCustomColorFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray);//15th Square In SimpleDiagnosticsClass.java
		else
			color.RainbowSoftCustomColorFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray);//16th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleRainbow(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter )//14th Square Same As Above Except Opacity Goes From OpacityBefore To OpacityAfter From Red To Purple And For Reverse Purple To Pink To Red With Rainbow Colors In-between
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);//17th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleRainbow(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//15th Square
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		if ( Adjusted )
			color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);//18th Square In SimpleDiagnosticsClass.java
		else
			color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);//19th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleRainbowReverse(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter )//16th Square
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);//20th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleRainbowReverse(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//17th Square
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		if ( Adjusted )
			color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);//21st Square In SimpleDiagnosticsClass.java
		else
			color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);//22nd Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, double[][] RGBcolorArray, double OpacityBefore, double OpacityAfter, boolean Adjusted )//18th Square
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		if ( Adjusted )
			color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, RGBcolorArray, OpacityBefore, OpacityAfter);//23rd Square In SimpleDiagnosticsClass.java
		else
			color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, RGBcolorArray, OpacityBefore, OpacityAfter);//24th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, Color[] FXcolorArray, double OpacityBefore, double OpacityAfter, boolean Adjusted )//19th Square Same Follows From Above To Here But Not The Next Function Which Is Not A Linear Rainbow //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		if ( Adjusted )
			color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);//25th Square In SimpleDiagnosticsClass.java
		else
			color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);//26th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color SimpleCustomColor(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double MarkerInLength, double RepeatLength, double FullSliderRunThrough, double BrightnessMultiplyer, int Gradations, Color[] FXcolorArray, double OpacityBefore, double OpacityAfter, boolean Adjusted, boolean Reversed )//19th Square Same Follows From Above To Here But Not The Next Function Which Is Not A Linear Rainbow //
	{
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, Math.signum(RepeatLength) * LocationOfColorMovement, Math.abs(RepeatLength), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, MarkerInLength, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, MarkerInLength, LocationOfStillMovement, RepeatLength, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, MarkerInLength, LocationOfStillMovement, LocationOfColorMovement, RepeatLength, FullSliderRunThrough );
		if ( Reversed )
			if ( Adjusted )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);//2?th Square In SimpleDiagnosticsClass.java
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);//2?th Square In SimpleDiagnosticsClass.java
		else
			if ( Adjusted )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);//25th Square In SimpleDiagnosticsClass.java
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);//26th Square In SimpleDiagnosticsClass.java
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowDiskVaryated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double FullSliderRunThrough, boolean Reversed)//20th Square Choose ColorsLength To Be Same As RepeatRadius Of Rainbow Disk Line With x & y Precentered Before Accessing This Function And Location Is The Connection To The xSlider Time Changing Variable
	{//With NonPrePost Color Sliders; Also Looks Cool When Into RainbowSoftColorRainbowFunction -> ColorsLength / 6 //Also Looks Cool When RepeatRadius In Here Is Halfed //Also Looks Cool When While < & > Is Swapped //Below Add - Location; and No sliderValue + ColorsLength For Cool Defects
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, Math.signum(RepeatRadius) * LocationOfColorMovement, Math.abs(RepeatRadius), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, originalFormulaValue, LocationOfStillMovement, RepeatRadius, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		if ( Reversed )
			color.RainbowSoftColorRainbowFunctionReverse( Math.abs( ColorsLength ), sliderValue ); //
		else
			color.RainbowSoftColorRainbowFunction( Math.abs( ColorsLength ), sliderValue ); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowDiskGradated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double FullSliderRunThrough, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//21st Square Same As Above Except Gradated Un/Adjusted With Opacity Changes
	{
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, Math.signum(RepeatRadius) * LocationOfColorMovement, Math.abs(RepeatRadius), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, originalFormulaValue, LocationOfStillMovement, RepeatRadius, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowDiskVaryated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double FullSliderRunThrough, Color[] FXcolorArray, boolean Reversed)//22nd Square Same As Above Except With Any Amount Of Custom Colors And Not All Accouchriments As Below
	{
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, Math.signum(RepeatRadius) * LocationOfColorMovement, Math.abs(RepeatRadius), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, originalFormulaValue, LocationOfStillMovement, RepeatRadius, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		if (Reversed)
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsLength ), sliderValue, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true)); //
		else
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsLength ), sliderValue, FXcolorArray); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowDiskGradated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double FullSliderRunThrough, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//23rd Square Same As Above Super Function For Any Custom Colors Disks Which Is Last Rainbow Disk Function
	{
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, Math.signum(RepeatRadius) * LocationOfColorMovement, Math.abs(RepeatRadius), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, originalFormulaValue, LocationOfStillMovement, RepeatRadius, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}

	public Color RainbowRingVaryated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double FullSliderRunThrough, double RingDisplacement, double InnerCutOffRadius, double OuterCutOffRadius, boolean Reversed)//24th Square Choose ColorsLength To Be Same As RepeatRadius Of Rainbow Disk Line With x & y Precentered Before Accessing This Function And Location Is The Connection To The xSlider Time Changing Variable
	{//With NonPrePost Color Sliders; Also Looks Cool When Into RainbowSoftColorRainbowFunction -> ColorsLength / 6 //Also Looks Cool When RepeatRadius In Here Is Halfed //Also Looks Cool When While < & > Is Swapped //Below Add - Location; and No sliderValue + ColorsLength For Cool Defects
		if ( Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) < InnerCutOffRadius || Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) > OuterCutOffRadius )
		{
			color.set( clear );
			rgb = color.ToRGB();
			argb = color.ToARGB();
			fxColor = color.ToFXColor();
			return fxColor;
		}
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) + RingDisplacement;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, Math.signum(RepeatRadius) * LocationOfColorMovement, Math.abs(RepeatRadius), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, originalFormulaValue, LocationOfStillMovement, RepeatRadius, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		if ( Reversed )
			color.RainbowSoftColorRainbowFunctionReverse( Math.abs( ColorsLength ), sliderValue ); //
		else
			color.RainbowSoftColorRainbowFunction( Math.abs( ColorsLength ), sliderValue ); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowRingGradated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double FullSliderRunThrough, double RingDisplacement, double InnerCutOffRadius, double OuterCutOffRadius, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//25th Square Same As Above Except Gradated Un/Adjusted With Opacity Changes
	{
		if ( Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) < InnerCutOffRadius || Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) > OuterCutOffRadius )
		{
			color.set( clear );
			rgb = color.ToRGB();
			argb = color.ToARGB();
			fxColor = color.ToFXColor();
			return fxColor;
		}
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) + RingDisplacement;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, Math.signum(RepeatRadius) * LocationOfColorMovement, Math.abs(RepeatRadius), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, originalFormulaValue, LocationOfStillMovement, RepeatRadius, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowRingVaryated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double FullSliderRunThrough, double RingDisplacement, double InnerCutOffRadius, double OuterCutOffRadius, Color[] FXcolorArray, boolean Reversed)//26th Square Same As Above Except With Any Amount Of Custom Colors And Not All Accouchriments As Below
	{
		if ( Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) < InnerCutOffRadius || Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) > OuterCutOffRadius )
		{
			color.set( clear );
			rgb = color.ToRGB();
			argb = color.ToARGB();
			fxColor = color.ToFXColor();
			return fxColor;
		}
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) + RingDisplacement;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, Math.signum(RepeatRadius) * LocationOfColorMovement, Math.abs(RepeatRadius), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, originalFormulaValue, LocationOfStillMovement, RepeatRadius, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		if (Reversed)
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsLength ), sliderValue, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true)); //
		else
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsLength ), sliderValue, FXcolorArray); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowRingGradated(double ColorsLength, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatRadius, double FullSliderRunThrough, double RingDisplacement, double InnerCutOffRadius, double OuterCutOffRadius, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//27th Square Same As Above Super Function For Any Custom Colors Disks Which Is Last Rainbow Disk Function
	{
		if ( Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) < InnerCutOffRadius || Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) > OuterCutOffRadius )
		{
			color.set( clear );
			rgb = color.ToRGB();
			argb = color.ToARGB();
			fxColor = color.ToFXColor();
			return fxColor;
		}
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) + RingDisplacement;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, Math.signum(RepeatRadius) * LocationOfColorMovement, Math.abs(RepeatRadius), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsLength, originalFormulaValue, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsLength, originalFormulaValue, LocationOfStillMovement, RepeatRadius, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsLength, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatRadius, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsLength ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}

	public Color RainbowClockVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, boolean Reversed)//28th Square NumberOfClock Hands Will Provide A Disjointed Series Of Rainbow Triangles, ClockHandDisplacement = Math.PI For Normal Clock//Choose ColorsFactor To Be Same As RepeatFactor Of Rainbow Clock With x & y Precentered Before Accessing This Function And Location Is The Connection To The xSlider Time Changing Variable //, double OneLessThanTheNumberOfClockHands, double ClockHandDisplacement
	{
		originalFormulaValue = trueArcTan.ArcTan(x, y) + Math.PI;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Reversed )
			color.RainbowSoftColorRainbowFunctionReverse(Math.abs( ColorsFactor ), sliderValue); //
		else
			color.RainbowSoftColorRainbowFunction(Math.abs( ColorsFactor ), sliderValue); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowClockGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//29th Square Same As Above Except Gradated Un/Adjusted With Opacity Changes
	{//(NotNeeded)Longness Definitely Needed sliderValue = SliderFormulateJustMovingColors( ColorsFactor, ( 180 - ClockHandDisplacement * ( Math.PI - 3.14159265358979 ) / ( Math.PI - 3.1415926535897 ) * ( Math.PI - 3.141592653589 ) / ( Math.PI - 3.14159265358 ) * ( Math.PI - 3.1415926535 ) / ( Math.PI - 3.141592653 ) * ( Math.PI - 3.14159265 ) / ( Math.PI - 3.1415926 ) * ( Math.PI - 3.141592 ) / ( Math.PI - 3.14159 ) * ( Math.PI - 3.1415 ) / ( Math.PI - 3.141 ) * ( Math.PI - 3.14 ) / ( Math.PI - 3.1 ) * ( Math.PI - 3 ) ) * ( Math.atan2(x, y) + ClockHandDisplacement ) / OneLessThanTheNumberOfClockHands, Location, RepeatFactor, FullSliderRunThrough );//Math.PI = 3.141592653589793 Points And Segments May Be A Key To Unraveling Pi In This Situation
		//(NotNeeded)sliderValue = SliderFormulateJustMovingColors( ColorsFactor, ( 180 - 10/* - ClockHandDisplacement * ( Math.PI - 3.14159265358979 ) / ( Math.PI - 3.1415926535897 ) * ( Math.PI - 3.141592653589 ) / ( Math.PI - 3.14159265358 ) * ( Math.PI - 3.1415926535 ) / ( Math.PI - 3.141592653 ) * ( Math.PI - 3.14159265 ) / ( Math.PI - 3.1415926 ) * ( Math.PI - 3.141592 ) / ( Math.PI - 3.14159 ) * ( Math.PI - 3.1415 ) / ( Math.PI - 3.141 ) * ( Math.PI - 3.14 ) / ( Math.PI - 3.1 ) * ( Math.PI - 3 ) */ ) * ( Math.atan2(x, y) + ClockHandDisplacement ) / OneLessThanTheNumberOfClockHands, Location, RepeatFactor, FullSliderRunThrough );//Math.PI = 3.141592653589793 Points And Segments May Be A Key To Unraveling Pi In This Situation
		originalFormulaValue = trueArcTan.ArcTan(x, y) + Math.PI;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowClockVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Color[] FXcolorArray, boolean Reversed )//30th Square Same As Above Except With Any Amount Of Custom Colors And Not All Accouchriments As Below
	{
		originalFormulaValue = trueArcTan.ArcTan(x, y) + Math.PI;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if (Reversed)
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsFactor ), sliderValue, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true)); //
		else
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsFactor ), sliderValue, FXcolorArray); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowClockGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//31st Square Same As Above Super Function For Any Custom Colors Clocks Which Is Last Rainbow Disk Function
	{
		originalFormulaValue = trueArcTan.ArcTan(x, y) + Math.PI;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}

	//Search For Or Put In Accessing Class: //pattern2D.RainbowSpiralVaryated( fullAngle, xSlider, ( x - HalfedDim.getWidth() ) / 3., ( y - HalfedDim.getHeight() ) / 3., fullAngle, 24.6, 1, HalfScreenDiagionalLength, false );//For Proper Rainbow Hypnosis Spiral
	//pattern2D.RainbowSpiralVaryated( fullAngle, xSlider, ( x - HalfedDim.getWidth() ) / 10., ( y - HalfedDim.getHeight() ) / 10., fullAngle, 144, 10, HalfScreenDiagionalLength, false );//For Proper Rainbow Rainbow Shrunken
	//pattern2D.RainbowSpiralVaryated( fullAngle * 6, xSlider * 6, ( x - HalfedDim.getWidth() ) / 6., ( y - HalfedDim.getHeight() ) / 6., fullAngle, 88.8, 4, HalfScreenDiagionalLength, false );//For Segment View
	//pattern2D.RainbowSpiralVaryated( fullAngle, xSlider * 3, ( x - HalfedDim.getWidth() ) / 6., ( y - HalfedDim.getHeight() ) / 6., fullAngle * 3, 66.6, 3, HalfScreenDiagionalLength, false );//For View Of More Length Than 1 Segment, Values Must Be Mulitples Of Eachother Somehow 3 In This Instance
	//pattern2D.RainbowSpiralVaryated( fullAngle, xSlider, ( x - HalfedDim.getWidth() ) / 1., ( y - HalfedDim.getHeight() ) / 1., fullAngle, 999, 1680, HalfScreenDiagionalLength, false );//For Proper Rainbow PsychaHypnotic
	public Color RainbowSpiralVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, double SpiralFactor, double NumberOfSpirals, double HalfScreenDiagionalLength, boolean Reversed)//32nd Square SpiralFactor = 24.6 For HypnosisSpiral NumberOfSpirals = 1 x&y/3., For More Sprialing Increase Spiral Factor, For Ninja Shrunken; SpiralFactor = 88.8 & NumberOfSpirals = 10 x&y/10., For Universe Generator; SpiralFactor = 66.6 & NumberOfSpirals = 4 x&y/6.,, x->y Relative Factoring Causes Warping Effect, Choose ColorsFactor To Be Same As RepeatFactor Of Rainbow Clock With x & y Precentered Before Accessing This Function And Location Is The Connection To The xSlider Time Changing Variable
	{//Make Math.pow(Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) Into Math.pow(Math.pow(HalfedDim.getWidth() + 1, 2) + Math.pow(HalfedDim.getHeight() + 1, 2), 0.5) Or To SpiralFactor For Ghetto Many Rainbow Clocks
		//System.out.println("x: " + x +" y: " + y);
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) * SpiralFactor * HalfScreenDiagionalLength / 1101.45358504 + ( trueArcTan.ArcTan(x, y) - Math.PI ) * NumberOfSpirals * HalfScreenDiagionalLength;//1101.45358504 = HalfScreenDiagonalLength For FullHD: 1920px X 1080px
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Reversed )
			color.RainbowSoftColorRainbowFunctionReverse( Math.abs( ColorsFactor ), sliderValue ); //
		else
			color.RainbowSoftColorRainbowFunction( Math.abs( ColorsFactor ), sliderValue ); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowSpiralGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, double SpiralFactor, double NumberOfSpirals, double HalfScreenDiagionalLength, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//33rd Square Same As Above Except Gradated Un/Adjusted With Opacity Changes
	{
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) * SpiralFactor * HalfScreenDiagionalLength / 1101.45358504 + ( trueArcTan.ArcTan(x, y) - Math.PI ) * NumberOfSpirals * HalfScreenDiagionalLength;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowSpiralVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, double SpiralFactor, double NumberOfSpirals, double HalfScreenDiagionalLength, Color[] FXcolorArray, boolean Reversed )//34th Square Same As Above Except With Any Amount Of Custom Colors And Not All Accouchriments As Below
	{
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) * SpiralFactor * HalfScreenDiagionalLength / 1101.45358504 + ( trueArcTan.ArcTan(x, y) - Math.PI ) * NumberOfSpirals * HalfScreenDiagionalLength;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if (Reversed)
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsFactor ), sliderValue, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true)); //
		else
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsFactor ), sliderValue, FXcolorArray); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowSpiralGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, double SpiralFactor, double NumberOfSpirals, double HalfScreenDiagionalLength, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//35th Square Same As Above Super Function For Any Custom Colors Clocks Which Is Last Rainbow Disk Function
	{
		originalFormulaValue = Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) * SpiralFactor * HalfScreenDiagionalLength / 1101.45358504 + ( trueArcTan.ArcTan(x, y) - Math.PI ) * NumberOfSpirals * HalfScreenDiagionalLength;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowCheapFractalVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, double DimWidth, boolean Reversed)//36th Square Choose ColorsFactor To Be Same As RepeatFactor Of Rainbow Clock With x & y Precentered Before Accessing This Function And Location Is The Connection To The xSlider Time Changing Variable
	{//Try Instead For Double Trouble: originalFormulaValue = - ( y + 246 * LocationOfColorMovement ) - ( x + 24 * LocationOfColorMovement - 2 * DimWidth ) * Math.pow( Math.abs( LocationOfColorMovement ) , 1.20) / ( y + 0.3871 ) - ( y + 246 * LocationOfStillMovement ) - ( x + 24 * LocationOfStillMovement - 2 * DimWidth ) * Math.pow(LocationOfStillMovement , 1.20) / ( y + 0.3871 );
		originalFormulaValue = - ( y + 246 * LocationOfColorMovement ) - ( x + 24 * LocationOfColorMovement - 2 * DimWidth ) * Math.pow( Math.abs( LocationOfColorMovement ) , 1.20) / ( y + 0.3871 );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Reversed )
			color.RainbowSoftColorRainbowFunctionReverse( Math.abs( ColorsFactor ), sliderValue ); //
		else
			color.RainbowSoftColorRainbowFunction( Math.abs( ColorsFactor ), sliderValue ); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowCheapFractalGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, double DimWidth, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//37th Square Same As Above Except Gradated Un/Adjusted With Opacity Changes
	{
		originalFormulaValue = - ( y + 246 * LocationOfColorMovement ) - ( x + 24 * LocationOfColorMovement - 2 * DimWidth ) * Math.pow( Math.abs( LocationOfColorMovement ) , 1.20) / ( y + 0.3871 );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowCheapFractalVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, double DimWidth, Color[] FXcolorArray, boolean Reversed )//38th Square Same As Above Except With Any Amount Of Custom Colors And Not All Accouchriments As Below
	{
		originalFormulaValue = - ( y + 246 * LocationOfColorMovement ) - ( x + 24 * LocationOfColorMovement - 2 * DimWidth ) * Math.pow( Math.abs( LocationOfColorMovement ) , 1.20) / ( y + 0.3871 );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if (Reversed)
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsFactor ), sliderValue, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true)); //
		else
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsFactor ), sliderValue, FXcolorArray); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowCheapFractalGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, double DimWidth, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//39th Square Same As Above Super Function For Any Custom Colors Clocks Which Is Last Rainbow Disk Function
	{
		originalFormulaValue = - ( y + 246 * LocationOfColorMovement ) - ( x + 24 * LocationOfColorMovement - 2 * DimWidth ) * Math.pow( Math.abs( LocationOfColorMovement ) , 1.20) / ( y + 0.3871 );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowStrobeVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Dimension Dim, Dimension HalfedDim, double HalfScreenDiagionalLength, boolean Reversed)//40th Square Choose ColorsFactor To Be Same As RepeatFactor Of Rainbow Clock With x & y Precentered Before Accessing This Function And Location Is The Connection To The xSlider Time Changing Variable
	{//Try Instead For Double Trouble: originalFormulaValue = - ( y + 246 * LocationOfColorMovement ) - ( x + 24 * LocationOfColorMovement - 2 * DimWidth ) * Math.pow( Math.abs( LocationOfColorMovement ) , 1.20) / ( y + 0.3871 ) - ( y + 246 * LocationOfStillMovement ) - ( x + 24 * LocationOfStillMovement - 2 * DimWidth ) * Math.pow(LocationOfStillMovement , 1.20) / ( y + 0.3871 );
		originalFormulaValue = Math.atan2( (x - HalfedDim.getWidth() + 1) , (y - Dim.getHeight() * 4 / 3 + 1 ) );// For Rising Sun + 1
		originalFormulaValue = ( originalFormulaValue * Math.tan( originalFormulaValue ) ) * HalfScreenDiagionalLength / 4.46783504 + LocationOfColorMovement * HalfScreenDiagionalLength / 1101.45358504;// + Or - xSlider Determines Which Direction It Moves //For Infinite Number Theorem Good a = ( angle * Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider; //a = ( angle Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider;//Use For Rainbow Spiral Multiply radialDistance By 10 To Increase The Number Of Spirals //Use This: "a = ( - angle + Math.PI ) * radialDistance;" Line For Rainbow Clock //a = ( - angle * Math.tan( angle ) + Math.PI ) * radialDistance - xSlider; For Infinite Number Theorem //a = ( - angle * Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 2) + Math.PI ) * radialDistance - xSlider;
		//aVariable = ( angleVariable * %/% Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1) %\% Math.tan( angleVariable ) %/%+ Math.PI%\% ) * radialDistance / 4.46783504 + xSlider;// + Or - xSlider Determines Which Direction It Moves //For Infinite Number Theorem Good a = ( angle * %/%Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1)%\% Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider; //a = ( angle %/%Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1)%\% Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider;//Use For Rainbow Spiral Multiply radialDistance By 10 To Increase The Number Of Spirals //Use This: "a = ( - angle + Math.PI ) * radialDistance;" Line For Rainbow Clock //a = ( - angle * Math.tan( angle ) + Math.PI ) * radialDistance - xSlider; For Infinite Number Theorem //a = ( - angle * Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 2) + Math.PI ) * radialDistance - xSlider;
		originalFormulaValue = originalFormulaValue * 10;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Reversed )
			color.RainbowSoftColorRainbowFunctionReverse( Math.abs( ColorsFactor ), sliderValue ); //
		else
			color.RainbowSoftColorRainbowFunction( Math.abs( ColorsFactor ), sliderValue ); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowStrobeGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Dimension Dim, Dimension HalfedDim, double HalfScreenDiagionalLength, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//41st Square Same As Above Except Gradated Un/Adjusted With Opacity Changes
	{
		originalFormulaValue = Math.atan2( (x - HalfedDim.getWidth() + 1) , (y - Dim.getHeight() * 4 / 3 + 1 ) );// For Rising Sun + 1
		originalFormulaValue = ( originalFormulaValue * Math.tan( originalFormulaValue ) ) * HalfScreenDiagionalLength / 4.46783504 + LocationOfColorMovement * HalfScreenDiagionalLength / 1101.45358504;// + Or - xSlider Determines Which Direction It Moves //For Infinite Number Theorem Good a = ( angle * Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider; //a = ( angle Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider;//Use For Rainbow Spiral Multiply radialDistance By 10 To Increase The Number Of Spirals //Use This: "a = ( - angle + Math.PI ) * radialDistance;" Line For Rainbow Clock //a = ( - angle * Math.tan( angle ) + Math.PI ) * radialDistance - xSlider; For Infinite Number Theorem //a = ( - angle * Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 2) + Math.PI ) * radialDistance - xSlider;
		//aVariable = ( angleVariable * %/% Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1) %\% Math.tan( angleVariable ) %/%+ Math.PI%\% ) * radialDistance / 4.46783504 + xSlider;// + Or - xSlider Determines Which Direction It Moves //For Infinite Number Theorem Good a = ( angle * %/%Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1)%\% Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider; //a = ( angle %/%Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1)%\% Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider;//Use For Rainbow Spiral Multiply radialDistance By 10 To Increase The Number Of Spirals //Use This: "a = ( - angle + Math.PI ) * radialDistance;" Line For Rainbow Clock //a = ( - angle * Math.tan( angle ) + Math.PI ) * radialDistance - xSlider; For Infinite Number Theorem //a = ( - angle * Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 2) + Math.PI ) * radialDistance - xSlider;
		originalFormulaValue = originalFormulaValue * 10;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowStrobeVaryated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Dimension Dim, Dimension HalfedDim, double HalfScreenDiagionalLength, Color[] FXcolorArray, boolean Reversed )//42nd Square Same As Above Except With Any Amount Of Custom Colors And Not All Accouchriments As Below
	{
		originalFormulaValue = Math.atan2( (x - HalfedDim.getWidth() + 1) , (y - Dim.getHeight() * 4 / 3 + 1 ) );// For Rising Sun + 1
		originalFormulaValue = ( originalFormulaValue * Math.tan( originalFormulaValue ) ) * HalfScreenDiagionalLength / 4.46783504 + LocationOfColorMovement * HalfScreenDiagionalLength / 1101.45358504;// + Or - xSlider Determines Which Direction It Moves //For Infinite Number Theorem Good a = ( angle * Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider; //a = ( angle Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider;//Use For Rainbow Spiral Multiply radialDistance By 10 To Increase The Number Of Spirals //Use This: "a = ( - angle + Math.PI ) * radialDistance;" Line For Rainbow Clock //a = ( - angle * Math.tan( angle ) + Math.PI ) * radialDistance - xSlider; For Infinite Number Theorem //a = ( - angle * Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 2) + Math.PI ) * radialDistance - xSlider;
		//aVariable = ( angleVariable * %/% Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1) %\% Math.tan( angleVariable ) %/%+ Math.PI%\% ) * radialDistance / 4.46783504 + xSlider;// + Or - xSlider Determines Which Direction It Moves //For Infinite Number Theorem Good a = ( angle * %/%Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1)%\% Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider; //a = ( angle %/%Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1)%\% Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider;//Use For Rainbow Spiral Multiply radialDistance By 10 To Increase The Number Of Spirals //Use This: "a = ( - angle + Math.PI ) * radialDistance;" Line For Rainbow Clock //a = ( - angle * Math.tan( angle ) + Math.PI ) * radialDistance - xSlider; For Infinite Number Theorem //a = ( - angle * Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 2) + Math.PI ) * radialDistance - xSlider;
		originalFormulaValue = originalFormulaValue * 10;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if (Reversed)
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsFactor ), sliderValue, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true)); //
		else
			color.RainbowSoftCustomColorFunction(Math.abs( ColorsFactor ), sliderValue, FXcolorArray); //
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowStrobeGradated(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Dimension Dim, Dimension HalfedDim, double HalfScreenDiagionalLength, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//43rd Square Same As Above Super Function For Any Custom Colors Clocks Which Is Last Rainbow Disk Function
	{
		originalFormulaValue = Math.atan2( (x - HalfedDim.getWidth() + 1) , (y - Dim.getHeight() * 4 / 3 + 1 ) );// For Rising Sun + 1
		originalFormulaValue = ( originalFormulaValue * Math.tan( originalFormulaValue ) ) * HalfScreenDiagionalLength / 4.46783504 + LocationOfColorMovement * HalfScreenDiagionalLength / 1101.45358504;// + Or - xSlider Determines Which Direction It Moves //For Infinite Number Theorem Good a = ( angle * Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider; //a = ( angle Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider;//Use For Rainbow Spiral Multiply radialDistance By 10 To Increase The Number Of Spirals //Use This: "a = ( - angle + Math.PI ) * radialDistance;" Line For Rainbow Clock //a = ( - angle * Math.tan( angle ) + Math.PI ) * radialDistance - xSlider; For Infinite Number Theorem //a = ( - angle * Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 2) + Math.PI ) * radialDistance - xSlider;
		//aVariable = ( angleVariable * %/% Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1) %\% Math.tan( angleVariable ) %/%+ Math.PI%\% ) * radialDistance / 4.46783504 + xSlider;// + Or - xSlider Determines Which Direction It Moves //For Infinite Number Theorem Good a = ( angle * %/%Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1)%\% Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider; //a = ( angle %/%Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 1)%\% Math.tan( angle ) + Math.PI ) * radialDistance / 4.46783504 - xSlider;//Use For Rainbow Spiral Multiply radialDistance By 10 To Increase The Number Of Spirals //Use This: "a = ( - angle + Math.PI ) * radialDistance;" Line For Rainbow Clock //a = ( - angle * Math.tan( angle ) + Math.PI ) * radialDistance - xSlider; For Infinite Number Theorem //a = ( - angle * Math.cos( angle ) * Math.sin( angle ) * Math.pow(radialVariableDistance, 2) + Math.PI ) * radialDistance - xSlider;
		originalFormulaValue = originalFormulaValue * 10;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowExponentiator(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Dimension Dim, double ExponentValue, double colorFlipper, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//44th Square Same As Above Super Function For Custom Color Exponentiator
	{
		originalFormulaValue = colorFlipper * ColorsFactor * ( ( Math.pow( 1 + x / Dim.getWidth(), ExponentValue ) - 1 ) / NegateZeroDivisorError( Math.pow( 2, ExponentValue ) - 1 ) + y / Dim.getHeight() );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowExponentiator(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Dimension Dim, double ExponentValue, double colorFlipper, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//45th Square Same As Above Super Function For Custom Color Exponentiator
	{
		originalFormulaValue = colorFlipper * ColorsFactor * ( ( Math.pow( 1 + x / Dim.getWidth(), ExponentValue ) - 1 ) / NegateZeroDivisorError( Math.pow( 2, ExponentValue ) - 1 ) + y / Dim.getHeight() );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowDoubleExponentiator(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Dimension Dim, double ExponentValue, double colorFlipper, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//46th Square Same As Above Super Function For Custom Color Exponentiator
	{
		originalFormulaValue = colorFlipper * ColorsFactor * ( ( Math.pow( 1 + x / Dim.getWidth(), ExponentValue ) - 1 ) / NegateZeroDivisorError( Math.pow( 2, ExponentValue ) - 1 ) + Exponentiator ( ExponentValue, y * Dim.getHeight() / Dim.getWidth(), Dim.getHeight() * Dim.getHeight() / Dim.getWidth() ) );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftColorRainbowTransparencyFunctionReverseUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftColorRainbowTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color RainbowDoubleExponentiator(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Dimension Dim, double ExponentValue, double colorFlipper, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//47th Square Same As Above Super Function For Custom Color Exponentiator
	{
		originalFormulaValue = colorFlipper * ColorsFactor * ( ( Math.pow( 1 + x / Dim.getWidth(), ExponentValue ) - 1 ) / NegateZeroDivisorError( Math.pow( 2, ExponentValue ) - 1 ) + Exponentiator ( ExponentValue, y * Dim.getHeight() / Dim.getWidth(), Dim.getHeight() * Dim.getHeight() / Dim.getWidth() ) );
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}

	public Color RainbowFanOutClock(double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, double NumberOfClockHands, double ExponentValue, double FanOutRadius, double RingDisplacement, double InnerCutOffRadius, double OuterCutOffRadius, Color[] FXcolorArray, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )//47th Square Same As Above Super Function For Custom Color Exponentiator
	{
		if ( Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) < InnerCutOffRadius || Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) > OuterCutOffRadius )
		{
			color.set( clear );
			rgb = color.ToRGB();
			argb = color.ToARGB();
			fxColor = color.ToFXColor();
			return fxColor;
		}
		//originalFormulaValue = Exponentiator( 4, trueArcTan.ArcTan(x, y) / NumberOfClockHands, Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) + RingDisplacement, FanOutRadius ) + Math.PI	;
		double radialValue = 0.5 * ExponentValue * ( Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ) + RingDisplacement ) / NegateZeroDivisorError( FanOutRadius );// Multiply By 0.5 * ExponentValue * At Beginning To Make KaladaScope Effect Better, For FanOutClock Take Out: 0.5 * ExponentValue * If In HD
		/*while ( radialValue < 0 )
			radialValue = radialValue + 1;
		while ( radialValue > 1 )
			radialValue = radialValue - 1;// */
		//radialValue = NegateZeroDivisorError(radialValue);
		double adjustedArcTanValue = NumberOfClockHands * trueArcTan.ArcTan(x, y);//NumberOfClockHands * // + Math.PI;
		int arcTanCounter = 0;
		while ( adjustedArcTanValue < - Math.PI )
		{
			adjustedArcTanValue = adjustedArcTanValue + 2 * Math.PI;
			arcTanCounter--;
		}
		while ( adjustedArcTanValue > Math.PI )
		{
			adjustedArcTanValue = adjustedArcTanValue - 2 * Math.PI;
			arcTanCounter++;
		}// */
		//adjustedArcTanValue = NegateZeroDivisorError(adjustedArcTanValue);
		originalFormulaValue = ExponentValue * adjustedArcTanValue * ( Math.pow( 1 + radialValue, ExponentValue ) - 1 ) / NegateZeroDivisorError( Math.pow( 2, ExponentValue ) - 1 ) / NumberOfClockHands + Math.PI * ( 2 * arcTanCounter + 1 );//UnComment This Line And Use Instead Of Other For 54th Try KaladaScope Effect
		//riginalFormulaValue = adjustedArcTanValue * ( 4 / NegateZeroDivisorError( radialValue * ExponentValue/*( Math.pow( 2 - radialValue, 2 / ExponentValue ) - 1 )*/ * NumberOfClockHands ) ) + Math.PI * ( 2 * arcTanCounter + 1 );//Uncomment For FanOutClock, For UltraHD 4 / Instead Of 2 / Or 1 / Then Comment Above Line As Well
		/*while ( originalFormulaValue < 0 )
			originalFormulaValue = originalFormulaValue + 2 * Math.PI;
		while ( originalFormulaValue > 2 * Math.PI )
			originalFormulaValue = originalFormulaValue - 2 * Math.PI;// */
		//originalFormulaValue = originalFormulaValue + Math.PI;
		if (  LocationOfStillMovement == 0 && FullSliderRunThrough > 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, Math.signum(RepeatFactor) * LocationOfColorMovement, Math.abs(RepeatFactor), FullSliderRunThrough );
		else if ( LocationOfStillMovement == 0 )//Above Provides NonAligned RepeatFactor/ColorsLength != 1 For Shrinked[>1] And Abridged Rainbow[<1]
			sliderValue = SliderFormulateJustMovingColors( ColorsFactor, originalFormulaValue, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		else
			if ( LocationOfColorMovement == 0 )
				sliderValue = SliderFormulateSlidingTransitionsSameColors( ColorsFactor, originalFormulaValue, LocationOfStillMovement, RepeatFactor, FullSliderRunThrough );
			else
				sliderValue = SliderFormulateDoubleSliding( ColorsFactor, originalFormulaValue, LocationOfStillMovement, LocationOfColorMovement, RepeatFactor, FullSliderRunThrough );
		if ( Adjusted )
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		else
			if ( Reversed )
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray(FXcolorArray, false, true, true), OpacityBefore, OpacityAfter);
			else
				color.RainbowSoftCustomColorTransparencyFunctionUnAdjusted(Math.abs( ColorsFactor ), sliderValue, BrightnessMultiplyer, Gradations, FXcolorArray, OpacityBefore, OpacityAfter);
		rgb = color.ToRGB();
		argb = color.ToARGB();
		fxColor = color.ToFXColor();
		return fxColor;
	}

	public double Exponentiator(double ExponentValue, double SliderValue, double SliderRange )
	{
		return ( Math.pow( 1 + SliderValue / SliderRange, ExponentValue ) - 1 ) / NegateZeroDivisorError( Math.pow( 2, ExponentValue ) - 1 );
	}
	public double Exponentiator(double ExponentValue, double SliderValue, double SliderStart, double SliderFinish )//48th Square With The 49th For To Be Built Tangent Based Sparkle And The 50th For Future Planned Radial Re-Rainbow Fan Out Where Rainbows Exponentiate Radially And Colors Fan Out With Longer Radial Position To Fan Out Exponentially...
	{
		return ( Math.pow( 1 + SliderValue / ( SliderFinish - SliderStart ), ExponentValue ) - 1 ) / NegateZeroDivisorError( Math.pow( 2, ExponentValue ) - 1 );
	}

	public double NegateZeroDivisorError(double Divisor)
	{
		if ( Divisor < -0.0001 || Divisor > 0.0001 )
			return Divisor;
		else
			return 0.0001;
	}

	//Add RainbowWidth To Selector And Full Selector
	public Color Selector( String Selection, int SubSelection, double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Dimension Dim, Dimension HalfedDim, Color[][] FXcolorSet, double NumberOfClockHands, double FanOutRadius, double RingDisplacement, double InnerCutOffRadius, double OuterCutOffRadius, double SpiralFactor, double NumberOfSpirals, double HalfScreenDiagionalLength, double ExponentValue, double colorFlipper, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )
	{//"TransparencySliderFunction", "RainbowSoftColorFunction", "SimpleRainbow", "SimpleRainbowReverse", "SimpleCustomColor", "RainbowDiskVaryated", "RainbowDiskGradated", "RainbowRingVaryated", "RainbowRingGradated", "RainbowClockVaryated", "RainbowClockGradated", "RainbowSpiralVaryated", "RainbowSpiralGradated", "RainbowCheapFractalVaryated", "RainbowCheapFractalGradated", "RainbowStrobeVaryated", "RainbowStrobeGradated", "RainbowExponentiator", "RainbowDoubleExponentiator"
		if ( Selection == "TransparencySliderFunction" )
			fxColor = TransparencySliderFunction( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, x + HalfedDim.getWidth(), BrightnessMultiplyer, Gradations, FXcolorSet[0][0], FXcolorSet[0][1], OpacityBefore, OpacityAfter);
		else if ( Selection == "RainbowSoftColorFunction" )
			fxColor = RainbowSoftColorFunction( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, new RainbowSoftColor(FXcolorSet[0][0]), new RainbowSoftColor(FXcolorSet[0][1]));
		else if ( Selection == "SimpleRainbow" )
			fxColor = SimpleRainbow( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else if ( Selection == "SimpleRainbowReverse" )
			fxColor = SimpleRainbowReverse( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else if ( Selection == "SimpleCustomColor" )
			fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, FXcolorSet[0], OpacityBefore, OpacityAfter, Adjusted, Reversed );
		else if ( Selection == "DiskVaryated" )
			fxColor = RainbowDiskVaryated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, FXcolorSet[0], Reversed);
		else if ( Selection == "DiskGradated" )
			fxColor = RainbowDiskGradated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else if ( Selection == "RingVaryated" )
			fxColor = RainbowRingVaryated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, RingDisplacement, InnerCutOffRadius, OuterCutOffRadius, FXcolorSet[0], Reversed);
		else if ( Selection == "RingGradated" )
			fxColor = RainbowRingGradated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, RingDisplacement, InnerCutOffRadius, OuterCutOffRadius, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else if ( Selection == "ClockVaryated" )
			fxColor = RainbowClockVaryated( 2 * Math.PI * ColorsFactor / FullSliderRunThrough, 2 * Math.PI * LocationOfStillMovement / FullSliderRunThrough, 2 * Math.PI * LocationOfColorMovement / FullSliderRunThrough, x, y, 2 * Math.PI * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, FXcolorSet[0], Reversed );
		else if ( Selection == "ClockGradated" )
			fxColor = RainbowClockGradated( 2 * Math.PI * ColorsFactor / FullSliderRunThrough, 2 * Math.PI * LocationOfStillMovement / FullSliderRunThrough, 2 * Math.PI * LocationOfColorMovement / FullSliderRunThrough, x, y, 2 * Math.PI * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else if ( Selection == "SpiralVaryated" )
			fxColor = RainbowSpiralVaryated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, SpiralFactor, NumberOfSpirals, HalfScreenDiagionalLength, FullSliderRunThrough, FXcolorSet[0], Reversed );
		else if ( Selection == "SpiralGradated" )
			fxColor = RainbowSpiralGradated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, SpiralFactor, NumberOfSpirals, HalfScreenDiagionalLength, FullSliderRunThrough, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else if ( Selection == "CheapFractalVaryated" )
			fxColor = RainbowCheapFractalVaryated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, FullSliderRunThrough, Dim.getWidth(), FXcolorSet[0], Reversed );
		else if ( Selection == "CheapFractalGradated" )
			fxColor = RainbowCheapFractalGradated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, FullSliderRunThrough, Dim.getWidth(), FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else if ( Selection == "StrobeVaryated" )
			fxColor = RainbowStrobeVaryated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, HalfedDim, HalfScreenDiagionalLength, FXcolorSet[0], Reversed );
		else if ( Selection == "StrobeGradated" )
			fxColor = RainbowStrobeGradated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, HalfedDim, HalfScreenDiagionalLength, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else if ( Selection == "Exponentiator" )
			fxColor = RainbowExponentiator( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, ExponentValue, colorFlipper, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else if ( Selection == "DoubleExponentiator" )
			fxColor = RainbowDoubleExponentiator( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, ExponentValue, colorFlipper, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else if ( Selection == "FanOutClock" )
			fxColor = RainbowFanOutClock( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, NumberOfClockHands, ExponentValue, FanOutRadius, RingDisplacement, InnerCutOffRadius, OuterCutOffRadius, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else
			fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, fireFXcolors, OpacityBefore, OpacityAfter, Adjusted, Reversed );
		return fxColor;
	}

	public Color FullSelector( String Selection, int SubSelection, double ColorsFactor, double LocationOfStillMovement, double LocationOfColorMovement, double x, double y, double RepeatFactor, double FullSliderRunThrough, Dimension Dim, Dimension HalfedDim, Color[][] FXcolorSet, double NumberOfClockHands, double FanOutRadius, double RingDisplacement, double InnerCutOffRadius, double OuterCutOffRadius, double SpiralFactor, double NumberOfSpirals, double HalfScreenDiagionalLength, double ExponentValue, double colorFlipper, boolean Reversed, double BrightnessMultiplyer, int Gradations, double OpacityBefore, double OpacityAfter, boolean Adjusted )
	{//"TransparencySliderFunction", "RainbowSoftColorFunction", "SimpleRainbow", "SimpleRainbowReverse", "SimpleCustomColor", "DiskVaryated", "DiskGradated", "RingVaryated", "RingGradated", "ClockVaryated", "ClockGradated", "SpiralVaryated", "SpiralGradated", "CheapFractalVaryated", "CheapFractalGradated", "StrobeVaryated", "StrobeGradated", "Exponentiator", "DoubleExponentiator"
		if ( Selection == "TransparencySliderFunction" )
			switch (SubSelection)
			{
			case 0: fxColor = TransparencySliderFunction( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, x + HalfedDim.getWidth(), BrightnessMultiplyer, Gradations, FXcolorSet[0][0], FXcolorSet[0][1], OpacityBefore, OpacityAfter ); break;
			case 1: fxColor = TransparencySliderFunction( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, x + HalfedDim.getWidth(), FXcolorSet[0][0], FXcolorSet[0][1] ); break;
			}
		else if ( Selection == "RainbowSoftColorFunction" )
			fxColor = RainbowSoftColorFunction( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, new RainbowSoftColor(FXcolorSet[0][0]), new RainbowSoftColor(FXcolorSet[0][1]) );
		else if ( Selection == "SimpleRainbow" )
			switch (SubSelection)
			{
			case 0: fxColor = SimpleRainbow( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 1: fxColor = SimpleRainbow( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter ); break;
			case 2: fxColor = SimpleRainbow( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, Adjusted ); break;
			case 3: fxColor = SimpleRainbow( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations ); break;
			case 4: fxColor = SimpleRainbow( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough ); break;
			}
		else if ( Selection == "SimpleRainbowReverse" )
			switch (SubSelection)
			{
			case 0: fxColor = SimpleRainbowReverse( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 1: fxColor = SimpleRainbowReverse( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter ); break;
			case 2: fxColor = SimpleRainbowReverse( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, Adjusted ); break;
			case 3: fxColor = SimpleRainbowReverse( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations ); break;
			case 4: fxColor = SimpleRainbowReverse( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough ); break;
			}
		else if ( Selection == "SimpleCustomColor" )
			switch (SubSelection)
			{
			case 0: fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, FXcolorSet[0], OpacityBefore, OpacityAfter, Adjusted, Reversed ); break;
			case 1: fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, FXcolorSet[0], OpacityBefore, OpacityAfter, Adjusted ); break;
			case 2: fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, imperialColorsNum, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 3: fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, FXcolorSet[0], Adjusted ); break;
			case 4: fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, FXcolorSet[0] ); break;
			case 5: fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, imperialColorsNum, Adjusted ); break;
			case 6: fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, imperialColorsNum ); break;
			case 7: fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, FXcolorSet[0], Reversed ); break;
			case 8: fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, imperialColorsNum ); break;
			case 9: fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, FXcolorSet[0] ); break;
			}
		else if ( Selection == "DiskVaryated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowDiskVaryated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, FXcolorSet[0], Reversed); break;
			case 1: fxColor = RainbowDiskVaryated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, Reversed); break;
			}
		else if ( Selection == "DiskGradated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowDiskGradated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 1: fxColor = RainbowDiskGradated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			}
		else if ( Selection == "RingVaryated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowRingVaryated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, RingDisplacement, InnerCutOffRadius, OuterCutOffRadius, FXcolorSet[0], Reversed); break;
			case 1: fxColor = RainbowRingVaryated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, RingDisplacement, InnerCutOffRadius, OuterCutOffRadius, Reversed); break;
			}
		else if ( Selection == "RingGradated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowRingGradated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, RingDisplacement, InnerCutOffRadius, OuterCutOffRadius, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 1: fxColor = RainbowRingGradated( HalfedDim.getHeight() * ColorsFactor / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfStillMovement / FullSliderRunThrough, HalfedDim.getHeight() * LocationOfColorMovement / FullSliderRunThrough, x, y, HalfedDim.getHeight() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, RingDisplacement, InnerCutOffRadius, OuterCutOffRadius, Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			}
		else if ( Selection == "ClockVaryated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowClockVaryated( 2 * Math.PI * ColorsFactor / FullSliderRunThrough, 2 * Math.PI * LocationOfStillMovement / FullSliderRunThrough, 2 * Math.PI * LocationOfColorMovement / FullSliderRunThrough, x, y, 2 * Math.PI * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, FXcolorSet[0], Reversed ); break;
			case 1: fxColor = RainbowClockVaryated( 2 * Math.PI * ColorsFactor / FullSliderRunThrough, 2 * Math.PI * LocationOfStillMovement / FullSliderRunThrough, 2 * Math.PI * LocationOfColorMovement / FullSliderRunThrough, x, y, 2 * Math.PI * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, Reversed ); break;
			}
		else if ( Selection == "ClockGradated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowClockGradated( 2 * Math.PI * ColorsFactor / FullSliderRunThrough, 2 * Math.PI * LocationOfStillMovement / FullSliderRunThrough, 2 * Math.PI * LocationOfColorMovement / FullSliderRunThrough, x, y, 2 * Math.PI * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 1: fxColor = RainbowClockGradated( 2 * Math.PI * ColorsFactor / FullSliderRunThrough, 2 * Math.PI * LocationOfStillMovement / FullSliderRunThrough, 2 * Math.PI * LocationOfColorMovement / FullSliderRunThrough, x, y, 2 * Math.PI * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			}
		else if ( Selection == "SpiralVaryated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowSpiralVaryated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, FullSliderRunThrough, SpiralFactor, NumberOfSpirals, HalfScreenDiagionalLength, FXcolorSet[0], Reversed ); break;
			case 1: fxColor = RainbowSpiralVaryated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, FullSliderRunThrough, SpiralFactor, NumberOfSpirals, HalfScreenDiagionalLength, Reversed ); break;
			}
		else if ( Selection == "SpiralGradated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowSpiralGradated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, FullSliderRunThrough, SpiralFactor, NumberOfSpirals, HalfScreenDiagionalLength, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 1: fxColor = RainbowSpiralGradated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, FullSliderRunThrough, SpiralFactor, NumberOfSpirals, HalfScreenDiagionalLength, Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			}
		else if ( Selection == "CheapFractalVaryated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowCheapFractalVaryated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, FullSliderRunThrough, Dim.getWidth(), FXcolorSet[0], Reversed ); break;
			case 1: fxColor = RainbowCheapFractalVaryated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, FullSliderRunThrough, Dim.getWidth(), Reversed ); break;
			}
		else if ( Selection == "CheapFractalGradated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowCheapFractalGradated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, FullSliderRunThrough, Dim.getWidth(), FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 1: fxColor = RainbowCheapFractalGradated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x, y, RepeatFactor, FullSliderRunThrough, Dim.getWidth(), Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			}
		else if ( Selection == "StrobeVaryated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowStrobeVaryated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, HalfedDim, HalfScreenDiagionalLength, FXcolorSet[0], Reversed ); break;
			case 1: fxColor = RainbowStrobeVaryated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, HalfedDim, HalfScreenDiagionalLength, Reversed ); break;
			}
		else if ( Selection == "StrobeGradated" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowStrobeGradated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, HalfedDim, HalfScreenDiagionalLength, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 1: fxColor = RainbowStrobeGradated( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, HalfedDim, HalfScreenDiagionalLength, Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			}
		else if ( Selection == "Exponentiator" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowExponentiator( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, ExponentValue, colorFlipper, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 1: fxColor = RainbowExponentiator( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, ExponentValue, colorFlipper, Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			}
		else if ( Selection == "DoubleExponentiator" )
			switch (SubSelection)
			{
			case 0: fxColor = RainbowDoubleExponentiator( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, ExponentValue, colorFlipper, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			case 1: fxColor = RainbowDoubleExponentiator( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, Dim, ExponentValue, colorFlipper, Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted ); break;
			}
		else if ( Selection == "FanOutClock" )
			fxColor = RainbowFanOutClock( ColorsFactor, LocationOfStillMovement, LocationOfColorMovement, x + HalfedDim.getWidth(), y + HalfedDim.getHeight(), RepeatFactor, FullSliderRunThrough, NumberOfClockHands, ExponentValue, FanOutRadius, RingDisplacement, InnerCutOffRadius, OuterCutOffRadius, FXcolorSet[0], Reversed, BrightnessMultiplyer, Gradations, OpacityBefore, OpacityAfter, Adjusted );
		else
			fxColor = SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, fireFXcolors, OpacityBefore, OpacityAfter, Adjusted, Reversed );
		return fxColor;
		//return SimpleCustomColor( Dim.getWidth() * ColorsFactor / FullSliderRunThrough, Dim.getWidth() * LocationOfStillMovement / FullSliderRunThrough, Dim.getWidth() * LocationOfColorMovement / FullSliderRunThrough, x + HalfedDim.getWidth(), Dim.getWidth() * RepeatFactor / FullSliderRunThrough, FullSliderRunThrough, BrightnessMultiplyer, Gradations, colorArrayReverser.ReverseArray( vibrantColorCombos.FireFXcolors, false, true, true ), OpacityBefore, OpacityAfter, Adjusted, Reversed );
	}


	//Build SimpleRainbowPattern2DDiagnosticsClass.java First With Color To Similar Tested In ???27th??? Square In In SimpleDiagnosticsClass.java 3 Horizontal x 9 Vertical Under 3 Bars
	//Formula String At End Of Complex Labeled Objects Instead Of Simple Labeled Objects
	//Formula Solver Which Reads Formula String And Processes Formula Into Location Within Color Interval Or OutPuts Same Location With Console Readout "Formula Not Found, No Formula Used -> Variable Sent Through Formula Processor Without Change."
	//Build ComplexRainbowPattern2DDiagnosticsClass.java Before Testing More Than 1 Formula
	public double SliderFormulateJustMovingColors( double ColorsLength, double FormulaValue, double LocationOfColorMovement, double RepeatLength, double FullSliderRunThrough )
	{//System.out.println("FormulaValue = " + FormulaValue);
		boolean negativeColorsLength = false, negativeRepeatLength = false;//, negitiveFullSliderRunThrough = false;
		if ( ColorsLength < 0 )
		{
			negativeColorsLength = true;
			ColorsLength = Math.abs( ColorsLength );
		}
		if ( RepeatLength < 0 )
		{
			negativeRepeatLength = true;
			RepeatLength = Math.abs( RepeatLength );
		}
		//if ( FullSliderRunThrough < 0 )
		//	negitiveFullSliderRunThrough = true;
		if ( ColorsLength < 0.001 )
			ColorsLength = 0.001;
		if ( RepeatLength < 0.001 )
			RepeatLength = 0.001;
		if ( RepeatLength == ColorsLength )
		{//AFTER DIAGNOSTICS FINISHED COMPLETELY Don't Do This As It Won't Fix Anomoles; Ctrl-f And Replace Relevant " < " With " <= " Then " > " With " >= " Copy And Paste Back To Get Rid Of Pixel Artifacts If They Happen On fRateDivisor >~192
			if ( negativeRepeatLength && negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				FormulaValue = FormulaValue - LocationOfColorMovement;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				if ( FormulaValue - RepeatLength <= -RepeatLength / 2 )
					FormulaValue = FormulaValue + 2 * RepeatLength; 
				return FormulaValue - RepeatLength;// */
			}
			else if ( negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				FormulaValue = FormulaValue - LocationOfColorMovement;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				//System.out.println("RepeatLength - FormulaValue: " + ( RepeatLength - FormulaValue ) );
				return RepeatLength - FormulaValue;// */
			}
			else if ( negativeRepeatLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				FormulaValue = FormulaValue - LocationOfColorMovement;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				if ( FormulaValue >= RepeatLength / 2 )
				{
					FormulaValue = FormulaValue + 3 * RepeatLength / 2;
					return FormulaValue - RepeatLength;
				}
				return -FormulaValue;// */
			}
			else
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				FormulaValue = FormulaValue - LocationOfColorMovement;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;// */
			}
		}
		else if ( RepeatLength < ColorsLength )	
		{//NM Replace With The Code Below Below Function??? Work On Simplifying: FormulaValue = ColorsLength - FormulaValue;
			if ( negativeRepeatLength && negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = - FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfColorMovement = - LocationOfColorMovement * RepeatLength / ColorsLength;
				while ( LocationOfColorMovement <= 0 )
				{
					LocationOfColorMovement = LocationOfColorMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfColorMovement >= RepeatLength )
				{
					LocationOfColorMovement = LocationOfColorMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				FormulaValue = FormulaValue - LocationOfColorMovement + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
				FormulaValue = ColorsLength - FormulaValue;//Critical Change
				while ( ColorsLength - FormulaValue <= 0 )
					FormulaValue = FormulaValue - ColorsLength;
				while ( ColorsLength - FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue + ColorsLength;
				if ( FormulaValue - ColorsLength <= -ColorsLength / 2 )
					FormulaValue = FormulaValue + 2 * ColorsLength;
				return FormulaValue - ColorsLength;// */
			}
			else if ( negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = - FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfColorMovement = - LocationOfColorMovement * RepeatLength / ColorsLength;
				while ( LocationOfColorMovement <= 0 )
				{
					LocationOfColorMovement = LocationOfColorMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfColorMovement >= RepeatLength )
				{
					LocationOfColorMovement = LocationOfColorMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				FormulaValue = FormulaValue - LocationOfColorMovement + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
			}
			else if ( negativeRepeatLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfColorMovement = - LocationOfColorMovement * RepeatLength / ColorsLength;
				while ( LocationOfColorMovement <= 0 )
				{
					LocationOfColorMovement = LocationOfColorMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfColorMovement >= RepeatLength )
				{
					LocationOfColorMovement = LocationOfColorMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				FormulaValue = FormulaValue - LocationOfColorMovement + numberOfTransitions * RepeatLength;
				FormulaValue = FormulaValue - ColorsLength / 2;//New
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
				if ( FormulaValue >= ColorsLength / 2 )
					return FormulaValue + ColorsLength / 2;
				else
					return - FormulaValue - ColorsLength / 2;
				//return 99;// */ Potential Problem
			}
			else
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfColorMovement = - LocationOfColorMovement * RepeatLength / ColorsLength;
				while ( LocationOfColorMovement <= 0 )
				{
					LocationOfColorMovement = LocationOfColorMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfColorMovement >= RepeatLength )
				{
					LocationOfColorMovement = LocationOfColorMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				FormulaValue = FormulaValue - LocationOfColorMovement + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
			}
		}
		else
		{
			if ( negativeRepeatLength && negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;
				FormulaValue = - FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfColorMovement = - LocationOfColorMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( LocationOfColorMovement <= 0 )
				{
					LocationOfColorMovement = LocationOfColorMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfColorMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfColorMovement = LocationOfColorMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				FormulaValue = FormulaValue - LocationOfColorMovement + numberOfTransitions * RepeatLength + ( RepeatLength + ColorsLength ) / 2;//Leave For Desyncronization !TEST?
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
				FormulaValue = RepeatLength - FormulaValue;//Critical Change
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				if ( FormulaValue - RepeatLength <= -RepeatLength / 2 )
					FormulaValue = FormulaValue + 2 * RepeatLength; 
				return FormulaValue - RepeatLength;// ( - )// */
			}//Work On Below
			else if ( negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;
				FormulaValue = - FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfColorMovement = - LocationOfColorMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( LocationOfColorMovement <= 0 )
				{
					LocationOfColorMovement = LocationOfColorMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfColorMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfColorMovement = LocationOfColorMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				FormulaValue = FormulaValue - LocationOfColorMovement + numberOfTransitions * RepeatLength + ( RepeatLength + ColorsLength ) / 2;//Leave For Desyncronization !TEST?
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
			}
			else if ( negativeRepeatLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;
				FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfColorMovement = - LocationOfColorMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( LocationOfColorMovement <= 0 )
				{
					LocationOfColorMovement = LocationOfColorMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfColorMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfColorMovement = LocationOfColorMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				FormulaValue = FormulaValue - LocationOfColorMovement + numberOfTransitions * RepeatLength + ( RepeatLength + ColorsLength ) / 2;//Leave For Desyncronization !TEST?
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
				//Bad FormulaValue = - FormulaValue / RepeatLength;//Critical Change
				//Put In All 3 Places Maybe: FomulaValue = Formula Value + ColorsLength / 2 But That Happens At The Top
				FormulaValue = FormulaValue - ColorsLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				if ( FormulaValue >= RepeatLength / 2 )
				{
					FormulaValue = FormulaValue + 3 * RepeatLength / 2;
					return FormulaValue - RepeatLength;
				}
				return -FormulaValue;// */
			}
			else
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;
				FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfColorMovement = - LocationOfColorMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( LocationOfColorMovement <= 0 )
				{
					LocationOfColorMovement = LocationOfColorMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfColorMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfColorMovement = LocationOfColorMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				FormulaValue = FormulaValue - LocationOfColorMovement + numberOfTransitions * RepeatLength + ( RepeatLength + ColorsLength ) / 2;//Leave For Desyncronization !TEST?
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
			}
		}
		return FormulaValue;
	}
	public double SliderFormulateSlidingTransitionsSameColors( double ColorsLength, double FormulaValue, double LocationOfStillMovement, double RepeatLength, double FullSliderRunThrough )
	{//System.out.println("FormulaValue = " + FormulaValue);
		boolean negativeColorsLength = false, negativeRepeatLength = false, negitiveFullSliderRunThrough = false;
		if ( ColorsLength < 0 )
		{
			negativeColorsLength = true;
			ColorsLength = Math.abs( ColorsLength );
		}
		if ( RepeatLength < 0 )
		{
			negativeRepeatLength = true;
			RepeatLength = Math.abs( RepeatLength );
		}
		if ( FullSliderRunThrough < 0 )
			negitiveFullSliderRunThrough = true;
		if ( ColorsLength < 0.001 )
			ColorsLength = 0.001;
		if ( RepeatLength < 0.001 )
			RepeatLength = 0.001;
		//FormulaValue = FormulaValue - LocationOfStillMovement; //And Get Rid Of Other LocationOfStillMovement In Slider Formulate For Spinning Same Colors
		if ( RepeatLength == ColorsLength )
		{//WORK ON ALL 9
			if ( negativeRepeatLength && negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = + LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				//if ( LocationOfStillMovement <= FormulaValue || LocationOfStillMovement <= RepeatLength - FormulaValue )
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				/*if ( negitiveFullSliderRunThrough )//Usefull Implimenting In All Pattern2D Formulates To Cause Just Solid Color Ends To Patternize
				{
					if ( FormulaValue - RepeatLength <= -RepeatLength / 2 )
						FormulaValue = FormulaValue + 2 * RepeatLength; 
					return FormulaValue - RepeatLength;
				}// */
			}
			else if ( negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = - LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				//if ( LocationOfStillMovement >= FormulaValue || LocationOfStillMovement >= RepeatLength - FormulaValue )//Use This Line Instead Of Below To Do JustMovingColors Slide To Split At Rainbow Center: xSlider/2 To StillSingleSliders And It Can Be Done With Just PieceWise System Usage Too
				//if ( LocationOfStillMovement <= FormulaValue )//Use This Line Instead Of Below To Have Still Movement Opening Up Into DoubleStill Movement
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				//System.out.println("RepeatLength - FormulaValue: " + ( RepeatLength - FormulaValue ) );
				/*return RepeatLength - FormulaValue;// */
			}
			else if ( negativeRepeatLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = - LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue - LocationOfStillMovement + numberOfTransitions * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement <= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
				/*if ( negitiveFullSliderRunThrough )
				{
					if ( FormulaValue >= RepeatLength / 2 )
					{
						FormulaValue = FormulaValue + 3 * RepeatLength / 2;
						return FormulaValue - RepeatLength;
					}
					return -FormulaValue;
				}// */
			}
			else
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + numberOfTransitions * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement + numberOfTransitions * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
				/*while ( LocationOfStillMovement <= 0 )
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
				while ( LocationOfStillMovement >= RepeatLength )
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
				if ( FormulaValue >= LocationOfStillMovement )
					FormulaValue = FormulaValue - LocationOfStillMovement;//Uncomment For Cool Error */ 
				/*while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;// */
			}
		}
		else if ( RepeatLength < ColorsLength )	
		{
			if ( negativeRepeatLength && negativeColorsLength )
			{//WORK ON ALL 9
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement <= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
				//FormulaValue = ColorsLength - FormulaValue;//Critical Change
				FormulaValue = FormulaValue - ColorsLength / 2;//New
				while ( ColorsLength - FormulaValue <= 0 )
					FormulaValue = FormulaValue - ColorsLength;
				while ( ColorsLength - FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue + ColorsLength;
				/*if ( FormulaValue - ColorsLength <= -ColorsLength / 2 )
					FormulaValue = FormulaValue + 2 * ColorsLength; 
				return FormulaValue - ColorsLength;// */
			}
			else if ( negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = - LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
			}
			else if ( negativeRepeatLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = - LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement <= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
				//Bad FormulaValue = - FormulaValue / RepeatLength;//Critical Change
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue - ColorsLength;
				/*if ( negitiveFullSliderRunThrough )
				{
					if ( FormulaValue >= ColorsLength / 2 )
						return FormulaValue + ColorsLength / 2;
					else
						return - FormulaValue - ColorsLength / 2;
				}// */
			}
			else
			{//CHECK THE LINE BELOW TO SEE IF THIS WORKS FOR ASYNCRONOUSLY IMPROPERLY UNFACTORABLE SETTINGS OF RepeatLength And ColorsLength
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + numberOfTransitions * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement + numberOfTransitions * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )//CHECK FOR THIS KIND OF INSTANCE IF THERE IS A SINGULAR LINE ANOMOLY
					FormulaValue = FormulaValue - ColorsLength;// */
				//System.out.println("numberOfTransitions: " + numberOfTransitions);
				//return FormulaValue;
			}
		}
		else
		{//WORK ON ALL 9
			if ( negativeRepeatLength && negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;//0; //- 2 * ( RepeatLength / ColorsLength + 1 );//- ( 2 * ColorsLength ) / RepeatLength;//- ( 2 * ColorsLength ) / RepeatLength;
				FormulaValue = - FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;// + ( RepeatLength + ColorsLength ) / 2;// ColorsLength / 2; // + RepeatLength
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				//FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2;
				LocationOfStillMovement = LocationOfStillMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;// + ( RepeatLength + ColorsLength ) / 2;// + RepeatLength / 2
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement <= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;//Leave For Desyncronization !TEST?
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
				FormulaValue = RepeatLength - FormulaValue;//Critical Change
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				/*if ( FormulaValue - RepeatLength <= -RepeatLength / 2 )
					FormulaValue = FormulaValue + 2 * RepeatLength; 
				//return RepeatLength - FormulaValue;// ( - )// */
			}
			else if ( negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;//0; //- 2 * ( RepeatLength / ColorsLength + 1 );//- ( 2 * ColorsLength ) / RepeatLength;//- ( 2 * ColorsLength ) / RepeatLength;
				FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;// + ( RepeatLength + ColorsLength ) / 2;// ColorsLength / 2; // + RepeatLength
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				//FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2;
				LocationOfStillMovement = - LocationOfStillMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;// + ( RepeatLength + ColorsLength ) / 2;// + RepeatLength / 2
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
			}
			else if ( negativeRepeatLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;//0; //- 2 * ( RepeatLength / ColorsLength + 1 );//- ( 2 * ColorsLength ) / RepeatLength;//- ( 2 * ColorsLength ) / RepeatLength;
				FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;// + ( RepeatLength + ColorsLength ) / 2;// ColorsLength / 2; // + RepeatLength
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				//FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2;
				LocationOfStillMovement = - LocationOfStillMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;// + ( RepeatLength + ColorsLength ) / 2;// + RepeatLength / 2
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength + ( RepeatLength + ColorsLength ) / 2;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else // */
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength + ( RepeatLength + ColorsLength ) / 2;//Leave For Desyncronization !TEST?
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;//Leave For Desyncronization !TEST?
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
				//Bad FormulaValue = - FormulaValue / RepeatLength;//Critical Change
				FormulaValue = FormulaValue - ColorsLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				/*if ( negitiveFullSliderRunThrough )
				{
					if ( FormulaValue >= RepeatLength / 2 )
					{
						FormulaValue = FormulaValue + 3 * RepeatLength / 2;
						return FormulaValue - RepeatLength;
					}
					return -FormulaValue;
				}// */
			}
			else
			{//CHECK THE LINE BELOW TO SEE IF THIS WORKS FOR ASYNCRONOUSLY IMPROPERLY UNFACTORABLE SETTINGS OF RepeatLength And ColorsLength
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;//0; //- 2 * ( RepeatLength / ColorsLength + 1 );//- ( 2 * ColorsLength ) / RepeatLength;//- ( 2 * ColorsLength ) / RepeatLength;
				FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;// + ( RepeatLength + ColorsLength ) / 2;// ColorsLength / 2; // + RepeatLength
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				//FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2;
				LocationOfStillMovement = LocationOfStillMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;// + ( RepeatLength + ColorsLength ) / 2;// + RepeatLength / 2
				while ( LocationOfStillMovement <= 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + numberOfTransitions * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement + numberOfTransitions * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;//Leave For Desyncronization !TEST?
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
				//System.out.println("numberOfTransitions: " + numberOfTransitions);
			}
		}
		return FormulaValue;
	}
	public double SliderFormulateDoubleSliding( double ColorsLength, double FormulaValue, double LocationOfStillMovement, double LocationOfColorMovement, double RepeatLength, double FullSliderRunThrough )//Spinning In Terms Of Colors And Repeated Segments Spinning
	{//System.out.println("FormulaValue = " + FormulaValue);
		boolean negativeColorsLength = false, negativeRepeatLength = false, negitiveFullSliderRunThrough = false;
		numberOfStillTransitions = 0; numberOfColorTransitions = 0;
		if ( ColorsLength < 0 )
		{
			negativeColorsLength = true;
			ColorsLength = Math.abs( ColorsLength );
		}
		if ( RepeatLength < 0 )
		{
			negativeRepeatLength = true;
			RepeatLength = Math.abs( RepeatLength );
		}
		if ( FullSliderRunThrough < 0 )
			negitiveFullSliderRunThrough = true;
		if ( ColorsLength < 0.001 )
			ColorsLength = 0.001;
		if ( RepeatLength < 0.001 )
			RepeatLength = 0.001;
		FormulaValue = FormulaValue + LocationOfColorMovement;
		if ( RepeatLength == ColorsLength )
		{
			//FormulaValue = 0; //For Testing Specific SubFunction Only
			if ( negativeRepeatLength && negativeColorsLength )
			{
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = + LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				/*if ( negitiveFullSliderRunThrough && LocationOfStillMovement <= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement - ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;// */
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue - ColorsLength;// */
				/*while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				/*if ( FormulaValue - RepeatLength <= -RepeatLength / 2 )
					FormulaValue = FormulaValue + 2 * RepeatLength; 
				return FormulaValue - RepeatLength;// */
			}
			else if ( negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = - LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue - ColorsLength;// */
				/*while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				//System.out.println("RepeatLength - FormulaValue: " + ( RepeatLength - FormulaValue ) );
				return RepeatLength - FormulaValue;// */
			}
			else if ( negativeRepeatLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = - LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue - LocationOfStillMovement + numberOfTransitions * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement <= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue - ColorsLength;// */
				/*if ( FormulaValue >= RepeatLength / 2 )
				{
					FormulaValue = FormulaValue + 3 * RepeatLength / 2;
					return FormulaValue - RepeatLength;
				}
				return -FormulaValue;// */
			}
			else
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + numberOfTransitions * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement + numberOfTransitions * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue - ColorsLength;// */
				/*while ( LocationOfStillMovement < 0 )
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
				while ( LocationOfStillMovement >= RepeatLength )
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
				if ( FormulaValue >= LocationOfStillMovement )
					FormulaValue = FormulaValue - LocationOfStillMovement;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;// */
			}
		}
		else if ( RepeatLength < ColorsLength )	
		{
			if ( negativeRepeatLength && negativeColorsLength )
			{//Perhaps Simplify ALL OF THESE -- -+ +- X On All 3
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement <= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue - ColorsLength;// */
				/*FormulaValue = ColorsLength - FormulaValue;//Critical Change
				while ( ColorsLength - FormulaValue <= 0 )
					FormulaValue = FormulaValue - ColorsLength;
				while ( ColorsLength - FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue + ColorsLength;
				if ( FormulaValue - ColorsLength <= -ColorsLength / 2 )
					FormulaValue = FormulaValue + 2 * ColorsLength; 
				return FormulaValue - ColorsLength;// */
			}
			else if ( negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = - LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue - ColorsLength;// */
			}
			else if ( negativeRepeatLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = - LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement <= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue - ColorsLength;// */
				//FormulaValue = -FormulaValue / RepeatLength;//Critical Change
				/*FormulaValue = FormulaValue - ColorsLength / 2;//New
				if ( FormulaValue >= ColorsLength / 2 )
					return FormulaValue + ColorsLength / 2;
				else
					return - FormulaValue - ColorsLength / 2;// */
			}
			else
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//ColorsLength / ( 2 * RepeatLength );//0;
				FormulaValue = FormulaValue * RepeatLength / ColorsLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = LocationOfStillMovement * RepeatLength / ColorsLength;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= RepeatLength )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + numberOfTransitions * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement + numberOfTransitions * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue - ColorsLength;// */
			}
		}
		else
		{
			if ( negativeRepeatLength && negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;
				FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = LocationOfStillMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement <= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				/*if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;// */
				/*while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + ColorsLength;
				while ( FormulaValue >= ColorsLength )
					FormulaValue = FormulaValue - ColorsLength;// */
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// #/
				/*FormulaValue = RepeatLength - FormulaValue;//Critical Change
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				if ( FormulaValue - RepeatLength <= -RepeatLength / 2 )
					FormulaValue = FormulaValue + 2 * RepeatLength; 
				return FormulaValue - RepeatLength;// */
			}
			else if ( negativeColorsLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;
				FormulaValue = + FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = - LocationOfStillMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue + LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;//Leave For Desyncronization !TEST?
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
			}
			else if ( negativeRepeatLength )
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;
				FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = - LocationOfStillMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement >= FormulaValue )
						FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength + ( RepeatLength + ColorsLength ) / 2;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue - LocationOfStillMovement + ( numberOfTransitions + 1 ) * RepeatLength + ( RepeatLength + ColorsLength ) / 2;//Leave For Desyncronization !TEST?
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;//Leave For Desyncronization !TEST?
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
				//Bad FormulaValue = - FormulaValue / RepeatLength;//Critical Change
				/*FormulaValue = FormulaValue - ColorsLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= RepeatLength )
					FormulaValue = FormulaValue - RepeatLength;
				if ( FormulaValue >= RepeatLength / 2 )
				{
					FormulaValue = FormulaValue + 3 * RepeatLength / 2;
					return FormulaValue - RepeatLength;
				}
				return -FormulaValue;// */
			}
			else
			{
				//FormulaValue = 0; //For Testing Specific SubFunction Only
				numberOfTransitions = 0;//- ( RepeatLength - 2 * ColorsLength ) / ColorsLength;
				FormulaValue = FormulaValue + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;
				LocationOfStillMovement = LocationOfStillMovement + ( RepeatLength + ColorsLength ) / 2 + RepeatLength / ColorsLength * RepeatLength / 2;
				while ( LocationOfStillMovement < 0 )
				{
					LocationOfStillMovement = LocationOfStillMovement + RepeatLength;
					numberOfTransitions++;//Comment Out Both Of These To Not Transition To A Different Color
				}
				while ( LocationOfStillMovement >= ( RepeatLength + ColorsLength ) / 2 )//( RepeatLength + ColorsLength ) / 2 )
				{
					LocationOfStillMovement = LocationOfStillMovement - RepeatLength;
					numberOfTransitions--;//Comment Out Both Of These To Not Transition To A Different Color
				}
				if ( negitiveFullSliderRunThrough )
				{
					if ( LocationOfStillMovement <= FormulaValue )
						FormulaValue = FormulaValue + LocationOfStillMovement + numberOfTransitions * RepeatLength;
					else
						FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;
				}
				else if ( LocationOfStillMovement >= FormulaValue )
					FormulaValue = FormulaValue - LocationOfStillMovement + numberOfTransitions * RepeatLength;
				else
					FormulaValue = FormulaValue + numberOfTransitions * RepeatLength;//Leave For Desyncronization !TEST?
				while ( FormulaValue < 0 )
					FormulaValue = FormulaValue + RepeatLength;
				while ( FormulaValue >= ( RepeatLength + ColorsLength ) / 2 )
					FormulaValue = FormulaValue - RepeatLength;// */
			}
		}
		return FormulaValue;
	}

	public Color TransparencySliderFunction(double ColorInterval, double Loc, Color ColorBefore, Color ColorAfter)
	{
		argb[0] = ColorValueFitterCapper( ToTwoFiveFivergb( ColorAfter.getRed() + ColorBefore.getRed() - ColorBefore.getRed() * Loc/ColorInterval - ColorAfter.getRed() * ( ColorInterval - Loc )/ColorInterval ) );
		argb[1] = ColorValueFitterCapper( ToTwoFiveFivergb( ColorAfter.getGreen() + ColorBefore.getGreen() - ColorBefore.getGreen() * Loc/ColorInterval - ColorAfter.getGreen() * ( ColorInterval - Loc )/ColorInterval ) );
		argb[2] = ColorValueFitterCapper( ToTwoFiveFivergb( ColorAfter.getBlue() + ColorBefore.getBlue() - ColorBefore.getBlue() * Loc/ColorInterval - ColorAfter.getBlue() * ( ColorInterval - Loc )/ColorInterval ) );
		argb[3] = OpacityValueFitterCapper( ColorAfter.getOpacity() + ColorBefore.getOpacity() - ColorBefore.getOpacity() * Loc/ColorInterval - ColorAfter.getOpacity() * ( ColorInterval - Loc )/ColorInterval );
		color = new RainbowSoftColor( argb );
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public Color TransparencySliderFunction(double ColorInterval, double Loc, double BrightnessMultiplyer, int Gradations, Color ColorBefore, Color ColorAfter, double OpacityBefore, double OpacityAfter)
	{
		argb[0] = ColorValueFitterCapper( ToTwoFiveFivergb( ColorAfter.getRed() + ColorBefore.getRed() - ColorBefore.getRed() * Math.floor( Loc/ColorInterval * ( Gradations + 2 ) ) / ( Gradations + 1 ) - ColorAfter.getRed() * Math.floor( ( ColorInterval - Loc )/ColorInterval * ( Gradations + 2 ) ) / ( Gradations + 1 ) ) );
		argb[1] = ColorValueFitterCapper( ToTwoFiveFivergb( ColorAfter.getGreen() + ColorBefore.getGreen() - ColorBefore.getGreen() * Math.floor( Loc/ColorInterval * ( Gradations + 2 ) ) / ( Gradations + 1 ) - ColorAfter.getGreen() * Math.floor( ( ColorInterval - Loc )/ColorInterval * ( Gradations + 2 ) ) / ( Gradations + 1 ) ) );
		argb[2] = ColorValueFitterCapper( ToTwoFiveFivergb( ColorAfter.getBlue() + ColorBefore.getBlue() - ColorBefore.getBlue() * Math.floor( Loc/ColorInterval * ( Gradations + 2 ) ) / ( Gradations + 1 ) - ColorAfter.getBlue() * Math.floor( ( ColorInterval - Loc )/ColorInterval * ( Gradations + 2 ) ) / ( Gradations + 1 ) ) );
		if ( BrightnessMultiplyer <= 1 && BrightnessMultiplyer >= 0 )
			for ( int z = 0; z <= 2; z++ )
				argb[z] = ColorValueFitterCapper( argb[z] * BrightnessMultiplyer );
		else
		{
			for (int z = 0; z <= 2; z++)
			{
				argb[z] = (int) ( argb[z] + ( argb[z] + 4 ) * ( BrightnessMultiplyer - 1 ) );
				if ( argb[z] > 255 )
					argb[z] = 255;
				argb[z] = ColorValueFitterCapper( argb[z]);
			}
		}
		argb[3] = OpacityValueFitterCapper( OpacityAfter + OpacityBefore - OpacityBefore * Math.floor( Loc/ColorInterval * ( Gradations + 2 ) ) / ( Gradations + 1 ) - OpacityAfter * Math.floor( ( ColorInterval - Loc )/ColorInterval * ( Gradations + 2 ) ) / ( Gradations + 1 ) );
		color = new RainbowSoftColor( argb );
		fxColor = color.ToFXColor();
		return fxColor;
	}
	public double ToTwoFiveFivergb ( double ZeroToOne )
	{	return 255 * ZeroToOne;	}
	/*public Color[] CustomColorsReverser ( Color[] FXcolorArray )//Reverses Custom Colors By Flipping Around Colors Like Rainbow Reversal Without Changing Any Colors Like Green In Rainbow To Pink In Reversed //
	{
		fxColorArray = new Color[FXcolorArray.length];
		for (int c = 0; c < FXcolorArray.length; c++)
			fxColorArray[c] = FXcolorArray[ FXcolorArray.length - c - 1 ];
		return fxColorArray;
	}// */
	public double ColorValueFitterCapper ( double ColorToBeChecked )
	{
		colorBeingChecked = ColorToBeChecked;
		while ( colorBeingChecked < 0 )
			colorBeingChecked = 0;
		while ( colorBeingChecked > 255 )
			colorBeingChecked = 255;
		return Math.round(colorBeingChecked);
	}
	public double OpacityValueFitterCapper ( double OpacityToBeChecked )
	{
		opacityBeingChecked = OpacityToBeChecked;
		while ( opacityBeingChecked < 0 )
			opacityBeingChecked = 0;
		while ( opacityBeingChecked > 1 )
			opacityBeingChecked = 1;
		return opacityBeingChecked;
	}
	public double ColorValueFitter ( double ColorToBeChecked )
	{
		colorBeingChecked = ColorToBeChecked;
		while ( colorBeingChecked < -4080 )
			colorBeingChecked = colorBeingChecked + 4080;
		while ( colorBeingChecked < 0 )
			colorBeingChecked = colorBeingChecked + 255;
		while ( colorBeingChecked > 4080 )
			colorBeingChecked = colorBeingChecked - 4080;
		while ( colorBeingChecked > 255 )
			colorBeingChecked = colorBeingChecked - 255;
		return Math.round(colorBeingChecked);
	}
	public double OpacityValueFitter ( double OpacityToBeChecked )
	{
		opacityBeingChecked = OpacityToBeChecked;
		while ( opacityBeingChecked < -16 )
			opacityBeingChecked = opacityBeingChecked + 16;
		while ( opacityBeingChecked < 0 )
			opacityBeingChecked = opacityBeingChecked + 1;
		while ( opacityBeingChecked > 16 )
			opacityBeingChecked = opacityBeingChecked - 16;
		while ( opacityBeingChecked > 1 )
			opacityBeingChecked = opacityBeingChecked - 1;
		return opacityBeingChecked;
	}
	/*public double trueArcTan ( double x, double y )
	{
		if ( x != 0 && y != 0 )
			return Math.atan2(x, y);
		if ( y == 0 )
			if ( x >= 0 )
				return Math.PI / 2;
			else //if ( x < 0 )
				return -Math.PI / 2;
		else
			if ( y > 0 )
				return 0;
			else //if ( y < 0 )
				return -Math.PI;
	}// */
	public void set(double[] ARGB) { argb = ARGB; rgb[0] = argb[0]; rgb[1] = argb[1]; rgb[2] = argb[2]; fxColor = Color.rgb( (int)(ColorValueFitterCapper(argb[0])), (int)(ColorValueFitterCapper(argb[1])), (int)(ColorValueFitterCapper(argb[2])), (OpacityValueFitterCapper(argb[3])) ); color = new RainbowSoftColor( argb ); }//Assigns Colors With argb //29th Square In SimpleDiagnosticsClass.java
	public void set(Color FXColor) { fxColor = FXColor; argb = new double[] { FXColor.getRed() * 255, FXColor.getGreen() * 255, FXColor.getBlue() * 255, FXColor.getOpacity() }; rgb = new double[] { FXColor.getRed() * 255, FXColor.getGreen() * 255, FXColor.getBlue() * 255 }; color = new RainbowSoftColor( argb ); }//Assigns Colors With FXColor //30th Square In SimpleDiagnosticsClass.java
	public Color get() { return fxColor; }//Returns Always Happen With Variable Output With argb Functionality //31st Square In SimpleDiagnosticsClass.java
}


/*while ( radius < colorDisplacement)//For Rainbow Ring
	radius = radius + fullAngle - colorDisplacement;//BAD COMMENT: For Rainbow Ring Take Out - 38
while ( radius > fullAngle )
	radius = radius - fullAngle - colorDisplacement;// */


/*final double chrysanthemumRadius = 60;
double radialVariableDistance = Math.pow(Math.pow( x, 2 ) + Math.pow( y, 2), 0.5);//Comment Out For Ghetto Many Rainbow Clocks
double angleVariable = chrysanthemumRadius * ( ( - Math.atan2( x, y ) + Math.PI ) - 6 * Math.PI * Location / ( Math.PI * Math.pow(Math.pow( HalfedDim.getWidth(), 2 ) + Math.pow( HalfedDim.getHeight(), 2 ), 0.5 ) / 10 ) );//Use For Rainbow Spiral Multiply radialDistance By 10 To Increase The Number Of Spirals
//double radiusVariable = chrysanthemumRadius * ( radialVariableDistance * 24.6 + angleVariable);//radialVariableDistance + colorDisplacement + angle;//Remove + angle And Add xSlider To Make Rainbow Clock
while ( radiusVariable < 0 )//For Rainbow Ring
	radiusVariable = radiusVariable + 2 * Math.PI * chrysanthemumRadius;//BAD COMMENT: For Rainbow Ring Take Out - 38
while ( radiusVariable > 2 * Math.PI * chrysanthemumRadius )
	radiusVariable = radiusVariable - 2 * Math.PI * chrysanthemumRadius;
double colorIntervalVariable = 2 * Math.PI * chrysanthemumRadius / ( FXcolorArray.length - 1 );// USE FOR HYPNOSIS SPIRAL I THINK */
//sliderValue = SliderFormulate( ColorsFactor, Math.pow( Math.pow(x, 2) + Math.pow(y, 2), 0.5 ), Location, RepeatFactor, FullSliderRunThrough );
