/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis.values;

import graphql.Assert;
import graphql.PublicApi;
import graphql.analysis.values.ValueVisitor;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableCollection;
import graphql.com.google.common.collect.ImmutableList;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputSchemaElement;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInputValueDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLTypeUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@PublicApi
public class ValueTraverser {
    public static DataFetchingEnvironment visitPreOrder(DataFetchingEnvironment environment, ValueVisitor visitor) {
        GraphQLFieldDefinition fieldDefinition = environment.getFieldDefinition();
        Map<String, Object> originalArgs = environment.getArguments();
        Map<String, Object> newArgs = ValueTraverser.visitPreOrder(originalArgs, fieldDefinition, visitor);
        if (newArgs != originalArgs) {
            return DataFetchingEnvironmentImpl.newDataFetchingEnvironment(environment).arguments(newArgs).build();
        }
        return environment;
    }

    public static Map<String, Object> visitPreOrder(Map<String, Object> coercedArgumentValues, GraphQLFieldDefinition fieldDefinition, ValueVisitor visitor) {
        List<GraphQLArgument> fieldArguments = fieldDefinition.getArguments();
        boolean copied = false;
        for (GraphQLArgument fieldArgument : fieldArguments) {
            InputElements inputElements;
            String key = fieldArgument.getName();
            Object argValue = coercedArgumentValues.get(key);
            Object newValue = visitor.visitArgumentValue(argValue, fieldArgument, inputElements = new InputElements(fieldArgument));
            if (ValueTraverser.hasChanged(newValue, argValue)) {
                if (!copied) {
                    coercedArgumentValues = new LinkedHashMap<String, Object>(coercedArgumentValues);
                    copied = true;
                }
                ValueTraverser.setNewValue(coercedArgumentValues, key, newValue);
            }
            if (newValue == ValueVisitor.ABSENCE_SENTINEL || !ValueTraverser.hasChanged(newValue = ValueTraverser.visitPreOrderImpl(argValue, fieldArgument.getType(), inputElements, visitor), argValue)) continue;
            if (!copied) {
                coercedArgumentValues = new LinkedHashMap<String, Object>(coercedArgumentValues);
                copied = true;
            }
            ValueTraverser.setNewValue(coercedArgumentValues, key, newValue);
        }
        return coercedArgumentValues;
    }

    public static Object visitPreOrder(Object coercedArgumentValue, GraphQLArgument argument, ValueVisitor visitor) {
        InputElements inputElements = new InputElements(argument);
        Object newValue = visitor.visitArgumentValue(coercedArgumentValue, argument, inputElements);
        if (newValue == ValueVisitor.ABSENCE_SENTINEL) {
            Assert.assertShouldNeverHappen("It makes no sense to return the ABSENCE_SENTINEL during the visitPreOrder GraphQLArgument method", new Object[0]);
        }
        if ((newValue = ValueTraverser.visitPreOrderImpl(newValue, argument.getType(), inputElements, visitor)) == ValueVisitor.ABSENCE_SENTINEL) {
            Assert.assertShouldNeverHappen("It makes no sense to return the ABSENCE_SENTINEL during the visitPreOrder GraphQLArgument method", new Object[0]);
        }
        return newValue;
    }

    public static Object visitPreOrder(Object coercedArgumentValue, GraphQLAppliedDirectiveArgument argument, ValueVisitor visitor) {
        InputElements inputElements = new InputElements(argument);
        Object newValue = visitor.visitAppliedDirectiveArgumentValue(coercedArgumentValue, argument, inputElements);
        if (newValue == ValueVisitor.ABSENCE_SENTINEL) {
            Assert.assertShouldNeverHappen("It makes no sense to return the ABSENCE_SENTINEL during the visitPreOrder GraphQLAppliedDirectiveArgument method", new Object[0]);
        }
        if ((newValue = ValueTraverser.visitPreOrderImpl(newValue, argument.getType(), inputElements, visitor)) == ValueVisitor.ABSENCE_SENTINEL) {
            Assert.assertShouldNeverHappen("It makes no sense to return the ABSENCE_SENTINEL during the visitPreOrder GraphQLAppliedDirectiveArgument method", new Object[0]);
        }
        return newValue;
    }

    private static Object visitPreOrderImpl(Object coercedValue, GraphQLInputType startingInputType, InputElements containingElements, ValueVisitor visitor) {
        if (startingInputType instanceof GraphQLNonNull) {
            containingElements = containingElements.push(startingInputType);
        }
        GraphQLInputType inputType = (GraphQLInputType)GraphQLTypeUtil.unwrapNonNullAs(startingInputType);
        containingElements = containingElements.push(inputType);
        if (inputType instanceof GraphQLList) {
            return ValueTraverser.visitListValue(coercedValue, (GraphQLList)inputType, containingElements, visitor);
        }
        if (inputType instanceof GraphQLInputObjectType) {
            GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)inputType;
            return ValueTraverser.visitObjectValue(coercedValue, inputObjectType, containingElements, visitor);
        }
        if (inputType instanceof GraphQLScalarType) {
            return visitor.visitScalarValue(coercedValue, (GraphQLScalarType)inputType, containingElements);
        }
        if (inputType instanceof GraphQLEnumType) {
            return visitor.visitEnumValue(coercedValue, (GraphQLEnumType)inputType, containingElements);
        }
        return Assert.assertShouldNeverHappen("ValueTraverser can only be called on full materialised schemas", new Object[0]);
    }

    private static Object visitObjectValue(Object coercedValue, GraphQLInputObjectType inputObjectType, InputElements containingElements, ValueVisitor visitor) {
        Map map;
        Map<String, Object> newMap;
        if (coercedValue != null) {
            Assert.assertTrue(coercedValue instanceof Map, () -> "A input object type MUST have an Map<String,Object> value");
        }
        if ((newMap = visitor.visitInputObjectValue(map = (Map)coercedValue, inputObjectType, containingElements)) == ValueVisitor.ABSENCE_SENTINEL) {
            return ValueVisitor.ABSENCE_SENTINEL;
        }
        if (newMap != null) {
            boolean copied = false;
            for (Map.Entry<String, Object> entry : newMap.entrySet()) {
                String key = entry.getKey();
                GraphQLInputObjectField inputField = inputObjectType.getField(key);
                if (inputField == null) continue;
                InputElements inputElementsWithField = containingElements.push(inputField);
                Object newValue = visitor.visitInputObjectFieldValue(entry.getValue(), inputObjectType, inputField, inputElementsWithField);
                if (ValueTraverser.hasChanged(newValue, entry.getValue())) {
                    if (!copied) {
                        newMap = new LinkedHashMap<String, Object>(newMap);
                        copied = true;
                    }
                    ValueTraverser.setNewValue(newMap, key, newValue);
                }
                if (newValue == ValueVisitor.ABSENCE_SENTINEL || !ValueTraverser.hasChanged(newValue = ValueTraverser.visitPreOrderImpl(newValue, inputField.getType(), inputElementsWithField, visitor), entry.getValue())) continue;
                if (!copied) {
                    newMap = new LinkedHashMap<String, Object>(newMap);
                    copied = true;
                }
                ValueTraverser.setNewValue(newMap, key, newValue);
            }
            return newMap;
        }
        return null;
    }

    private static Object visitListValue(Object coercedValue, GraphQLList listInputType, InputElements containingElements, ValueVisitor visitor) {
        List list;
        List<Object> newList;
        if (coercedValue != null) {
            Assert.assertTrue(coercedValue instanceof List, () -> "A list type MUST have an List value");
        }
        if ((newList = visitor.visitListValue(list = (List)coercedValue, listInputType, containingElements)) == ValueVisitor.ABSENCE_SENTINEL) {
            return ValueVisitor.ABSENCE_SENTINEL;
        }
        if (newList != null) {
            GraphQLInputType inputType = (GraphQLInputType)GraphQLTypeUtil.unwrapOneAs(listInputType);
            ImmutableList.Builder copiedList = null;
            int i = 0;
            for (Object subValue : newList) {
                Object newValue = ValueTraverser.visitPreOrderImpl(subValue, inputType, containingElements, visitor);
                if (copiedList != null) {
                    if (newValue != ValueVisitor.ABSENCE_SENTINEL) {
                        copiedList.add(newValue);
                    }
                } else if (ValueTraverser.hasChanged(newValue, subValue)) {
                    copiedList = ImmutableList.builder();
                    for (int j = 0; j < i; ++j) {
                        copiedList.add(newList.get(j));
                    }
                    if (newValue != ValueVisitor.ABSENCE_SENTINEL) {
                        copiedList.add(newValue);
                    }
                }
                ++i;
            }
            if (copiedList != null) {
                return copiedList.build();
            }
            return newList;
        }
        return null;
    }

    private static boolean hasChanged(Object newValue, Object oldValue) {
        return newValue != oldValue || newValue == ValueVisitor.ABSENCE_SENTINEL;
    }

    private static void setNewValue(Map<String, Object> newMap, String key, Object newValue) {
        if (newValue == ValueVisitor.ABSENCE_SENTINEL) {
            newMap.remove(key);
        } else {
            newMap.put(key, newValue);
        }
    }

    private static class InputElements
    implements ValueVisitor.InputElements {
        private final ImmutableList<GraphQLInputSchemaElement> inputElements;
        private final List<GraphQLInputSchemaElement> unwrappedInputElements;
        private final GraphQLInputValueDefinition lastElement;

        private InputElements(GraphQLInputSchemaElement startElement) {
            this.inputElements = ImmutableList.of(startElement);
            this.unwrappedInputElements = ImmutableList.of(startElement);
            this.lastElement = startElement instanceof GraphQLInputValueDefinition ? (GraphQLInputValueDefinition)startElement : null;
        }

        private InputElements(ImmutableList<GraphQLInputSchemaElement> inputElements) {
            this.inputElements = inputElements;
            this.unwrappedInputElements = ImmutableKit.filter(inputElements, it -> !(it instanceof GraphQLNonNull) && !(it instanceof GraphQLList));
            ImmutableList<GraphQLInputValueDefinition> inputValDefs = ImmutableKit.filterAndMap(this.unwrappedInputElements, it -> it instanceof GraphQLInputValueDefinition, GraphQLInputValueDefinition.class::cast);
            this.lastElement = inputValDefs.isEmpty() ? null : (GraphQLInputValueDefinition)inputValDefs.get(inputValDefs.size() - 1);
        }

        private InputElements push(GraphQLInputSchemaElement inputElement) {
            ImmutableCollection newSchemaElements = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.inputElements)).add(inputElement)).build();
            return new InputElements((ImmutableList<GraphQLInputSchemaElement>)newSchemaElements);
        }

        @Override
        public List<GraphQLInputSchemaElement> getInputElements() {
            return this.inputElements;
        }

        @Override
        public List<GraphQLInputSchemaElement> getUnwrappedInputElements() {
            return this.unwrappedInputElements;
        }

        @Override
        public GraphQLInputValueDefinition getLastInputValueDefinition() {
            return this.lastElement;
        }
    }
}

