/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.input.InfiniteCircularInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class InfiniteCircularInputStreamTest {
    InfiniteCircularInputStreamTest() {
    }

    private void assertStreamOutput(byte[] toCycle, byte[] expected) throws IOException {
        byte[] actual = new byte[expected.length];
        try (InfiniteCircularInputStream infStream = new InfiniteCircularInputStream(toCycle);){
            int actualReadBytes = infStream.read(actual);
            Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
            Assertions.assertEquals((int)expected.length, (int)actualReadBytes);
        }
    }

    private InputStream createInputStream(byte[] repeatContent) {
        return new InfiniteCircularInputStream(repeatContent);
    }

    @Test
    void testAvailableAfterClose() throws Exception {
        InputStream shadow;
        try (InputStream in = this.createInputStream(new byte[]{1, 2});){
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            Assertions.assertEquals((int)1, (int)in.read());
            Assertions.assertEquals((int)2, (int)in.read());
            Assertions.assertEquals((int)1, (int)in.read());
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)shadow.available());
    }

    @Test
    void testAvailableAfterOpen() throws Exception {
        try (InputStream in = this.createInputStream(new byte[]{1, 2});){
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            Assertions.assertEquals((int)1, (int)in.read());
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            Assertions.assertEquals((int)2, (int)in.read());
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            Assertions.assertEquals((int)1, (int)in.read());
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    void testContainsEofInputSize0() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createInputStream(new byte[]{-1}));
    }

    @Test
    void testCount0InputSize0() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createInputStream(new byte[0]));
    }

    @Test
    void testCount0InputSize1() throws IOException {
        InputStream in = this.createInputStream(new byte[]{1});
        if (in != null) {
            in.close();
        }
    }

    @Test
    void testCount1InputSize1() throws IOException {
        try (InputStream in = this.createInputStream(new byte[]{1});){
            Assertions.assertEquals((int)1, (int)in.read());
            Assertions.assertEquals((int)1, (int)in.read());
        }
    }

    @Test
    void testCycleBytes() throws IOException {
        byte[] input = new byte[]{1, 2};
        byte[] expected = new byte[]{1, 2, 1, 2, 1};
        this.assertStreamOutput(input, expected);
    }

    @Test
    void testNullInputSize0() {
        Assertions.assertThrows(NullPointerException.class, () -> this.createInputStream(null));
    }

    @Test
    void testReadAfterClose() throws Exception {
        InputStream shadow;
        try (InputStream in = this.createInputStream(new byte[]{1, 2});){
            Assertions.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            Assertions.assertEquals((int)1, (int)in.read());
            Assertions.assertEquals((int)2, (int)in.read());
            Assertions.assertEquals((int)1, (int)in.read());
            shadow = in;
        }
        Assertions.assertEquals((int)-1, (int)shadow.read());
    }

    @Test
    void testWholeRangeOfBytes() throws IOException {
        int size = 256;
        byte[] contentToCycle = new byte[256];
        int value = -128;
        for (int i = 0; i < contentToCycle.length; ++i) {
            contentToCycle[i] = value == -1 ? 0 : value;
            value = (byte)(value + 1);
        }
        byte[] expectedOutput = Arrays.copyOf(contentToCycle, 256);
        this.assertStreamOutput(contentToCycle, expectedOutput);
    }
}

