/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<std::vector<float> >"})
@Properties(inherit={opencv_core.class})
public class FloatVectorVector
extends Pointer {
    public FloatVectorVector(Pointer p) {
        super(p);
    }

    public FloatVectorVector(float[] ... array) {
        this(array.length);
        this.put(array);
    }

    public FloatVectorVector() {
        this.allocate();
    }

    public FloatVectorVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator ="})
    @ByRef
    public native FloatVectorVector put(@ByRef FloatVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    public boolean empty(@Cast(value={"size_t"}) long i) {
        return this.size(i) == 0L;
    }

    @Index(function="at")
    public native long size(@Cast(value={"size_t"}) long var1);

    public void clear(@Cast(value={"size_t"}) long i) {
        this.resize(i, 0L);
    }

    @Index(function="at")
    public native void resize(@Cast(value={"size_t"}) long var1, @Cast(value={"size_t"}) long var3);

    @Index(function="at")
    public native float get(@Cast(value={"size_t"}) long var1, @Cast(value={"size_t"}) long var3);

    public native FloatVectorVector put(@Cast(value={"size_t"}) long var1, @Cast(value={"size_t"}) long var3, float var5);

    public float[][] get() {
        float[][] array = new float[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE][];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new float[this.size(i) < Integer.MAX_VALUE ? (int)this.size(i) : Integer.MAX_VALUE];
            for (int j = 0; j < array[i].length; ++j) {
                array[i][j] = this.get(i, j);
            }
        }
        return array;
    }

    @Override
    public String toString() {
        return Arrays.deepToString((Object[])this.get());
    }

    public FloatVectorVector put(float[] ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            if (this.size(i) != (long)array[i].length) {
                this.resize(i, array[i].length);
            }
            for (int j = 0; j < array[i].length; ++j) {
                this.put(i, j, array[i][j]);
            }
        }
        return this;
    }

    static {
        Loader.load();
    }
}

