/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diff.reporting;

import graphql.PublicApi;
import graphql.schema.diff.DiffEvent;
import graphql.schema.diff.DiffLevel;
import graphql.schema.diff.reporting.DifferenceReporter;
import java.io.PrintStream;

@PublicApi
public class PrintStreamReporter
implements DifferenceReporter {
    int breakageCount = 0;
    int dangerCount = 0;
    final PrintStream out;

    public PrintStreamReporter() {
        this(System.out);
    }

    public PrintStreamReporter(PrintStream out) {
        this.out = out;
    }

    @Override
    public void report(DiffEvent differenceEvent) {
        if (differenceEvent.getLevel() == DiffLevel.BREAKING) {
            ++this.breakageCount;
        }
        if (differenceEvent.getLevel() == DiffLevel.DANGEROUS) {
            ++this.dangerCount;
        }
        this.printEvent(differenceEvent);
    }

    private void printEvent(DiffEvent event) {
        String indent = event.getLevel() == DiffLevel.INFO ? "\t" : "";
        String level = event.getLevel() == DiffLevel.INFO ? "info" : event.getLevel().toString();
        Object objectName = event.getTypeName();
        if (event.getFieldName() != null) {
            objectName = (String)objectName + "." + event.getFieldName();
        }
        this.out.println(String.format("%s%s - '%s' : '%s' : %s", new Object[]{indent, level, event.getTypeKind(), objectName, event.getReasonMsg()}));
    }

    @Override
    public void onEnd() {
        this.out.println("\n");
        this.out.println(String.format("%d errors", this.breakageCount));
        this.out.println(String.format("%d warnings", this.dangerCount));
        this.out.println("\n");
    }
}

