/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class ConverterFunctions {
    public static <X> Function<JsonInput, X> map(String keyName, Type typeOfX) {
        Require.nonNull("Key name", keyName);
        Require.nonNull("Type to convert to", typeOfX);
        return ConverterFunctions.map(keyName, (JsonInput input) -> input.read(typeOfX));
    }

    public static <X> Function<JsonInput, X> map(String keyName, Function<JsonInput, X> read) {
        Require.nonNull("Key name", keyName);
        Require.nonNull("Read callback", read);
        return input -> {
            Object value = null;
            input.beginObject();
            while (input.hasNext()) {
                String name = input.nextName();
                if (keyName.equals(name)) {
                    value = read.apply((JsonInput)input);
                    continue;
                }
                input.skipValue();
            }
            input.endObject();
            return value;
        };
    }

    public static Function<JsonInput, Void> empty() {
        return input -> {
            input.beginObject();
            input.endObject();
            return null;
        };
    }
}

