/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.router.GridStatusHandler;
import org.openqa.selenium.grid.router.HandleSession;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.SpanDecorator;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public class Router
implements HasReadyState,
Routable,
Closeable {
    private final Routable routes;
    private final SessionMap sessions;
    private final Distributor distributor;
    private final NewSessionQueue queue;
    private final HandleSession sessionHandler;

    public Router(Tracer tracer, HttpClient.Factory clientFactory, SessionMap sessions, NewSessionQueue queue, Distributor distributor) {
        Require.nonNull("Tracer to use", tracer);
        Require.nonNull("HTTP client factory", clientFactory);
        this.sessions = Require.nonNull("Session map", sessions);
        this.queue = Require.nonNull("New Session Request Queue", queue);
        this.distributor = Require.nonNull("Distributor", distributor);
        this.sessionHandler = new HandleSession(tracer, clientFactory, sessions);
        this.routes = Route.combine(Route.get("/status").to(() -> new GridStatusHandler(tracer, distributor)), sessions.with(new SpanDecorator(tracer, req -> "session_map")), queue.with(new SpanDecorator(tracer, req -> "session_queue")), distributor.with(new SpanDecorator(tracer, req -> "distributor")), Route.matching(req -> req.getUri().startsWith("/session/")).to(() -> this.sessionHandler));
    }

    @Override
    public boolean isReady() {
        try {
            return ImmutableSet.of(this.distributor, this.sessions, this.queue).parallelStream().map(rec$ -> ((HasReadyState)rec$).isReady()).reduce(true, Boolean::logicalAnd);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    @Override
    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }

    @Override
    public void close() {
        this.sessionHandler.close();
    }
}

