/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v140.storage.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum SharedStorageAccessScope {
    WINDOW("window"),
    SHAREDSTORAGEWORKLET("sharedStorageWorklet"),
    PROTECTEDAUDIENCEWORKLET("protectedAudienceWorklet"),
    HEADER("header");

    private String value;

    private SharedStorageAccessScope(String value) {
        this.value = value;
    }

    public static SharedStorageAccessScope fromString(String s) {
        return Arrays.stream(SharedStorageAccessScope.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SharedStorageAccessScope "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static SharedStorageAccessScope fromJson(JsonInput input) {
        return SharedStorageAccessScope.fromString(input.nextString());
    }
}

