/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphqlTypeBuilder;
import java.util.ArrayList;
import java.util.List;

@Internal
public abstract class GraphqlDirectivesContainerTypeBuilder<B extends GraphqlDirectivesContainerTypeBuilder<B, BASE>, BASE extends GraphqlTypeBuilder<BASE>>
extends GraphqlTypeBuilder<BASE> {
    protected final List<GraphQLAppliedDirective> appliedDirectives = new ArrayList<GraphQLAppliedDirective>();
    protected final List<GraphQLDirective> directives = new ArrayList<GraphQLDirective>();

    public B replaceAppliedDirectives(List<GraphQLAppliedDirective> directives) {
        Assert.assertNotNull(directives, () -> "directive can't be null");
        this.appliedDirectives.clear();
        this.appliedDirectives.addAll(directives);
        return (B)this;
    }

    public B withAppliedDirectives(GraphQLAppliedDirective ... directives) {
        Assert.assertNotNull(directives, () -> "directives can't be null");
        for (GraphQLAppliedDirective directive : directives) {
            this.withAppliedDirective(directive);
        }
        return (B)this;
    }

    public B withAppliedDirective(GraphQLAppliedDirective directive) {
        Assert.assertNotNull(directive, () -> "directive can't be null");
        this.appliedDirectives.add(directive);
        return (B)this;
    }

    public B withAppliedDirective(GraphQLAppliedDirective.Builder builder) {
        return this.withAppliedDirective(builder.build());
    }

    @Deprecated(since="2022-02-24")
    public B replaceDirectives(List<GraphQLDirective> directives) {
        Assert.assertNotNull(directives, () -> "directive can't be null");
        this.directives.clear();
        this.directives.addAll(directives);
        return (B)this;
    }

    @Deprecated(since="2022-02-24")
    public B withDirectives(GraphQLDirective ... directives) {
        Assert.assertNotNull(directives, () -> "directives can't be null");
        for (GraphQLDirective directive : directives) {
            this.withDirective(directive);
        }
        return (B)this;
    }

    @Deprecated(since="2022-02-24")
    public B withDirective(GraphQLDirective directive) {
        Assert.assertNotNull(directive, () -> "directive can't be null");
        this.directives.add(directive);
        return (B)this;
    }

    @Deprecated(since="2022-02-24")
    public B withDirective(GraphQLDirective.Builder builder) {
        return this.withDirective(builder.build());
    }

    public B clearDirectives() {
        this.directives.clear();
        this.appliedDirectives.clear();
        return (B)this;
    }

    protected void copyExistingDirectives(GraphQLDirectiveContainer directivesContainer) {
        this.clearDirectives();
        this.directives.addAll(directivesContainer.getDirectives());
        this.appliedDirectives.addAll(directivesContainer.getAppliedDirectives());
    }
}

