/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Assert;
import graphql.Internal;
import graphql.com.google.common.collect.BiMap;
import graphql.com.google.common.collect.HashBasedTable;
import graphql.com.google.common.collect.HashBiMap;
import graphql.com.google.common.collect.HashMultimap;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.Multimap;
import graphql.com.google.common.collect.Table;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.Mapping;
import graphql.schema.diffing.SchemaDiffingRunningCheck;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.Util;
import graphql.schema.diffing.Vertex;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class PossibleMappingsCalculator {
    private final SchemaDiffingRunningCheck runningCheck;
    private final SchemaGraph sourceGraph;
    private final SchemaGraph targetGraph;
    private final PossibleMappings possibleMappings;
    private static final Map<String, List<VertexContextSegment>> typeContexts = new LinkedHashMap<String, List<VertexContextSegment>>();

    private static List<VertexContextSegment> inputFieldContexts() {
        VertexContextSegment inputFieldType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "InputField".equals(vertex.getType());
            }
        };
        VertexContextSegment inputObjectContext = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex inputField, SchemaGraph schemaGraph) {
                Vertex inputObject = schemaGraph.getInputObjectForInputField(inputField);
                return inputObject.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment inputFieldName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex inputField, SchemaGraph schemaGraph) {
                return inputField.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(inputFieldType, inputObjectContext, inputFieldName);
        return contexts;
    }

    private static List<VertexContextSegment> scalarContext() {
        VertexContextSegment scalar = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Scalar".equals(vertex.getType());
            }
        };
        VertexContextSegment scalarName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(scalar, scalarName);
        return contexts;
    }

    private static List<VertexContextSegment> inputObjectContext() {
        VertexContextSegment inputObject = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "InputObject".equals(vertex.getType());
            }
        };
        VertexContextSegment inputObjectName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex inputObject, SchemaGraph schemaGraph) {
                return inputObject.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(inputObject, inputObjectName);
        return contexts;
    }

    private static List<VertexContextSegment> objectContext() {
        VertexContextSegment objectType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Object".equals(vertex.getType());
            }
        };
        VertexContextSegment objectName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex object, SchemaGraph schemaGraph) {
                return object.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(objectType, objectName);
        return contexts;
    }

    private static List<VertexContextSegment> enumContext() {
        VertexContextSegment enumCtxType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Enum".equals(vertex.getType());
            }
        };
        VertexContextSegment enumName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex enumVertex, SchemaGraph schemaGraph) {
                return enumVertex.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(enumCtxType, enumName);
        return contexts;
    }

    private static List<VertexContextSegment> enumValueContext() {
        VertexContextSegment enumValueType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "EnumValue".equals(vertex.getType());
            }
        };
        VertexContextSegment enumName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex enumValue, SchemaGraph schemaGraph) {
                return schemaGraph.getEnumForEnumValue(enumValue).getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment enumValueName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex enumValue, SchemaGraph schemaGraph) {
                return enumValue.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(enumValueType, enumName, enumValueName);
        return contexts;
    }

    private static List<VertexContextSegment> interfaceContext() {
        VertexContextSegment interfaceType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Interface".equals(vertex.getType());
            }
        };
        VertexContextSegment interfaceName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex interfaceVertex, SchemaGraph schemaGraph) {
                return interfaceVertex.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(interfaceType, interfaceName);
        return contexts;
    }

    private static List<VertexContextSegment> unionContext() {
        VertexContextSegment unionType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Union".equals(vertex.getType());
            }
        };
        VertexContextSegment unionName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex union, SchemaGraph schemaGraph) {
                return union.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(unionType, unionName);
        return contexts;
    }

    private static List<VertexContextSegment> directiveContext() {
        VertexContextSegment directiveType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Directive".equals(vertex.getType());
            }
        };
        VertexContextSegment directiveName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex directive, SchemaGraph schemaGraph) {
                return directive.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(directiveType, directiveName);
        return contexts;
    }

    private static List<VertexContextSegment> appliedDirectiveContext() {
        VertexContextSegment appliedDirectiveType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "AppliedDirective".equals(vertex.getType());
            }
        };
        VertexContextSegment appliedDirectiveIndex = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedDirective, SchemaGraph schemaGraph) {
                int appliedDirectiveIndex = schemaGraph.getAppliedDirectiveIndex(appliedDirective);
                return Integer.toString(appliedDirectiveIndex);
            }
        };
        final VertexContextSegment appliedDirectiveName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedDirective, SchemaGraph schemaGraph) {
                return appliedDirective.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        final VertexContextSegment appliedDirectiveContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedDirective, SchemaGraph schemaGraph) {
                Vertex appliedDirectiveContainer = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                return appliedDirectiveContainer.getType() + "." + appliedDirectiveContainer.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        final VertexContextSegment parentOfContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedDirective, SchemaGraph schemaGraph) {
                Vertex container = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                switch (container.getType()) {
                    case "Schema": {
                        return "Schema";
                    }
                    case "Field": {
                        Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(container);
                        return fieldsContainer.getType() + "." + fieldsContainer.getName();
                    }
                    case "Object": {
                        return "Object";
                    }
                    case "Interface": {
                        return "Interface";
                    }
                    case "InputField": {
                        Vertex inputObject = schemaGraph.getInputObjectForInputField(container);
                        return inputObject.getType() + "." + inputObject.getName();
                    }
                    case "Argument": {
                        Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(container);
                        return fieldOrDirective.getType() + "." + fieldOrDirective.getName();
                    }
                    case "InputObject": {
                        return "InputObject";
                    }
                    case "Enum": {
                        return "Enum";
                    }
                    case "Union": {
                        return "Union";
                    }
                    case "Scalar": {
                        return "Scalar";
                    }
                    case "EnumValue": {
                        Vertex enumVertex = schemaGraph.getEnumForEnumValue(container);
                        return enumVertex.getType() + "." + enumVertex.getName();
                    }
                }
                throw new IllegalStateException("Unexpected directive container type " + container.getType());
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        final VertexContextSegment parentOfParentOfContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedDirective, SchemaGraph schemaGraph) {
                Vertex container = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                switch (container.getType()) {
                    case "Schema": 
                    case "Field": 
                    case "Object": 
                    case "Interface": 
                    case "InputField": 
                    case "InputObject": 
                    case "Enum": 
                    case "EnumValue": 
                    case "Union": 
                    case "Scalar": {
                        return "";
                    }
                    case "Argument": {
                        Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(container);
                        switch (fieldOrDirective.getType()) {
                            case "Field": {
                                Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(fieldOrDirective);
                                return fieldsContainer.getType() + "." + fieldsContainer.getName();
                            }
                            case "Directive": {
                                return "";
                            }
                        }
                        return (String)Assert.assertShouldNeverHappen();
                    }
                }
                throw new IllegalStateException("Unexpected directive container type " + container.getType());
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment vertexContextSegment = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return parentOfParentOfContainer.idForVertex(vertex, schemaGraph) + "." + parentOfContainer.idForVertex(vertex, schemaGraph) + "." + appliedDirectiveContainer.idForVertex(vertex, schemaGraph) + "." + appliedDirectiveName.idForVertex(vertex, schemaGraph);
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(appliedDirectiveType, vertexContextSegment, appliedDirectiveIndex);
        return contexts;
    }

    private static List<VertexContextSegment> appliedArgumentContext() {
        VertexContextSegment appliedArgumentType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "AppliedArgument".equals(vertex.getType());
            }
        };
        final VertexContextSegment appliedDirective = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedArgument, SchemaGraph schemaGraph) {
                Vertex appliedDirective = schemaGraph.getAppliedDirectiveForAppliedArgument(appliedArgument);
                int appliedDirectiveIndex = schemaGraph.getAppliedDirectiveIndex(appliedDirective);
                return appliedDirectiveIndex + ":" + appliedDirective.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        final VertexContextSegment appliedDirectiveContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedArgument, SchemaGraph schemaGraph) {
                Vertex appliedDirective = schemaGraph.getAppliedDirectiveForAppliedArgument(appliedArgument);
                Vertex appliedDirectiveContainer = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                return appliedDirectiveContainer.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        final VertexContextSegment parentOfContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedArgument, SchemaGraph schemaGraph) {
                Vertex appliedDirective = schemaGraph.getAppliedDirectiveForAppliedArgument(appliedArgument);
                Vertex container = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                switch (container.getType()) {
                    case "Schema": {
                        return "Schema";
                    }
                    case "Field": {
                        Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(container);
                        return fieldsContainer.getType() + "." + fieldsContainer.getName();
                    }
                    case "Object": {
                        return "Object";
                    }
                    case "Interface": {
                        return "Interface";
                    }
                    case "InputField": {
                        Vertex inputObject = schemaGraph.getInputObjectForInputField(container);
                        return inputObject.getType() + "." + inputObject.getName();
                    }
                    case "Argument": {
                        Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(container);
                        return fieldOrDirective.getType() + "." + fieldOrDirective.getName();
                    }
                    case "InputObject": {
                        return "InputObject";
                    }
                    case "Enum": {
                        return "Enum";
                    }
                    case "Union": {
                        return "Union";
                    }
                    case "Scalar": {
                        return "Scalar";
                    }
                    case "EnumValue": {
                        Vertex enumVertex = schemaGraph.getEnumForEnumValue(container);
                        return enumVertex.getType() + "." + enumVertex.getName();
                    }
                }
                throw new IllegalStateException("Unexpected directive container type " + container.getType());
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment parentOfParentOfContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedArgument, SchemaGraph schemaGraph) {
                Vertex appliedDirective = schemaGraph.getAppliedDirectiveForAppliedArgument(appliedArgument);
                Vertex container = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                switch (container.getType()) {
                    case "Schema": 
                    case "Field": 
                    case "Object": 
                    case "Interface": 
                    case "InputField": 
                    case "InputObject": 
                    case "Enum": 
                    case "EnumValue": 
                    case "Union": 
                    case "Scalar": {
                        return "";
                    }
                    case "Argument": {
                        Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(container);
                        switch (fieldOrDirective.getType()) {
                            case "Field": {
                                Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(fieldOrDirective);
                                return fieldsContainer.getType() + "." + fieldsContainer.getName();
                            }
                            case "Directive": {
                                return "";
                            }
                        }
                        return (String)Assert.assertShouldNeverHappen();
                    }
                }
                throw new IllegalStateException("Unexpected directive container type " + container.getType());
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        final VertexContextSegment appliedArgumentName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedArgument, SchemaGraph schemaGraph) {
                return appliedArgument.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment combined = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return parentOfContainer.idForVertex(vertex, schemaGraph) + "." + parentOfContainer.idForVertex(vertex, schemaGraph) + "." + appliedDirectiveContainer.idForVertex(vertex, schemaGraph) + "." + appliedDirective.idForVertex(vertex, schemaGraph) + "." + appliedArgumentName.idForVertex(vertex, schemaGraph);
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(appliedArgumentType, combined);
        return contexts;
    }

    private static List<VertexContextSegment> schemaContext() {
        VertexContextSegment schema = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Schema".equals(vertex.getType());
            }
        };
        return Collections.singletonList(schema);
    }

    private static List<VertexContextSegment> fieldContext() {
        VertexContextSegment field = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Field".equals(vertex.getType());
            }
        };
        VertexContextSegment container = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex field, SchemaGraph schemaGraph) {
                Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(field);
                return fieldsContainer.getType() + "." + fieldsContainer.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment fieldName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex field, SchemaGraph schemaGraph) {
                return field.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(field, container, fieldName);
        return contexts;
    }

    private static List<VertexContextSegment> argumentsContexts() {
        VertexContextSegment argumentType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Argument".equals(vertex.getType());
            }
        };
        VertexContextSegment fieldOrDirective = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex argument, SchemaGraph schemaGraph) {
                Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(argument);
                return fieldOrDirective.getType() + "." + fieldOrDirective.getName();
            }

            @Override
            public boolean filter(Vertex argument, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment containerOrDirectiveHolder = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex argument, SchemaGraph schemaGraph) {
                Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(argument);
                if (fieldOrDirective.getType().equals("Field")) {
                    Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(fieldOrDirective);
                    return fieldsContainer.getType() + "." + fieldsContainer.getName();
                }
                return "";
            }

            @Override
            public boolean filter(Vertex argument, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment argumentName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex argument, SchemaGraph schemaGraph) {
                return argument.getName();
            }

            @Override
            public boolean filter(Vertex argument, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(argumentType, containerOrDirectiveHolder, fieldOrDirective, argumentName);
        return contexts;
    }

    public PossibleMappingsCalculator(SchemaGraph sourceGraph, SchemaGraph targetGraph, SchemaDiffingRunningCheck runningCheck) {
        this.runningCheck = runningCheck;
        this.sourceGraph = sourceGraph;
        this.targetGraph = targetGraph;
        this.possibleMappings = new PossibleMappings();
    }

    public PossibleMappings calculate() {
        this.calcPossibleMappings(typeContexts.get("Schema"), "Schema");
        this.calcPossibleMappings(typeContexts.get("Field"), "Field");
        this.calcPossibleMappings(typeContexts.get("Argument"), "Argument");
        this.calcPossibleMappings(typeContexts.get("InputField"), "InputField");
        this.calcPossibleMappings(typeContexts.get("Object"), "Object");
        this.calcPossibleMappings(typeContexts.get("Interface"), "Interface");
        this.calcPossibleMappings(typeContexts.get("Union"), "Union");
        this.calcPossibleMappings(typeContexts.get("InputObject"), "InputObject");
        this.calcPossibleMappings(typeContexts.get("Scalar"), "Scalar");
        this.calcPossibleMappings(typeContexts.get("Enum"), "Enum");
        this.calcPossibleMappings(typeContexts.get("EnumValue"), "EnumValue");
        this.calcPossibleMappings(typeContexts.get("AppliedDirective"), "AppliedDirective");
        this.calcPossibleMappings(typeContexts.get("AppliedArgument"), "AppliedArgument");
        this.calcPossibleMappings(typeContexts.get("Directive"), "Directive");
        this.sourceGraph.addVertices(this.possibleMappings.allIsolatedSource);
        this.targetGraph.addVertices(this.possibleMappings.allIsolatedTarget);
        Assert.assertTrue(this.sourceGraph.size() == this.targetGraph.size());
        Set<Vertex> vertices = this.possibleMappings.possibleMappings.keySet();
        for (Vertex vertex : vertices) {
            if (this.possibleMappings.possibleMappings.get(vertex).size() <= 1) continue;
        }
        return this.possibleMappings;
    }

    public void calcPossibleMappings(List<VertexContextSegment> contexts, String typeNameForDebug) {
        List<Vertex> currentSourceVertices = this.sourceGraph.getVertices();
        List<Vertex> currentTargetVertices = this.targetGraph.getVertices();
        this.calcPossibleMappingImpl(currentSourceVertices, currentTargetVertices, Collections.emptyList(), 0, contexts, new LinkedHashSet<Vertex>(), new LinkedHashSet<Vertex>(), typeNameForDebug);
    }

    private void calcPossibleMappingImpl(Collection<Vertex> currentSourceVertices, Collection<Vertex> currentTargetVertices, List<String> contextId, int contextIx, List<VertexContextSegment> contexts, Set<Vertex> usedSourceVertices, Set<Vertex> usedTargetVertices, String typeNameForDebug) {
        this.runningCheck.check();
        VertexContextSegment finalCurrentContext = contexts.get(contextIx);
        Map<String, ImmutableList<Vertex>> sourceGroups = FpKit.filterAndGroupingBy(currentSourceVertices, v -> finalCurrentContext.filter((Vertex)v, this.sourceGraph), v -> finalCurrentContext.idForVertex((Vertex)v, this.sourceGraph));
        Map<String, ImmutableList<Vertex>> targetGroups = FpKit.filterAndGroupingBy(currentTargetVertices, v -> finalCurrentContext.filter((Vertex)v, this.targetGraph), v -> finalCurrentContext.idForVertex((Vertex)v, this.targetGraph));
        ArrayList<String> deletedContexts = new ArrayList<String>();
        ArrayList<String> insertedContexts = new ArrayList<String>();
        ArrayList<String> sameContexts = new ArrayList<String>();
        Util.diffNamedList(sourceGroups.keySet(), targetGroups.keySet(), deletedContexts, insertedContexts, sameContexts);
        for (String string : sameContexts) {
            ImmutableList<Vertex> sourceVerticesInContext = sourceGroups.get(string);
            ImmutableList<Vertex> targetVerticesInContext = targetGroups.get(string);
            List<String> currentContextId = FpKit.concat(contextId, string);
            if (contexts.size() > contextIx + 1) {
                this.calcPossibleMappingImpl(sourceVerticesInContext, targetVerticesInContext, currentContextId, contextIx + 1, contexts, usedSourceVertices, usedTargetVertices, typeNameForDebug);
            }
            LinkedHashSet<Vertex> notUsedSource = new LinkedHashSet<Vertex>(sourceVerticesInContext);
            notUsedSource.removeAll(usedSourceVertices);
            LinkedHashSet<Vertex> notUsedTarget = new LinkedHashSet<Vertex>(targetVerticesInContext);
            notUsedTarget.removeAll(usedTargetVertices);
            this.possibleMappings.putPossibleMappings(currentContextId, notUsedSource, notUsedTarget, typeNameForDebug);
            usedSourceVertices.addAll(notUsedSource);
            usedTargetVertices.addAll(notUsedTarget);
        }
        LinkedHashSet<Vertex> possibleSourceVertices = new LinkedHashSet<Vertex>();
        for (String deletedContext : deletedContexts) {
            ImmutableList<Vertex> vertices = sourceGroups.get(deletedContext);
            for (Vertex sourceVertex : vertices) {
                if (usedSourceVertices.contains(sourceVertex)) continue;
                possibleSourceVertices.add(sourceVertex);
            }
            usedSourceVertices.addAll(vertices);
        }
        LinkedHashSet<Vertex> linkedHashSet = new LinkedHashSet<Vertex>();
        for (String insertedContext : insertedContexts) {
            ImmutableList<Vertex> vertices = targetGroups.get(insertedContext);
            for (Vertex targetVertex : vertices) {
                if (usedTargetVertices.contains(targetVertex)) continue;
                linkedHashSet.add(targetVertex);
            }
            usedTargetVertices.addAll(vertices);
        }
        if (contextId.size() == 0) {
            contextId = Collections.singletonList(typeNameForDebug);
        }
        this.possibleMappings.putPossibleMappings(contextId, possibleSourceVertices, linkedHashSet, typeNameForDebug);
    }

    public Map<Vertex, Vertex> getFixedParentRestrictions() {
        return this.getFixedParentRestrictions(this.sourceGraph, this.possibleMappings.fixedOneToOneSources, this.possibleMappings.fixedOneToOneMappings);
    }

    public Map<Vertex, Vertex> getFixedParentRestrictionsInverse(Map<Vertex, Vertex> fixedOneToOneMappingsInverted) {
        return this.getFixedParentRestrictions(this.targetGraph, this.possibleMappings.fixedOneToOneTargets, fixedOneToOneMappingsInverted);
    }

    private Map<Vertex, Vertex> getFixedParentRestrictions(SchemaGraph sourceGraph, List<Vertex> fixedSourceVertices, Map<Vertex, Vertex> fixedOneToOneMappings) {
        Assert.assertFalse(fixedOneToOneMappings.isEmpty());
        ArrayList<Vertex> needsFixing = new ArrayList<Vertex>(sourceGraph.getVertices());
        needsFixing.removeAll(fixedSourceVertices);
        LinkedHashMap<Vertex, Vertex> restrictions = new LinkedHashMap<Vertex, Vertex>();
        for (Vertex vertex : needsFixing) {
            Vertex sourceParent;
            Vertex fixedTargetParent;
            if (!PossibleMappingsCalculator.hasParentRestrictions(vertex) || (fixedTargetParent = fixedOneToOneMappings.get(sourceParent = sourceGraph.getSingleAdjacentInverseVertex(vertex))) == null) continue;
            for (Edge edge : sourceGraph.getAdjacentEdgesNonCopy(sourceParent)) {
                Vertex sibling = edge.getTo();
                if (!PossibleMappingsCalculator.hasParentRestrictions(sibling)) continue;
                restrictions.put(sibling, fixedTargetParent);
            }
        }
        return restrictions;
    }

    public Map<Vertex, Vertex> getNonFixedParentRestrictions(SchemaGraph sourceGraph, SchemaGraph targetGraph, Mapping mapping) {
        LinkedHashMap<Vertex, Vertex> restrictions = new LinkedHashMap<Vertex, Vertex>();
        mapping.forEachNonFixedSourceAndTarget((source, target) -> {
            block3: {
                block2: {
                    if (!PossibleMappingsCalculator.hasChildrenRestrictions(source) || !PossibleMappingsCalculator.hasChildrenRestrictions(target)) break block2;
                    for (Edge edge : sourceGraph.getAdjacentEdgesNonCopy((Vertex)source)) {
                        Vertex child = edge.getTo();
                        if (!PossibleMappingsCalculator.hasParentRestrictions(child)) continue;
                        restrictions.put(child, (Vertex)target);
                    }
                    break block3;
                }
                if (!PossibleMappingsCalculator.hasParentRestrictions(source) || !PossibleMappingsCalculator.hasParentRestrictions(target)) break block3;
                Vertex sourceParent = sourceGraph.getSingleAdjacentInverseVertex((Vertex)source);
                Vertex targetParent = targetGraph.getSingleAdjacentInverseVertex((Vertex)target);
                for (Edge edge : sourceGraph.getAdjacentEdgesNonCopy(sourceParent)) {
                    Vertex sibling = edge.getTo();
                    if (!PossibleMappingsCalculator.hasParentRestrictions(sibling)) continue;
                    restrictions.put(sibling, targetParent);
                }
            }
        });
        return restrictions;
    }

    public static boolean hasParentRestrictions(Vertex vertex) {
        return vertex.isOfType("Field") || vertex.isOfType("InputField") || vertex.isOfType("EnumValue") || vertex.isOfType("Argument");
    }

    public static boolean hasChildrenRestrictions(Vertex vertex) {
        return vertex.isOfType("InputObject") || vertex.isOfType("Object") || vertex.isOfType("Enum");
    }

    static {
        typeContexts.put("Schema", PossibleMappingsCalculator.schemaContext());
        typeContexts.put("Field", PossibleMappingsCalculator.fieldContext());
        typeContexts.put("Argument", PossibleMappingsCalculator.argumentsContexts());
        typeContexts.put("InputField", PossibleMappingsCalculator.inputFieldContexts());
        typeContexts.put("Object", PossibleMappingsCalculator.objectContext());
        typeContexts.put("Interface", PossibleMappingsCalculator.interfaceContext());
        typeContexts.put("Union", PossibleMappingsCalculator.unionContext());
        typeContexts.put("InputObject", PossibleMappingsCalculator.inputObjectContext());
        typeContexts.put("Scalar", PossibleMappingsCalculator.scalarContext());
        typeContexts.put("Enum", PossibleMappingsCalculator.enumContext());
        typeContexts.put("EnumValue", PossibleMappingsCalculator.enumValueContext());
        typeContexts.put("AppliedDirective", PossibleMappingsCalculator.appliedDirectiveContext());
        typeContexts.put("AppliedArgument", PossibleMappingsCalculator.appliedArgumentContext());
        typeContexts.put("Directive", PossibleMappingsCalculator.directiveContext());
    }

    public class PossibleMappings {
        public Set<Vertex> allIsolatedSource = new LinkedHashSet<Vertex>();
        public Set<Vertex> allIsolatedTarget = new LinkedHashSet<Vertex>();
        public Table<List<String>, Set<Vertex>, Set<Vertex>> contexts = HashBasedTable.create();
        public Multimap<Vertex, Vertex> possibleMappings = HashMultimap.create();
        public BiMap<Vertex, Vertex> fixedOneToOneMappings = HashBiMap.create();
        public List<Vertex> fixedOneToOneSources = new ArrayList<Vertex>();
        public List<Vertex> fixedOneToOneTargets = new ArrayList<Vertex>();

        public void putPossibleMappings(List<String> contextId, Collection<Vertex> sourceVertices, Collection<Vertex> targetVertices, String typeName) {
            if (sourceVertices.isEmpty() && targetVertices.isEmpty()) {
                return;
            }
            if (sourceVertices.size() == 1 && targetVertices.size() == 1) {
                Vertex sourceVertex = sourceVertices.iterator().next();
                Vertex targetVertex = targetVertices.iterator().next();
                this.fixedOneToOneMappings.put(sourceVertex, targetVertex);
                this.fixedOneToOneSources.add(sourceVertex);
                this.fixedOneToOneTargets.add(targetVertex);
                return;
            }
            if ("AppliedDirective".equals(typeName) || "AppliedArgument".equals(typeName)) {
                for (Vertex sourceVertex : sourceVertices) {
                    Vertex isolatedTarget = Vertex.newIsolatedNode("target-isolated-" + typeName);
                    this.allIsolatedTarget.add(isolatedTarget);
                    this.fixedOneToOneMappings.put(sourceVertex, isolatedTarget);
                    this.fixedOneToOneSources.add(sourceVertex);
                    this.fixedOneToOneTargets.add(isolatedTarget);
                }
                for (Vertex targetVertex : targetVertices) {
                    Vertex isolatedSource = Vertex.newIsolatedNode("source-isolated-" + typeName);
                    this.allIsolatedSource.add(isolatedSource);
                    this.fixedOneToOneMappings.put(isolatedSource, targetVertex);
                    this.fixedOneToOneSources.add(isolatedSource);
                    this.fixedOneToOneTargets.add(targetVertex);
                }
                return;
            }
            Set<Object> newIsolatedSource = Collections.emptySet();
            Set<Object> newIsolatedTarget = Collections.emptySet();
            if (sourceVertices.size() > targetVertices.size()) {
                newIsolatedTarget = Vertex.newIsolatedNodes(sourceVertices.size() - targetVertices.size(), "target-isolated-" + typeName + "-");
            } else if (targetVertices.size() > sourceVertices.size()) {
                newIsolatedSource = Vertex.newIsolatedNodes(targetVertices.size() - sourceVertices.size(), "source-isolated-" + typeName + "-");
            }
            this.allIsolatedSource.addAll(newIsolatedSource);
            this.allIsolatedTarget.addAll(newIsolatedTarget);
            if (sourceVertices.size() == 0) {
                Iterator<Object> iterator = newIsolatedSource.iterator();
                for (Vertex targetVertex : targetVertices) {
                    Vertex vertex = (Vertex)iterator.next();
                    this.fixedOneToOneMappings.put(vertex, targetVertex);
                    this.fixedOneToOneSources.add(vertex);
                    this.fixedOneToOneTargets.add(targetVertex);
                }
                return;
            }
            if (targetVertices.size() == 0) {
                Iterator<Object> iterator = newIsolatedTarget.iterator();
                for (Vertex sourceVertex : sourceVertices) {
                    Vertex vertex = (Vertex)iterator.next();
                    this.fixedOneToOneMappings.put(sourceVertex, vertex);
                    this.fixedOneToOneSources.add(sourceVertex);
                    this.fixedOneToOneTargets.add(vertex);
                }
                return;
            }
            Assert.assertFalse(this.contexts.containsRow(contextId));
            LinkedHashSet<Object> allSource = new LinkedHashSet<Object>();
            allSource.addAll(sourceVertices);
            allSource.addAll(newIsolatedSource);
            LinkedHashSet<Object> allTarget = new LinkedHashSet<Object>();
            allTarget.addAll(targetVertices);
            allTarget.addAll(newIsolatedTarget);
            this.contexts.put(contextId, allSource, allTarget);
            for (Vertex vertex : sourceVertices) {
                this.possibleMappings.putAll(vertex, targetVertices);
                this.possibleMappings.putAll(vertex, newIsolatedTarget);
            }
            for (Vertex vertex : newIsolatedSource) {
                this.possibleMappings.putAll(vertex, targetVertices);
                this.possibleMappings.putAll(vertex, newIsolatedTarget);
            }
        }

        public boolean mappingPossible(Vertex sourceVertex, Vertex targetVertex) {
            return this.possibleMappings.containsEntry(sourceVertex, targetVertex);
        }
    }

    public static abstract class VertexContextSegment {
        public abstract String idForVertex(Vertex var1, SchemaGraph var2);

        public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
            return true;
        }
    }
}

