/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;

public class TypeUtil {
    public static String simplePrint(Type type) {
        if (TypeUtil.isNonNull(type)) {
            return TypeUtil.simplePrint(TypeUtil.unwrapOne(type)) + "!";
        }
        if (TypeUtil.isList(type)) {
            return "[" + TypeUtil.simplePrint(TypeUtil.unwrapOne(type)) + "]";
        }
        return ((TypeName)type).getName();
    }

    public static TypeName unwrapAll(Type type) {
        if (TypeUtil.isList(type)) {
            return TypeUtil.unwrapAll(((ListType)type).getType());
        }
        if (type instanceof NonNullType) {
            return TypeUtil.unwrapAll(((NonNullType)type).getType());
        }
        return (TypeName)type;
    }

    public static Type unwrapOne(Type type) {
        if (TypeUtil.isNonNull(type)) {
            return ((NonNullType)type).getType();
        }
        if (TypeUtil.isList(type)) {
            return ((ListType)type).getType();
        }
        return type;
    }

    public static boolean isNonNull(Type type) {
        return type instanceof NonNullType;
    }

    public static boolean isList(Type type) {
        return type instanceof ListType;
    }

    public static boolean isWrapped(Type type) {
        return TypeUtil.isList(type) || TypeUtil.isNonNull(type);
    }
}

