/*
 * Decompiled with CFR 0.152.
 */
package zmq.pipe;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import zmq.Msg;

class DBuffer<T extends Msg> {
    private T back;
    private T front;
    private final Lock sync = new ReentrantLock();
    private boolean hasMsg;

    DBuffer() {
    }

    public T back() {
        return this.back;
    }

    public T front() {
        return this.front;
    }

    void write(T msg) {
        assert (((Msg)msg).check());
        this.sync.lock();
        try {
            this.back = this.front;
            this.front = msg;
            this.hasMsg = true;
        }
        finally {
            this.sync.unlock();
        }
    }

    T read() {
        this.sync.lock();
        try {
            if (!this.hasMsg) {
                T t2 = null;
                return t2;
            }
            assert (((Msg)this.front).check());
            this.hasMsg = false;
            T t3 = this.front;
            return t3;
        }
        finally {
            this.sync.unlock();
        }
    }

    boolean checkRead() {
        this.sync.lock();
        try {
            boolean bl = this.hasMsg;
            return bl;
        }
        finally {
            this.sync.unlock();
        }
    }

    T probe() {
        this.sync.lock();
        try {
            T t2 = this.front;
            return t2;
        }
        finally {
            this.sync.unlock();
        }
    }
}

