/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.containers.mp4.TimeUtil;
import org.jcodec.containers.mp4.boxes.FullBox;
import org.jcodec.containers.mp4.boxes.Header;

public class MediaHeaderBox
extends FullBox {
    private long created;
    private long modified;
    private int timescale;
    private long duration;
    private int language;
    private int quality;

    public MediaHeaderBox(Header atom) {
        super(atom);
    }

    public static String fourcc() {
        return "mdhd";
    }

    public static MediaHeaderBox createMediaHeaderBox(int timescale, long duration, int language, long created, long modified, int quality) {
        MediaHeaderBox mdhd = new MediaHeaderBox(new Header(MediaHeaderBox.fourcc()));
        mdhd.timescale = timescale;
        mdhd.duration = duration;
        mdhd.language = language;
        mdhd.created = created;
        mdhd.modified = modified;
        mdhd.quality = quality;
        return mdhd;
    }

    public int getTimescale() {
        return this.timescale;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getCreated() {
        return this.created;
    }

    public long getModified() {
        return this.modified;
    }

    public int getLanguage() {
        return this.language;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setTimescale(int timescale) {
        this.timescale = timescale;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        if (this.version == 0) {
            this.created = TimeUtil.fromMovTime(input.getInt());
            this.modified = TimeUtil.fromMovTime(input.getInt());
            this.timescale = input.getInt();
            this.duration = input.getInt();
        } else if (this.version == 1) {
            this.created = TimeUtil.fromMovTime((int)input.getLong());
            this.modified = TimeUtil.fromMovTime((int)input.getLong());
            this.timescale = input.getInt();
            this.duration = input.getLong();
        } else {
            throw new RuntimeException("Unsupported version");
        }
    }

    @Override
    public void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(TimeUtil.toMovTime(this.created));
        out.putInt(TimeUtil.toMovTime(this.modified));
        out.putInt(this.timescale);
        out.putInt((int)this.duration);
        out.putShort((short)this.language);
        out.putShort((short)this.quality);
    }

    @Override
    public int estimateSize() {
        return 32;
    }
}

