/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariDriverService
extends DriverService {
    public static final String SAFARI_DRIVER_NAME = "safaridriver";
    public static final String SAFARI_DRIVER_EXE_PROPERTY = "webdriver.safari.driver";
    public static final String SAFARI_DRIVER_EXE_ENVIRONMENT_VARIABLE = "SE_SAFARIDRIVER";
    public static final String SAFARI_DRIVER_LOGGING = "webdriver.safari.logging";
    private static final File SAFARI_DRIVER_EXECUTABLE = new File("/usr/bin/safaridriver");

    public SafariDriverService(@Nullable File executable, int port, @Nullable Duration timeout, @Nullable List<String> args, @Nullable Map<String, String> environment) throws IOException {
        super(executable, port, timeout, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment)));
    }

    @Override
    public String getDriverName() {
        return SAFARI_DRIVER_NAME;
    }

    @Override
    public String getDriverProperty() {
        return SAFARI_DRIVER_EXE_PROPERTY;
    }

    @Override
    public String getDriverEnvironmentVariable() {
        return SAFARI_DRIVER_EXE_ENVIRONMENT_VARIABLE;
    }

    @Override
    public File getDriverExecutable() {
        return SAFARI_DRIVER_EXECUTABLE;
    }

    @Override
    protected Capabilities getDefaultDriverOptions() {
        return new SafariOptions();
    }

    public static SafariDriverService createDefaultService() {
        return (SafariDriverService)new Builder().build();
    }

    @Override
    protected void waitUntilAvailable() {
        try {
            PortProber.waitForPortUp(this.getUrl().getPort(), (int)this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            throw new WebDriverException(e);
        }
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<SafariDriverService, Builder> {
        private @Nullable Boolean diagnose;

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.SAFARI.is(capabilities)) {
                ++score;
            }
            return score;
        }

        public Builder withLogging(@Nullable Boolean logging) {
            this.diagnose = logging;
            return this;
        }

        @Override
        public Builder withLogFile(@Nullable File logFile) {
            throw new WebDriverException("Can not set log location for Safari; use withLogging(true) and locate log in ~/Library/Logs/com.apple.WebDriver/");
        }

        @Override
        protected void loadSystemProperties() {
            if (this.diagnose == null) {
                this.diagnose = Boolean.getBoolean(SafariDriverService.SAFARI_DRIVER_LOGGING);
            }
        }

        @Override
        protected List<String> createArgs() {
            ArrayList<String> args = new ArrayList<String>(Arrays.asList("--port", String.valueOf(this.getPort())));
            if (Boolean.TRUE.equals(this.diagnose)) {
                args.add("--diagnose");
            }
            return args;
        }

        @Override
        protected SafariDriverService createDriverService(@Nullable File exe, int port, @Nullable Duration timeout, @Nullable List<String> args, @Nullable Map<String, String> environment) {
            try {
                this.withLogOutput(OutputStream.nullOutputStream());
                return new SafariDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

