/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.language.NodeUtil;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.schema.GraphQLObjectType;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.List;

@Internal
public class SubscriptionUniqueRootField
extends AbstractRule {
    private final FieldCollector fieldCollector = new FieldCollector();

    public SubscriptionUniqueRootField(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkOperationDefinition(OperationDefinition operationDef) {
        if (operationDef.getOperation() == OperationDefinition.Operation.SUBSCRIPTION) {
            GraphQLObjectType subscriptionType = this.getValidationContext().getSchema().getSubscriptionType();
            FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(this.getValidationContext().getSchema()).fragments(NodeUtil.getFragmentsByName(this.getValidationContext().getDocument())).variables(CoercedVariables.emptyVariables().toMap()).objectType(subscriptionType).graphQLContext(this.getValidationContext().getGraphQLContext()).build();
            MergedSelectionSet fields = this.fieldCollector.collectFields(collectorParameters, operationDef.getSelectionSet());
            List<Selection> subscriptionSelections = operationDef.getSelectionSet().getSelections();
            if (fields.size() > 1) {
                String message = this.i18n(ValidationErrorType.SubscriptionMultipleRootFields, "SubscriptionUniqueRootField.multipleRootFields", operationDef.getName());
                this.addError(ValidationErrorType.SubscriptionMultipleRootFields, operationDef.getSourceLocation(), message);
            } else {
                MergedField mergedField = fields.getSubFieldsList().get(0);
                if (this.isIntrospectionField(mergedField)) {
                    String message = this.i18n(ValidationErrorType.SubscriptionIntrospectionRootField, "SubscriptionIntrospectionRootField.introspectionRootField", operationDef.getName(), mergedField.getName());
                    this.addError(ValidationErrorType.SubscriptionIntrospectionRootField, mergedField.getSingleField().getSourceLocation(), message);
                }
            }
        }
    }

    private boolean isIntrospectionField(MergedField field) {
        return field.getName().startsWith("__");
    }
}

