/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.instrumentation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.DataLoader;
import org.dataloader.DispatchResult;
import org.dataloader.annotations.PublicApi;
import org.dataloader.instrumentation.DataLoaderInstrumentation;
import org.dataloader.instrumentation.DataLoaderInstrumentationContext;
import org.dataloader.instrumentation.DataLoaderInstrumentationHelper;

@PublicApi
public class ChainedDataLoaderInstrumentation
implements DataLoaderInstrumentation {
    private final List<DataLoaderInstrumentation> instrumentations;

    public ChainedDataLoaderInstrumentation() {
        this.instrumentations = List.of();
    }

    public ChainedDataLoaderInstrumentation(List<DataLoaderInstrumentation> instrumentations) {
        this.instrumentations = List.copyOf(instrumentations);
    }

    public List<DataLoaderInstrumentation> getInstrumentations() {
        return this.instrumentations;
    }

    public ChainedDataLoaderInstrumentation add(DataLoaderInstrumentation instrumentation) {
        ArrayList<DataLoaderInstrumentation> list = new ArrayList<DataLoaderInstrumentation>(this.instrumentations);
        list.add(instrumentation);
        return new ChainedDataLoaderInstrumentation(list);
    }

    public ChainedDataLoaderInstrumentation prepend(DataLoaderInstrumentation instrumentation) {
        ArrayList<DataLoaderInstrumentation> list = new ArrayList<DataLoaderInstrumentation>();
        list.add(instrumentation);
        list.addAll(this.instrumentations);
        return new ChainedDataLoaderInstrumentation(list);
    }

    public ChainedDataLoaderInstrumentation addAll(Collection<DataLoaderInstrumentation> instrumentations) {
        ArrayList<DataLoaderInstrumentation> list = new ArrayList<DataLoaderInstrumentation>(this.instrumentations);
        list.addAll(instrumentations);
        return new ChainedDataLoaderInstrumentation(list);
    }

    @Override
    public DataLoaderInstrumentationContext<Object> beginLoad(DataLoader<?, ?> dataLoader, Object key, Object loadContext) {
        return this.chainedCtx(it -> it.beginLoad(dataLoader, key, loadContext));
    }

    @Override
    public DataLoaderInstrumentationContext<DispatchResult<?>> beginDispatch(DataLoader<?, ?> dataLoader) {
        return this.chainedCtx(it -> it.beginDispatch(dataLoader));
    }

    @Override
    public DataLoaderInstrumentationContext<List<?>> beginBatchLoader(DataLoader<?, ?> dataLoader, List<?> keys, BatchLoaderEnvironment environment) {
        return this.chainedCtx(it -> it.beginBatchLoader(dataLoader, keys, environment));
    }

    private <T> DataLoaderInstrumentationContext<T> chainedCtx(Function<DataLoaderInstrumentation, DataLoaderInstrumentationContext<T>> mapper) {
        if (this.instrumentations.isEmpty()) {
            return DataLoaderInstrumentationHelper.noOpCtx();
        }
        if (this.instrumentations.size() == 1) {
            return mapper.apply(this.instrumentations.get(0));
        }
        return new ChainedInstrumentationContext<T>(this.dropNullContexts(mapper));
    }

    private <T> List<DataLoaderInstrumentationContext<T>> dropNullContexts(Function<DataLoaderInstrumentation, DataLoaderInstrumentationContext<T>> mapper) {
        return this.instrumentations.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static class ChainedInstrumentationContext<T>
    implements DataLoaderInstrumentationContext<T> {
        private final List<DataLoaderInstrumentationContext<T>> contexts;

        public ChainedInstrumentationContext(List<DataLoaderInstrumentationContext<T>> contexts) {
            this.contexts = contexts;
        }

        @Override
        public void onDispatched() {
            this.contexts.forEach(DataLoaderInstrumentationContext::onDispatched);
        }

        @Override
        public void onCompleted(T result, Throwable t2) {
            this.contexts.forEach(it -> it.onCompleted(result, t2));
        }
    }
}

