/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.internal.Require;

@Beta
public class Reference {
    private static final String DEFAULT_DOMAIN = "docker.io";
    private static final String LEGACY_DEFAULT_DOMAIN = "index.docker.io";
    private static final String DEFAULT_REPO = "library";
    private static final String DEFAULT_TAG = "latest";
    private final String domain;
    private final String name;
    private final String tag;
    private final String digest;
    private final String platform;

    @VisibleForTesting
    Reference(String domain, String name, String tag, String digest) {
        this.domain = Require.nonNull("Domain", domain);
        this.name = Require.nonNull("Name", name);
        this.tag = tag;
        this.digest = digest;
        this.platform = Reference.getDefaultPlatform();
    }

    @VisibleForTesting
    Reference(String domain, String name, String tag, String digest, String platform) {
        this.domain = Require.nonNull("Domain", domain);
        this.name = Require.nonNull("Name", name);
        this.tag = tag;
        this.digest = digest;
        this.platform = Require.nonNull("Platform", platform);
    }

    public static Reference parse(String input) {
        String name;
        Require.nonNull("Reference to parse", input);
        ImmutableMap<String, String> splitDockerDomain = Reference.splitDockerDomain(input);
        String domain = splitDockerDomain.get("domain");
        String remainder = splitDockerDomain.get("remainder");
        String digest = splitDockerDomain.get("digest").isEmpty() ? null : splitDockerDomain.get("digest");
        String platform = splitDockerDomain.get("platform");
        String tag = DEFAULT_TAG;
        int tagSep = remainder.indexOf(":");
        if (digest != null) {
            tag = null;
            name = remainder;
        } else if (tagSep > -1) {
            tag = remainder.substring(tagSep + 1);
            name = remainder.substring(0, tagSep);
        } else {
            name = remainder;
        }
        if (!name.toLowerCase().equals(name)) {
            throw new DockerException(String.format("Invalid reference format: repository name (%s) must be lowercase", name));
        }
        return new Reference(domain, name, tag, digest, platform);
    }

    private static ImmutableMap<String, String> splitDockerDomain(String name) {
        String domain;
        String remainder;
        int domSep;
        String possibleDomain;
        String platform = Reference.getDefaultPlatform();
        String digest = "";
        int platformSep = name.lastIndexOf("@");
        if (platformSep > -1) {
            String[] parts = name.substring(platformSep + 1).split("/");
            if (parts.length == 2) {
                platform = name.substring(platformSep + 1);
            } else if (parts[0].contains(":")) {
                digest = name.substring(platformSep + 1);
            }
            name = name.substring(0, platformSep);
        }
        String string = possibleDomain = (domSep = name.indexOf("/")) == -1 ? "" : name.substring(0, domSep);
        if (domSep == -1 || !possibleDomain.contains(".") && !possibleDomain.contains(":") && !"localhost".equalsIgnoreCase(possibleDomain) && possibleDomain.toLowerCase().equals(possibleDomain)) {
            remainder = name;
            domain = DEFAULT_DOMAIN;
        } else {
            domain = possibleDomain;
            remainder = name.substring(domSep + 1);
        }
        if (LEGACY_DEFAULT_DOMAIN.equals(domain)) {
            domain = DEFAULT_DOMAIN;
        }
        if (DEFAULT_DOMAIN.equals(domain) && !remainder.contains("/")) {
            remainder = String.format("%s/%s", DEFAULT_REPO, remainder);
        }
        return ImmutableMap.of("domain", domain, "remainder", remainder, "platform", platform, "digest", digest);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getFamiliarName() {
        StringBuilder familiar = new StringBuilder();
        if (!DEFAULT_DOMAIN.equals(this.domain)) {
            familiar.append(this.domain).append("/");
        }
        if (this.name.contains(DEFAULT_REPO) && DEFAULT_DOMAIN.equals(this.domain)) {
            familiar.append(this.name.replace("library/", ""));
        } else {
            familiar.append(this.name);
        }
        if (this.digest != null) {
            familiar.append("@").append(this.digest);
        } else if (this.tag != null) {
            familiar.append(":").append(this.tag);
        } else {
            throw new DockerException("Unable to form familiar name: " + String.valueOf(this));
        }
        return familiar.toString();
    }

    private static String getDefaultPlatform() {
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.contains("amd64") || arch.contains("x86_64")) {
            arch = "amd64";
        } else if (arch.contains("arm64") || arch.contains("aarch64")) {
            arch = "arm64";
        }
        return "linux/" + arch;
    }

    public String toString() {
        return "Reference{domain='" + this.domain + "', name='" + this.name + "', tag='" + this.tag + "', digest='" + this.digest + "', platform='" + this.platform + "}";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Reference)) {
            return false;
        }
        Reference that = (Reference)o;
        return this.domain.equals(that.domain) && this.name.equals(that.name) && Objects.equals(this.tag, that.tag) && Objects.equals(this.digest, that.digest) && Objects.equals(this.platform, that.platform);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.name, this.tag, this.digest, this.platform);
    }
}

