/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import org.apache.commons.io.input.ClosedInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClosedInputStreamTest {
    ClosedInputStreamTest() {
    }

    private void assertEof(ClosedInputStream cis) {
        Assertions.assertEquals((int)-1, (int)cis.read(), (String)"read()");
    }

    @Test
    void testAvailableAfterClose() throws Exception {
        ClosedInputStream shadow;
        Assertions.assertEquals((int)0, (int)ClosedInputStream.INSTANCE.available());
        Assertions.assertEquals((int)0, (int)ClosedInputStream.INSTANCE.available());
        try (ClosedInputStream in = new ClosedInputStream();){
            Assertions.assertEquals((int)0, (int)in.available());
            shadow = in;
        }
        Assertions.assertEquals((int)0, (int)shadow.available());
    }

    @Test
    void testAvailableAfterOpen() throws Exception {
        Assertions.assertEquals((int)0, (int)ClosedInputStream.INSTANCE.available());
        Assertions.assertEquals((int)0, (int)ClosedInputStream.INSTANCE.available());
        try (ClosedInputStream cis = new ClosedInputStream();){
            Assertions.assertEquals((int)0, (int)cis.available());
        }
    }

    @Test
    void testNonNull() throws Exception {
        Assertions.assertSame((Object)ClosedInputStream.INSTANCE, (Object)ClosedInputStream.ifNull(null));
        Assertions.assertSame((Object)ClosedInputStream.INSTANCE, (Object)ClosedInputStream.ifNull((InputStream)ClosedInputStream.INSTANCE));
        Assertions.assertSame((Object)System.in, (Object)ClosedInputStream.ifNull((InputStream)System.in));
    }

    @Test
    void testRead() throws Exception {
        try (ClosedInputStream cis = new ClosedInputStream();){
            this.assertEof(cis);
        }
    }

    @Test
    void testReadAfterCose() throws Exception {
        ClosedInputStream shadow;
        Assertions.assertEquals((int)0, (int)ClosedInputStream.INSTANCE.available());
        Assertions.assertEquals((int)0, (int)ClosedInputStream.INSTANCE.available());
        try (ClosedInputStream in = new ClosedInputStream();){
            Assertions.assertEquals((int)0, (int)in.available());
            shadow = in;
        }
        Assertions.assertEquals((int)-1, (int)shadow.read());
    }

    @Test
    void testReadArray() throws Exception {
        try (ClosedInputStream cis = new ClosedInputStream();){
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[4096]));
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[1]));
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[0]));
        }
    }

    @Test
    void testReadArrayIndex() throws Exception {
        try (ClosedInputStream cis = new ClosedInputStream();){
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[4096], 0, 1));
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[1], 0, 1));
            Assertions.assertEquals((int)-1, (int)cis.read(new byte[0], 0, 0));
        }
    }

    @Test
    void testSingleton() throws Exception {
        try (ClosedInputStream cis = ClosedInputStream.CLOSED_INPUT_STREAM;){
            this.assertEof(cis);
        }
        cis = ClosedInputStream.INSTANCE;
        try {
            this.assertEof(cis);
        }
        finally {
            if (cis != null) {
                cis.close();
            }
        }
    }
}

