package org.openqa.selenium.devtools.v141.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Indicates the various types of characteristic write.
 */
public enum CharacteristicWriteType {

    WRITE_DEFAULT_DEPRECATED("write-default-deprecated"), WRITE_WITH_RESPONSE("write-with-response"), WRITE_WITHOUT_RESPONSE("write-without-response");

    private String value;

    CharacteristicWriteType(String value) {
        this.value = value;
    }

    public static CharacteristicWriteType fromString(String s) {
        return java.util.Arrays.stream(CharacteristicWriteType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CharacteristicWriteType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CharacteristicWriteType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
