/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.dataloader;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.DataLoaderDispatchStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.instrumentation.dataloader.LevelMap;
import graphql.schema.DataFetcher;
import graphql.util.LockKit;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dataloader.DataLoaderRegistry;

@Internal
public class PerLevelDataLoaderDispatchStrategy
implements DataLoaderDispatchStrategy {
    private final CallStack callStack = new CallStack();
    private final ExecutionContext executionContext;

    public PerLevelDataLoaderDispatchStrategy(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public void executeDeferredOnFieldValueInfo(FieldValueInfo fieldValueInfo, ExecutionStrategyParameters executionStrategyParameters) {
        throw new UnsupportedOperationException("Data Loaders cannot be used to resolve deferred fields");
    }

    @Override
    public void executionStrategy(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        int curLevel = parameters.getExecutionStepInfo().getPath().getLevel() + 1;
        this.increaseHappenedExecuteObjectAndIncreaseExpectedFetchCount(curLevel, parameters);
    }

    @Override
    public void executionSerialStrategy(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        this.resetCallStack();
        this.increaseHappenedExecuteObjectAndIncreaseExpectedFetchCount(1, 1);
    }

    @Override
    public void executionStrategyOnFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList) {
        this.onFieldValuesInfoDispatchIfNeeded(fieldValueInfoList, 1);
    }

    @Override
    public void executionStrategyOnFieldValuesException(Throwable t2) {
        this.callStack.lock.runLocked(() -> this.callStack.increaseHappenedOnFieldValueCalls(1));
    }

    @Override
    public void executeObject(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        int curLevel = parameters.getExecutionStepInfo().getPath().getLevel() + 1;
        this.increaseHappenedExecuteObjectAndIncreaseExpectedFetchCount(curLevel, parameters);
    }

    @Override
    public void executeObjectOnFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList, ExecutionStrategyParameters parameters) {
        int curLevel = parameters.getPath().getLevel() + 1;
        this.onFieldValuesInfoDispatchIfNeeded(fieldValueInfoList, curLevel);
    }

    @Override
    public void executeObjectOnFieldValuesException(Throwable t2, ExecutionStrategyParameters parameters) {
        int curLevel = parameters.getPath().getLevel() + 1;
        this.callStack.lock.runLocked(() -> this.callStack.increaseHappenedOnFieldValueCalls(curLevel));
    }

    private void increaseHappenedExecuteObjectAndIncreaseExpectedFetchCount(int curLevel, ExecutionStrategyParameters executionStrategyParameters) {
        this.increaseHappenedExecuteObjectAndIncreaseExpectedFetchCount(curLevel, executionStrategyParameters.getFields().size());
    }

    private void increaseHappenedExecuteObjectAndIncreaseExpectedFetchCount(int curLevel, int fieldCount) {
        this.callStack.lock.runLocked(() -> {
            this.callStack.increaseHappenedExecuteObjectCalls(curLevel);
            this.callStack.increaseExpectedFetchCount(curLevel, fieldCount);
        });
    }

    private void resetCallStack() {
        this.callStack.lock.runLocked(() -> {
            this.callStack.clearDispatchLevels();
            this.callStack.clearExpectedObjectCalls();
            this.callStack.clearExpectedFetchCount();
            this.callStack.clearFetchCount();
            this.callStack.clearHappenedExecuteObjectCalls();
            this.callStack.clearHappenedOnFieldValueCalls();
            this.callStack.expectedExecuteObjectCallsPerLevel.set(1, 1);
        });
    }

    private void onFieldValuesInfoDispatchIfNeeded(List<FieldValueInfo> fieldValueInfoList, int curLevel) {
        boolean dispatchNeeded = this.callStack.lock.callLocked(() -> this.handleOnFieldValuesInfo(fieldValueInfoList, curLevel));
        if (dispatchNeeded) {
            this.dispatch(curLevel);
        }
    }

    private boolean handleOnFieldValuesInfo(List<FieldValueInfo> fieldValueInfos, int curLevel) {
        this.callStack.increaseHappenedOnFieldValueCalls(curLevel);
        int expectedOnObjectCalls = this.getObjectCountForList(fieldValueInfos);
        this.callStack.increaseExpectedExecuteObjectCalls(curLevel + 1, expectedOnObjectCalls);
        return this.dispatchIfNeeded(curLevel + 1);
    }

    private int getObjectCountForList(List<FieldValueInfo> fieldValueInfos) {
        int result = 0;
        for (FieldValueInfo fieldValueInfo : fieldValueInfos) {
            if (fieldValueInfo.getCompleteValueType() == FieldValueInfo.CompleteValueType.OBJECT) {
                ++result;
                continue;
            }
            if (fieldValueInfo.getCompleteValueType() != FieldValueInfo.CompleteValueType.LIST) continue;
            result += this.getObjectCountForList(fieldValueInfo.getFieldValueInfos());
        }
        return result;
    }

    @Override
    public void fieldFetched(ExecutionContext executionContext, ExecutionStrategyParameters executionStrategyParameters, DataFetcher<?> dataFetcher, Object fetchedValue) {
        int level = executionStrategyParameters.getPath().getLevel();
        boolean dispatchNeeded = this.callStack.lock.callLocked(() -> {
            this.callStack.increaseFetchCount(level);
            return this.dispatchIfNeeded(level);
        });
        if (dispatchNeeded) {
            this.dispatch(level);
        }
    }

    private boolean dispatchIfNeeded(int level) {
        boolean ready = this.levelReady(level);
        if (ready) {
            return this.callStack.dispatchIfNotDispatchedBefore(level);
        }
        return false;
    }

    private boolean levelReady(int level) {
        if (level == 1) {
            return this.callStack.allFetchesHappened(1);
        }
        return this.levelReady(level - 1) && this.callStack.allOnFieldCallsHappened(level - 1) && this.callStack.allExecuteObjectCallsHappened(level) && this.callStack.allFetchesHappened(level);
    }

    void dispatch(int level) {
        DataLoaderRegistry dataLoaderRegistry = this.executionContext.getDataLoaderRegistry();
        dataLoaderRegistry.dispatchAll();
    }

    private static class CallStack {
        private final LockKit.ReentrantLock lock = new LockKit.ReentrantLock();
        private final LevelMap expectedFetchCountPerLevel = new LevelMap();
        private final LevelMap fetchCountPerLevel = new LevelMap();
        private final LevelMap expectedExecuteObjectCallsPerLevel = new LevelMap();
        private final LevelMap happenedExecuteObjectCallsPerLevel = new LevelMap();
        private final LevelMap happenedOnFieldValueCallsPerLevel = new LevelMap();
        private final Set<Integer> dispatchedLevels = new LinkedHashSet<Integer>();

        public CallStack() {
            this.expectedExecuteObjectCallsPerLevel.set(1, 1);
        }

        void increaseExpectedFetchCount(int level, int count) {
            this.expectedFetchCountPerLevel.increment(level, count);
        }

        void clearExpectedFetchCount() {
            this.expectedFetchCountPerLevel.clear();
        }

        void increaseFetchCount(int level) {
            this.fetchCountPerLevel.increment(level, 1);
        }

        void clearFetchCount() {
            this.fetchCountPerLevel.clear();
        }

        void increaseExpectedExecuteObjectCalls(int level, int count) {
            this.expectedExecuteObjectCallsPerLevel.increment(level, count);
        }

        void clearExpectedObjectCalls() {
            this.expectedExecuteObjectCallsPerLevel.clear();
        }

        void increaseHappenedExecuteObjectCalls(int level) {
            this.happenedExecuteObjectCallsPerLevel.increment(level, 1);
        }

        void clearHappenedExecuteObjectCalls() {
            this.happenedExecuteObjectCallsPerLevel.clear();
        }

        void increaseHappenedOnFieldValueCalls(int level) {
            this.happenedOnFieldValueCallsPerLevel.increment(level, 1);
        }

        void clearHappenedOnFieldValueCalls() {
            this.happenedOnFieldValueCallsPerLevel.clear();
        }

        boolean allExecuteObjectCallsHappened(int level) {
            return this.happenedExecuteObjectCallsPerLevel.get(level) == this.expectedExecuteObjectCallsPerLevel.get(level);
        }

        boolean allOnFieldCallsHappened(int level) {
            return this.happenedOnFieldValueCallsPerLevel.get(level) == this.expectedExecuteObjectCallsPerLevel.get(level);
        }

        boolean allFetchesHappened(int level) {
            return this.fetchCountPerLevel.get(level) == this.expectedFetchCountPerLevel.get(level);
        }

        void clearDispatchLevels() {
            this.dispatchedLevels.clear();
        }

        public String toString() {
            return "CallStack{expectedFetchCountPerLevel=" + String.valueOf(this.expectedFetchCountPerLevel) + ", fetchCountPerLevel=" + String.valueOf(this.fetchCountPerLevel) + ", expectedExecuteObjectCallsPerLevel=" + String.valueOf(this.expectedExecuteObjectCallsPerLevel) + ", happenedExecuteObjectCallsPerLevel=" + String.valueOf(this.happenedExecuteObjectCallsPerLevel) + ", happenedOnFieldValueCallsPerLevel=" + String.valueOf(this.happenedOnFieldValueCallsPerLevel) + ", dispatchedLevels" + String.valueOf(this.dispatchedLevels) + "}";
        }

        public boolean dispatchIfNotDispatchedBefore(int level) {
            if (this.dispatchedLevels.contains(level)) {
                Assert.assertShouldNeverHappen("level " + level + " already dispatched", new Object[0]);
                return false;
            }
            this.dispatchedLevels.add(level);
            return true;
        }
    }
}

