/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.GraphQLError;
import graphql.Internal;
import graphql.i18n.I18nMsg;
import graphql.language.Argument;
import graphql.language.ObjectField;
import graphql.language.Value;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import graphql.validation.ValidationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class ArgumentValidationUtil
extends ValidationUtil {
    private final List<String> argumentNames = new ArrayList<String>();
    private Value<?> argumentValue;
    private String errMsgKey;
    private final List<Object> arguments = new ArrayList<Object>();
    private Map<String, Object> errorExtensions;
    private final String argumentName;

    public ArgumentValidationUtil(Argument argument) {
        this.argumentName = argument.getName();
        this.argumentValue = argument.getValue();
    }

    @Override
    protected void handleNullError(Value<?> value, GraphQLType type) {
        this.errMsgKey = "ArgumentValidationUtil.handleNullError";
        this.argumentValue = value;
    }

    @Override
    protected void handleScalarError(Value<?> value, GraphQLScalarType type, GraphQLError invalid) {
        this.errMsgKey = invalid.getMessage() == null ? "ArgumentValidationUtil.handleScalarError" : "ArgumentValidationUtil.handleScalarErrorCustomMessage";
        this.arguments.add(type.getName());
        this.arguments.add(invalid.getMessage());
        this.argumentValue = value;
        this.errorExtensions = invalid.getExtensions();
    }

    @Override
    protected void handleEnumError(Value<?> value, GraphQLEnumType type, GraphQLError invalid) {
        this.errMsgKey = invalid.getMessage() == null ? "ArgumentValidationUtil.handleEnumError" : "ArgumentValidationUtil.handleEnumErrorCustomMessage";
        this.arguments.add(type.getName());
        this.arguments.add(invalid.getMessage());
        this.argumentValue = value;
    }

    @Override
    protected void handleNotObjectError(Value<?> value, GraphQLInputObjectType type) {
        this.errMsgKey = "ArgumentValidationUtil.handleNotObjectError";
    }

    @Override
    protected void handleMissingFieldsError(Value<?> value, GraphQLInputObjectType type, Set<String> missingFields) {
        this.errMsgKey = "ArgumentValidationUtil.handleMissingFieldsError";
        this.arguments.add(missingFields);
    }

    @Override
    protected void handleExtraFieldError(Value<?> value, GraphQLInputObjectType type, ObjectField objectField) {
        this.errMsgKey = "ArgumentValidationUtil.handleExtraFieldError";
        this.arguments.add(type.getName());
        this.arguments.add(objectField.getName());
    }

    @Override
    protected void handleFieldNotValidError(ObjectField objectField, GraphQLInputObjectType type) {
        this.argumentNames.add(0, objectField.getName());
    }

    @Override
    protected void handleFieldNotValidError(Value<?> value, GraphQLType type, int index) {
        this.argumentNames.add(0, String.format("[%s]", index));
    }

    @Override
    protected void handleExtraOneOfFieldsError(GraphQLInputObjectType type, Value<?> value) {
        this.errMsgKey = "ArgumentValidationUtil.extraOneOfFieldsError";
        this.arguments.add(type.getName());
    }

    public I18nMsg getMsgAndArgs() {
        StringBuilder argument = new StringBuilder(this.argumentName);
        for (String name : this.argumentNames) {
            if (name.startsWith("[")) {
                argument.append(name);
                continue;
            }
            argument.append(".").append(name);
        }
        this.arguments.add(0, argument.toString());
        this.arguments.add(1, this.argumentValue);
        return new I18nMsg(this.errMsgKey, this.arguments);
    }

    public Map<String, Object> getErrorExtensions() {
        return this.errorExtensions;
    }
}

