/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.dataloader.CacheMap;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DispatchResult;
import org.dataloader.ValueCache;
import org.dataloader.annotations.PublicApi;
import org.dataloader.stats.Statistics;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@PublicApi
@NullMarked
public class DelegatingDataLoader<K, V>
extends DataLoader<K, V> {
    protected final DataLoader<K, V> delegate;

    public static <K, V> DataLoader<K, V> unwrap(DataLoader<K, V> dataLoader) {
        if (dataLoader instanceof DelegatingDataLoader) {
            return ((DelegatingDataLoader)dataLoader).getDelegate();
        }
        return dataLoader;
    }

    public DelegatingDataLoader(DataLoader<K, V> delegate) {
        super(delegate.getName(), delegate.getBatchLoadFunction(), delegate.getOptions());
        this.delegate = delegate;
    }

    public DataLoader<K, V> getDelegate() {
        return this.delegate;
    }

    @Override
    public CompletableFuture<V> load(@NonNull K key, @Nullable Object keyContext) {
        return this.delegate.load(key, keyContext);
    }

    @Override
    public DataLoader<K, V> transform(Consumer<DataLoaderFactory.Builder<K, V>> builderConsumer) {
        return this.delegate.transform(builderConsumer);
    }

    @Override
    public Instant getLastDispatchTime() {
        return this.delegate.getLastDispatchTime();
    }

    @Override
    public Duration getTimeSinceDispatch() {
        return this.delegate.getTimeSinceDispatch();
    }

    @Override
    public Optional<CompletableFuture<V>> getIfPresent(K key) {
        return this.delegate.getIfPresent(key);
    }

    @Override
    public Optional<CompletableFuture<V>> getIfCompleted(K key) {
        return this.delegate.getIfCompleted(key);
    }

    @Override
    public CompletableFuture<List<V>> dispatch() {
        return this.delegate.dispatch();
    }

    @Override
    public DispatchResult<V> dispatchWithCounts() {
        return this.delegate.dispatchWithCounts();
    }

    @Override
    public List<V> dispatchAndJoin() {
        return this.delegate.dispatchAndJoin();
    }

    @Override
    public int dispatchDepth() {
        return this.delegate.dispatchDepth();
    }

    @Override
    public Object getCacheKey(K key) {
        return this.delegate.getCacheKey(key);
    }

    @Override
    public Statistics getStatistics() {
        return this.delegate.getStatistics();
    }

    @Override
    public CacheMap<Object, V> getCacheMap() {
        return this.delegate.getCacheMap();
    }

    @Override
    public ValueCache<K, V> getValueCache() {
        return this.delegate.getValueCache();
    }

    @Override
    public DataLoader<K, V> clear(K key) {
        this.delegate.clear(key);
        return this;
    }

    @Override
    public DataLoader<K, V> clear(K key, BiConsumer<Void, Throwable> handler) {
        this.delegate.clear(key, handler);
        return this;
    }

    @Override
    public DataLoader<K, V> clearAll() {
        this.delegate.clearAll();
        return this;
    }

    @Override
    public DataLoader<K, V> clearAll(BiConsumer<Void, Throwable> handler) {
        this.delegate.clearAll(handler);
        return this;
    }

    @Override
    public DataLoader<K, V> prime(K key, V value) {
        this.delegate.prime(key, value);
        return this;
    }

    @Override
    public DataLoader<K, V> prime(K key, Exception error) {
        this.delegate.prime(key, error);
        return this;
    }

    @Override
    public DataLoader<K, V> prime(K key, CompletableFuture<V> value) {
        this.delegate.prime(key, value);
        return this;
    }
}

