/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import com.google.common.collect.ImmutableMap;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class NewNodeSession
implements HttpHandler {
    private final Node node;
    private final Json json;

    NewNodeSession(Node node, Json json) {
        this.node = Require.nonNull("Node", node);
        this.json = Require.nonNull("Json converter", json);
    }

    @Override
    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        CreateSessionRequest incoming = (CreateSessionRequest)this.json.toType(Contents.string(req), (Type)((Object)CreateSessionRequest.class));
        Either<WebDriverException, CreateSessionResponse> result = this.node.newSession(incoming);
        HashMap value = new HashMap();
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (result.isRight()) {
            response.put("sessionResponse", result.right());
        } else {
            WebDriverException exception = result.left();
            response.put("exception", ImmutableMap.of("error", exception.getClass(), "message", exception.getMessage()));
        }
        value.put("value", response);
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson(value));
    }
}

