/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.http.HttpResponse;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClientName;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;

public interface HttpClient
extends Closeable,
HttpHandler {
    public WebSocket openSocket(HttpRequest var1, WebSocket.Listener var2);

    default public CompletableFuture<HttpResponse> executeAsync(HttpRequest req) {
        return CompletableFuture.supplyAsync(() -> this.execute(req));
    }

    @Override
    default public void close() {
    }

    public <T> CompletableFuture<java.net.http.HttpResponse<T>> sendAsyncNative(java.net.http.HttpRequest var1, HttpResponse.BodyHandler<T> var2);

    public <T> java.net.http.HttpResponse<T> sendNative(java.net.http.HttpRequest var1, HttpResponse.BodyHandler<T> var2) throws IOException, InterruptedException;

    public static interface Factory {
        public static Factory create(String name) {
            ServiceLoader<Factory> loader = ServiceLoader.load(Factory.class, Factory.class.getClassLoader());
            Set factories = StreamSupport.stream(loader.spliterator(), true).filter(p -> p.getClass().isAnnotationPresent(HttpClientName.class)).filter(p -> name.equals(p.getClass().getAnnotation(HttpClientName.class).value())).collect(Collectors.toSet());
            if (factories.isEmpty()) {
                throw new IllegalArgumentException("Unknown HttpClient factory " + name);
            }
            if (factories.size() > 1) {
                throw new IllegalStateException(String.format("There are multiple HttpClient factories by name %s, check your classpath", name));
            }
            return (Factory)factories.iterator().next();
        }

        public static Factory createDefault() {
            return Factory.create(System.getProperty("webdriver.http.factory", "jdk-http-client"));
        }

        default public HttpClient createClient(URL url) {
            Require.nonNull("URL to use as base URL", url);
            return this.createClient(ClientConfig.defaultConfig().baseUrl(url));
        }

        public HttpClient createClient(ClientConfig var1);

        default public void cleanupIdleClients() {
        }
    }
}

