/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.decorators;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatchers;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.support.decorators.Decorated;
import org.openqa.selenium.support.decorators.DefaultDecorated;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticator;

@Beta
public class WebDriverDecorator<T extends WebDriver> {
    private final ConcurrentMap<Definition, ProxyFactory<?>> cache;
    private final Class<T> targetWebDriverClass;
    private Decorated<T> decorated;

    public WebDriverDecorator() {
        this(WebDriver.class);
    }

    public WebDriverDecorator(Class<T> targetClass) {
        this.targetWebDriverClass = targetClass;
        this.cache = new ConcurrentHashMap();
    }

    public final T decorate(T original) {
        Require.nonNull("WebDriver", original);
        this.decorated = this.createDecorated(original);
        return (T)((WebDriver)this.createProxy(this.decorated, this.targetWebDriverClass));
    }

    public Decorated<T> getDecoratedDriver() {
        return this.decorated;
    }

    public Decorated<T> createDecorated(T driver) {
        return new DefaultDecorated<T>(driver, this);
    }

    public Decorated<WebElement> createDecorated(WebElement original) {
        return new DefaultDecorated<WebElement>(original, this);
    }

    public Decorated<WebDriver.TargetLocator> createDecorated(WebDriver.TargetLocator original) {
        return new DefaultDecorated<WebDriver.TargetLocator>(original, this);
    }

    public Decorated<WebDriver.Navigation> createDecorated(WebDriver.Navigation original) {
        return new DefaultDecorated<WebDriver.Navigation>(original, this);
    }

    public Decorated<WebDriver.Options> createDecorated(WebDriver.Options original) {
        return new DefaultDecorated<WebDriver.Options>(original, this);
    }

    public Decorated<WebDriver.Timeouts> createDecorated(WebDriver.Timeouts original) {
        return new DefaultDecorated<WebDriver.Timeouts>(original, this);
    }

    public Decorated<WebDriver.Window> createDecorated(WebDriver.Window original) {
        return new DefaultDecorated<WebDriver.Window>(original, this);
    }

    public Decorated<Alert> createDecorated(Alert original) {
        return new DefaultDecorated<Alert>(original, this);
    }

    public Decorated<VirtualAuthenticator> createDecorated(VirtualAuthenticator original) {
        return new DefaultDecorated<VirtualAuthenticator>(original, this);
    }

    public void beforeCall(Decorated<?> target, Method method, Object[] args) {
    }

    public Object call(Decorated<?> target, Method method, Object[] args) throws Throwable {
        return this.decorateResult(method.invoke(target.getOriginal(), args));
    }

    public void afterCall(Decorated<?> target, Method method, Object[] args, Object res) {
    }

    public Object onError(Decorated<?> target, Method method, Object[] args, InvocationTargetException e) throws Throwable {
        throw e.getTargetException();
    }

    private Object decorateResult(Object toDecorate) {
        if (toDecorate instanceof WebDriver) {
            return this.createProxy(this.getDecoratedDriver(), this.targetWebDriverClass);
        }
        if (toDecorate instanceof WebElement) {
            return this.createProxy(this.createDecorated((WebElement)toDecorate), WebElement.class);
        }
        if (toDecorate instanceof Alert) {
            return this.createProxy(this.createDecorated((Alert)toDecorate), Alert.class);
        }
        if (toDecorate instanceof VirtualAuthenticator) {
            return this.createProxy(this.createDecorated((VirtualAuthenticator)toDecorate), VirtualAuthenticator.class);
        }
        if (toDecorate instanceof WebDriver.Navigation) {
            return this.createProxy(this.createDecorated((WebDriver.Navigation)toDecorate), WebDriver.Navigation.class);
        }
        if (toDecorate instanceof WebDriver.Options) {
            return this.createProxy(this.createDecorated((WebDriver.Options)toDecorate), WebDriver.Options.class);
        }
        if (toDecorate instanceof WebDriver.TargetLocator) {
            return this.createProxy(this.createDecorated((WebDriver.TargetLocator)toDecorate), WebDriver.TargetLocator.class);
        }
        if (toDecorate instanceof WebDriver.Timeouts) {
            return this.createProxy(this.createDecorated((WebDriver.Timeouts)toDecorate), WebDriver.Timeouts.class);
        }
        if (toDecorate instanceof WebDriver.Window) {
            return this.createProxy(this.createDecorated((WebDriver.Window)toDecorate), WebDriver.Window.class);
        }
        if (toDecorate instanceof List) {
            return ((List)toDecorate).stream().map(this::decorateResult).collect(Collectors.toList());
        }
        return toDecorate;
    }

    protected final <Z> Z createProxy(Decorated<Z> decorated, Class<? extends Z> clazz) {
        ProxyFactory factory = this.cache.computeIfAbsent(new Definition(decorated), key -> this.createProxyFactory((Definition)key, decorated, clazz));
        return factory.newInstance(decorated);
    }

    protected final <Z> ProxyFactory<? extends Z> createProxyFactory(Definition definition, Decorated<Z> sample, Class<? extends Z> clazz) {
        Set<Class<?>> decoratedInterfaces = WebDriverDecorator.extractInterfaces(definition.decoratedClass);
        Set<Class<?>> originalInterfaces = WebDriverDecorator.extractInterfaces(definition.originalClass);
        Map derivedInterfaces = this.deriveAdditionalInterfaces(sample.getOriginal());
        InvocationHandler handler = (proxy, method, args) -> {
            Decorated instance = ((HasTarget)proxy).getTarget();
            if (instance == null) {
                throw new AssertionError((Object)"Failed to get instance to call");
            }
            try {
                if (method.getDeclaringClass().equals(Object.class) || decoratedInterfaces.contains(method.getDeclaringClass())) {
                    return method.invoke(instance, args);
                }
                boolean isCompatible = originalInterfaces.stream().anyMatch(eachInterface -> eachInterface.isAssignableFrom(method.getDeclaringClass()));
                if (isCompatible) {
                    instance.beforeCall(method, args);
                    Object result = instance.call(method, args);
                    instance.afterCall(method, result, args);
                    return result;
                }
                isCompatible = derivedInterfaces.keySet().stream().anyMatch(eachInterface -> eachInterface.isAssignableFrom(method.getDeclaringClass()));
                if (isCompatible) {
                    return ((InvocationHandler)((Function)derivedInterfaces.get(method.getDeclaringClass())).apply(instance.getOriginal())).invoke(proxy, method, args);
                }
                return method.invoke(instance.getOriginal(), args);
            }
            catch (InvocationTargetException e) {
                return instance.onError(method, e, args);
            }
        };
        HashSet allInterfaces = new HashSet();
        allInterfaces.addAll(decoratedInterfaces);
        allInterfaces.addAll(originalInterfaces);
        allInterfaces.addAll(derivedInterfaces.keySet());
        allInterfaces.remove(HasTarget.class);
        Type[] allInterfacesArray = allInterfaces.toArray(new Class[0]);
        Class<? extends Z> proxy2 = new ByteBuddy().subclass((Type)((Object)(clazz.isInterface() ? Object.class : clazz))).implement(allInterfacesArray).method(ElementMatchers.any()).intercept(InvocationHandlerAdapter.of(handler)).defineField("target", (Type)((Object)Decorated.class), Visibility.PRIVATE).implement(new Type[]{HasTarget.class}).intercept(FieldAccessor.ofField("target")).make().load(clazz.getClassLoader(), ClassLoadingStrategy.Default.WRAPPER).getLoaded().asSubclass(clazz);
        return new ProxyFactory<Z>(proxy2);
    }

    private static Set<Class<?>> extractInterfaces(Class<?> clazz) {
        HashSet allInterfaces = new HashSet();
        WebDriverDecorator.extractInterfaces(allInterfaces, clazz);
        return allInterfaces;
    }

    private static void extractInterfaces(Set<Class<?>> collector, Class<?> clazz) {
        Class<?>[] classes;
        if (clazz == null || Object.class.equals(clazz)) {
            return;
        }
        for (Class<?> interfaceClass : classes = clazz.getInterfaces()) {
            collector.add(interfaceClass);
            for (Class<?> superInterface : interfaceClass.getInterfaces()) {
                collector.add(superInterface);
                WebDriverDecorator.extractInterfaces(collector, superInterface);
            }
        }
        WebDriverDecorator.extractInterfaces(collector, clazz.getSuperclass());
    }

    private <Z> Map<Class<?>, Function<Z, InvocationHandler>> deriveAdditionalInterfaces(Z sample) {
        HashMap handlers = new HashMap();
        if (sample instanceof WebDriver && !(sample instanceof WrapsDriver)) {
            handlers.put(WrapsDriver.class, instance -> (proxy, method, args) -> {
                if ("getWrappedDriver".equals(method.getName())) {
                    return instance;
                }
                throw new UnsupportedOperationException(method.getName());
            });
        }
        if (sample instanceof WebElement && !(sample instanceof WrapsElement)) {
            handlers.put(WrapsElement.class, instance -> (proxy, method, args) -> {
                if ("getWrappedElement".equals(method.getName())) {
                    return instance;
                }
                throw new UnsupportedOperationException(method.getName());
            });
        }
        try {
            Method toJson = sample.getClass().getDeclaredMethod("toJson", new Class[0]);
            toJson.setAccessible(true);
            handlers.put(JsonSerializer.class, instance -> (proxy, method, args) -> {
                if ("toJson".equals(method.getName())) {
                    return toJson.invoke(instance, new Object[0]);
                }
                throw new UnsupportedOperationException(method.getName());
            });
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return handlers;
    }

    protected static class Definition {
        private final Class<?> decoratedClass;
        private final Class<?> originalClass;

        public Definition(Decorated<?> decorated) {
            this.decoratedClass = decorated.getClass();
            this.originalClass = decorated.getOriginal().getClass();
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Definition definition = (Definition)o;
            return this.decoratedClass == definition.decoratedClass && this.originalClass == definition.originalClass;
        }

        public int hashCode() {
            return Arrays.hashCode(new int[]{System.identityHashCode(this.decoratedClass), System.identityHashCode(this.originalClass)});
        }
    }

    protected static class ProxyFactory<T> {
        private final Class<? extends T> clazz;

        private ProxyFactory(Class<? extends T> clazz) {
            this.clazz = clazz;
        }

        public T newInstance(Decorated<T> target) {
            T instance;
            try {
                instance = this.clazz.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError("Unable to create new proxy", e);
            }
            ((HasTarget)instance).setTarget(target);
            return instance;
        }
    }

    public static interface HasTarget<Z> {
        public Decorated<Z> getTarget();

        public void setTarget(Decorated<Z> var1);
    }

    @FunctionalInterface
    protected static interface JsonSerializer {
        public Object toJson();
    }
}

