/*
 * Decompiled with CFR 0.152.
 */
package zmq.io;

import java.util.HashSet;
import java.util.Set;
import zmq.Ctx;
import zmq.Msg;
import zmq.Options;
import zmq.Own;
import zmq.SocketBase;
import zmq.ZObject;
import zmq.io.IEngine;
import zmq.io.IOObject;
import zmq.io.IOThread;
import zmq.io.StreamEngine;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.Address;
import zmq.io.net.NetProtocol;
import zmq.io.net.ipc.IpcConnecter;
import zmq.io.net.norm.NormEngine;
import zmq.io.net.pgm.PgmReceiver;
import zmq.io.net.pgm.PgmSender;
import zmq.io.net.tcp.SocksConnecter;
import zmq.io.net.tcp.TcpConnecter;
import zmq.io.net.tipc.TipcConnecter;
import zmq.pipe.Pipe;
import zmq.poll.IPollEvents;

public class SessionBase
extends Own
implements Pipe.IPipeEvents,
IPollEvents {
    private final boolean active;
    private Pipe pipe;
    private Pipe zapPipe;
    private final Set<Pipe> terminatingPipes;
    private boolean incompleteIn;
    private boolean pending;
    private IEngine engine;
    protected final SocketBase socket;
    private final IOThread ioThread;
    private static final int LINGER_TIMER_ID = 32;
    private boolean hasLingerTimer;
    private final Address addr;
    private final IOObject ioObject;

    public SessionBase(IOThread ioThread, boolean connect, SocketBase socket, Options options, Address addr) {
        super(ioThread, options);
        this.ioObject = new IOObject(ioThread, this);
        this.active = connect;
        this.pipe = null;
        this.zapPipe = null;
        this.incompleteIn = false;
        this.pending = false;
        this.engine = null;
        this.socket = socket;
        this.ioThread = ioThread;
        this.hasLingerTimer = false;
        this.addr = addr;
        this.terminatingPipes = new HashSet<Pipe>();
    }

    @Override
    public void destroy() {
        assert (this.pipe == null);
        assert (this.zapPipe == null);
        if (this.hasLingerTimer) {
            this.ioObject.cancelTimer(32);
            this.hasLingerTimer = false;
        }
        if (this.engine != null) {
            this.engine.terminate();
        }
        this.ioObject.unplug();
    }

    public void attachPipe(Pipe pipe) {
        assert (!this.isTerminating());
        assert (this.pipe == null);
        assert (pipe != null);
        this.pipe = pipe;
        this.pipe.setEventSink(this);
    }

    protected Msg pullMsg() {
        if (this.pipe == null) {
            return null;
        }
        Msg msg = this.pipe.read();
        if (msg == null) {
            return null;
        }
        this.incompleteIn = msg.hasMore();
        return msg;
    }

    protected boolean pushMsg(Msg msg) {
        if (msg.isCommand()) {
            return true;
        }
        if (this.pipe != null && this.pipe.write(msg)) {
            return true;
        }
        this.errno.set(35);
        return false;
    }

    public Msg readZapMsg() {
        if (this.zapPipe == null) {
            this.errno.set(57);
            return null;
        }
        Msg msg = this.zapPipe.read();
        if (msg == null) {
            this.errno.set(35);
        }
        return msg;
    }

    public boolean writeZapMsg(Msg msg) {
        if (this.zapPipe == null) {
            this.errno.set(57);
            return false;
        }
        boolean rc = this.zapPipe.write(msg);
        assert (rc);
        if (!msg.hasMore()) {
            this.zapPipe.flush();
        }
        return true;
    }

    protected void reset() {
    }

    public void flush() {
        if (this.pipe != null) {
            this.pipe.flush();
        }
    }

    private void cleanPipes() {
        assert (this.pipe != null);
        this.pipe.rollback();
        this.pipe.flush();
        while (this.incompleteIn) {
            Msg msg = this.pullMsg();
            if (msg != null) continue;
            assert (!this.incompleteIn);
            break;
        }
    }

    @Override
    public void pipeTerminated(Pipe pipe) {
        assert (this.pipe == pipe || this.zapPipe == pipe || this.terminatingPipes.contains(pipe));
        if (this.pipe == pipe) {
            this.pipe = null;
            if (this.hasLingerTimer) {
                this.ioObject.cancelTimer(32);
                this.hasLingerTimer = false;
            }
        } else if (this.zapPipe == pipe) {
            this.zapPipe = null;
        } else {
            this.terminatingPipes.remove(pipe);
        }
        if (!this.isTerminating() && this.options.rawSocket && this.engine != null) {
            this.engine.terminate();
            this.engine = null;
        }
        if (this.pending && this.pipe == null && this.zapPipe == null && this.terminatingPipes.isEmpty()) {
            this.pending = false;
            super.processTerm(0);
        }
    }

    @Override
    public void readActivated(Pipe pipe) {
        if (this.pipe != pipe && this.zapPipe != pipe) {
            assert (this.terminatingPipes.contains(pipe));
            return;
        }
        if (this.engine == null) {
            this.pipe.checkRead();
            return;
        }
        if (this.pipe == pipe) {
            this.engine.restartOutput();
        } else {
            this.engine.zapMsgAvailable();
        }
    }

    @Override
    public void writeActivated(Pipe pipe) {
        if (this.pipe != pipe) {
            assert (this.terminatingPipes.contains(pipe));
            return;
        }
        if (this.engine != null) {
            this.engine.restartInput();
        }
    }

    @Override
    public void hiccuped(Pipe pipe) {
        throw new UnsupportedOperationException("Must Override");
    }

    public SocketBase getSocket() {
        return this.socket;
    }

    @Override
    protected void processPlug() {
        this.ioObject.plug();
        if (this.active) {
            this.startConnecting(false);
        }
    }

    public int zapConnect() {
        if (this.zapPipe == null) {
            Ctx.Endpoint peer = this.findEndpoint("inproc://zeromq.zap.01");
            if (peer.socket == null) {
                this.errno.set(61);
                return 61;
            }
            if (peer.options.type != 4 && peer.options.type != 6 && peer.options.type != 12) {
                this.errno.set(61);
                return 61;
            }
            ZObject[] parents = new ZObject[]{this, peer.socket};
            int[] hwms = new int[]{0, 0};
            boolean[] conflates = new boolean[]{false, false};
            Pipe[] pipes = Pipe.pair(parents, hwms, conflates);
            this.zapPipe = pipes[0];
            this.zapPipe.setNoDelay();
            this.zapPipe.setEventSink(this);
            this.sendBind(peer.socket, pipes[1], false);
            if (peer.options.recvIdentity) {
                Msg id = new Msg();
                id.setFlags(64);
                this.zapPipe.write(id);
                this.zapPipe.flush();
            }
        }
        return 0;
    }

    protected boolean zapEnabled() {
        return this.options.mechanism != Mechanisms.NULL || this.options.zapDomain != null && !this.options.zapDomain.isEmpty();
    }

    @Override
    protected void processAttach(IEngine engine) {
        assert (engine != null);
        if (this.pipe == null && !this.isTerminating()) {
            ZObject[] parents = new ZObject[]{this, this.socket};
            boolean conflate = this.options.conflate && (this.options.type == 5 || this.options.type == 7 || this.options.type == 8 || this.options.type == 1 || this.options.type == 2);
            int[] hwms = new int[]{conflate ? -1 : this.options.recvHwm, conflate ? -1 : this.options.sendHwm};
            boolean[] conflates = new boolean[]{conflate, conflate};
            Pipe[] pipes = Pipe.pair(parents, hwms, conflates);
            pipes[0].setEventSink(this);
            assert (this.pipe == null);
            this.pipe = pipes[0];
            this.sendBind(this.socket, pipes[1]);
        }
        assert (this.engine == null);
        this.engine = engine;
        this.engine.plug(this.ioThread, this);
    }

    public void engineError(boolean handshaked, StreamEngine.ErrorReason reason) {
        this.engine = null;
        if (this.pipe != null) {
            this.cleanPipes();
            if (!this.active && handshaked && this.options.canReceiveDisconnectMsg && this.options.disconnectMsg != null) {
                this.pipe.setDisconnectMsg(this.options.disconnectMsg);
                this.pipe.sendDisconnectMsg();
            }
            if (this.active && handshaked && this.options.canReceiveHiccupMsg && this.options.hiccupMsg != null) {
                this.pipe.sendHiccupMsg(this.options.hiccupMsg);
            }
        }
        assert (reason == StreamEngine.ErrorReason.CONNECTION || reason == StreamEngine.ErrorReason.TIMEOUT || reason == StreamEngine.ErrorReason.PROTOCOL);
        switch (reason) {
            case TIMEOUT: 
            case CONNECTION: {
                if (this.active) {
                    this.reconnect();
                    break;
                }
                this.terminate();
                break;
            }
            case PROTOCOL: {
                this.terminate();
                break;
            }
        }
        if (this.pipe != null) {
            this.pipe.checkRead();
        }
        if (this.zapPipe != null) {
            this.zapPipe.checkRead();
        }
    }

    @Override
    protected void processTerm(int linger) {
        assert (!this.pending);
        if (this.pipe == null && this.zapPipe == null && this.terminatingPipes.isEmpty()) {
            super.processTerm(0);
            return;
        }
        this.pending = true;
        if (this.pipe != null) {
            if (linger > 0) {
                assert (!this.hasLingerTimer);
                this.ioObject.addTimer(linger, 32);
                this.hasLingerTimer = true;
            }
            this.pipe.terminate(linger != 0);
            if (this.engine == null) {
                this.pipe.checkRead();
            }
        }
        if (this.zapPipe != null) {
            this.zapPipe.terminate(false);
        }
    }

    @Override
    public void timerEvent(int id) {
        assert (id == 32);
        this.hasLingerTimer = false;
        assert (this.pipe != null);
        this.pipe.terminate(false);
    }

    private void reconnect() {
        if (this.pipe != null && !this.options.immediate && !this.addr.protocol().isMulticast) {
            this.pipe.hiccup();
            this.pipe.terminate(false);
            this.terminatingPipes.add(this.pipe);
            this.pipe = null;
        }
        this.reset();
        if (this.options.reconnectIvl != -1) {
            this.startConnecting(true);
        }
        if (this.pipe != null && (this.options.type == 2 || this.options.type == 10)) {
            this.pipe.hiccup();
        }
    }

    private void startConnecting(boolean wait) {
        assert (this.active);
        IOThread ioThread = this.chooseIoThread(this.options.affinity);
        assert (ioThread != null);
        NetProtocol protocol = this.addr.protocol();
        if (protocol == null) {
            this.errno.set(43);
            return;
        }
        switch (protocol) {
            case tcp: {
                if (this.options.socksProxyAddress != null) {
                    Address proxyAddress = new Address(NetProtocol.tcp, this.options.socksProxyAddress);
                    SocksConnecter connecter = new SocksConnecter(ioThread, this, this.options, this.addr, proxyAddress, wait);
                    this.launchChild(connecter);
                    break;
                }
                TcpConnecter connecter = new TcpConnecter(ioThread, this, this.options, this.addr, wait);
                this.launchChild(connecter);
                break;
            }
            case ipc: {
                IpcConnecter connecter = new IpcConnecter(ioThread, this, this.options, this.addr, wait);
                this.launchChild(connecter);
                break;
            }
            case tipc: {
                TipcConnecter connecter = new TipcConnecter(ioThread, this, this.options, this.addr, wait);
                this.launchChild(connecter);
                break;
            }
            case pgm: 
            case epgm: {
                boolean udpEncapsulation;
                assert (this.options.type == 1 || this.options.type == 9 || this.options.type == 2 || this.options.type == 10);
                boolean bl = udpEncapsulation = protocol == NetProtocol.epgm;
                if (this.options.type == 1 || this.options.type == 9) {
                    PgmSender pgmSender = new PgmSender(ioThread, this.options);
                    boolean rc = pgmSender.init(udpEncapsulation, this.addr);
                    assert (rc);
                    this.sendAttach(this, pgmSender);
                    break;
                }
                PgmReceiver pgmReceiver = new PgmReceiver(ioThread, this.options);
                boolean rc = pgmReceiver.init(udpEncapsulation, this.addr);
                assert (rc);
                this.sendAttach(this, pgmReceiver);
                break;
            }
            case norm: {
                if (this.options.type == 1 || this.options.type == 9) {
                    NormEngine normSender = new NormEngine(ioThread, this.options);
                    boolean rc = normSender.init(this.addr, true, false);
                    assert (rc);
                    this.sendAttach(this, normSender);
                    break;
                }
                NormEngine normReceiver = new NormEngine(ioThread, this.options);
                boolean rc = normReceiver.init(this.addr, false, true);
                assert (rc);
                this.sendAttach(this, normReceiver);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public String getEndpoint() {
        return this.engine.getEndPoint();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + this.socket;
    }

    @Override
    public final void incSeqnum() {
        super.incSeqnum();
    }
}

