/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.input.ProxyReader;
import org.junit.jupiter.api.Test;

class ProxyReaderTest {
    ProxyReaderTest() {
    }

    @Test
    void testNullCharArray() throws Exception {
        try (ProxyReaderImpl proxy = new ProxyReaderImpl((Reader)((Object)new CustomNullReader(0)));){
            proxy.read(null);
            proxy.read(null, 0, 0);
        }
    }

    @Test
    void testNullCharBuffer() throws Exception {
        try (ProxyReaderImpl proxy = new ProxyReaderImpl((Reader)((Object)new CustomNullReader(0)));){
            proxy.read(null);
        }
    }

    private static final class ProxyReaderImpl
    extends ProxyReader {
        ProxyReaderImpl(Reader proxy) {
            super(proxy);
        }
    }

    private static final class CustomNullReader
    extends NullReader {
        CustomNullReader(int len) {
            super((long)len);
        }

        public int read(char[] chars) throws IOException {
            return chars == null ? 0 : super.read(chars);
        }

        public int read(CharBuffer target) throws IOException {
            return target == null ? 0 : super.read(target);
        }
    }
}

