/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.dnn.Net;
import org.opencv.utils.Converters;

public class Model {
    protected final long nativeObj;

    protected Model(long addr) {
        this.nativeObj = addr;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Model __fromPtr__(long addr) {
        return new Model(addr);
    }

    public Model(String model, String config) {
        this.nativeObj = Model.Model_0(model, config);
    }

    public Model(String model) {
        this.nativeObj = Model.Model_1(model);
    }

    public Model(Net network) {
        this.nativeObj = Model.Model_2(network.nativeObj);
    }

    public Model setInputSize(Size size) {
        return new Model(Model.setInputSize_0(this.nativeObj, size.width, size.height));
    }

    public Model setInputSize(int width, int height) {
        return new Model(Model.setInputSize_1(this.nativeObj, width, height));
    }

    public Model setInputMean(Scalar mean) {
        return new Model(Model.setInputMean_0(this.nativeObj, mean.val[0], mean.val[1], mean.val[2], mean.val[3]));
    }

    public Model setInputScale(Scalar scale) {
        return new Model(Model.setInputScale_0(this.nativeObj, scale.val[0], scale.val[1], scale.val[2], scale.val[3]));
    }

    public Model setInputCrop(boolean crop) {
        return new Model(Model.setInputCrop_0(this.nativeObj, crop));
    }

    public Model setInputSwapRB(boolean swapRB) {
        return new Model(Model.setInputSwapRB_0(this.nativeObj, swapRB));
    }

    public Model setOutputNames(List<String> outNames) {
        return new Model(Model.setOutputNames_0(this.nativeObj, outNames));
    }

    public void setInputParams(double scale, Size size, Scalar mean, boolean swapRB, boolean crop) {
        Model.setInputParams_0(this.nativeObj, scale, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB, crop);
    }

    public void setInputParams(double scale, Size size, Scalar mean, boolean swapRB) {
        Model.setInputParams_1(this.nativeObj, scale, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3], swapRB);
    }

    public void setInputParams(double scale, Size size, Scalar mean) {
        Model.setInputParams_2(this.nativeObj, scale, size.width, size.height, mean.val[0], mean.val[1], mean.val[2], mean.val[3]);
    }

    public void setInputParams(double scale, Size size) {
        Model.setInputParams_3(this.nativeObj, scale, size.width, size.height);
    }

    public void setInputParams(double scale) {
        Model.setInputParams_4(this.nativeObj, scale);
    }

    public void setInputParams() {
        Model.setInputParams_5(this.nativeObj);
    }

    public void predict(Mat frame, List<Mat> outs) {
        Mat outs_mat = new Mat();
        Model.predict_0(this.nativeObj, frame.nativeObj, outs_mat.nativeObj);
        Converters.Mat_to_vector_Mat(outs_mat, outs);
        outs_mat.release();
    }

    public Model setPreferableBackend(int backendId) {
        return new Model(Model.setPreferableBackend_0(this.nativeObj, backendId));
    }

    public Model setPreferableTarget(int targetId) {
        return new Model(Model.setPreferableTarget_0(this.nativeObj, targetId));
    }

    public Model enableWinograd(boolean useWinograd) {
        return new Model(Model.enableWinograd_0(this.nativeObj, useWinograd));
    }

    protected void finalize() throws Throwable {
        Model.delete(this.nativeObj);
    }

    private static native long Model_0(String var0, String var1);

    private static native long Model_1(String var0);

    private static native long Model_2(long var0);

    private static native long setInputSize_0(long var0, double var2, double var4);

    private static native long setInputSize_1(long var0, int var2, int var3);

    private static native long setInputMean_0(long var0, double var2, double var4, double var6, double var8);

    private static native long setInputScale_0(long var0, double var2, double var4, double var6, double var8);

    private static native long setInputCrop_0(long var0, boolean var2);

    private static native long setInputSwapRB_0(long var0, boolean var2);

    private static native long setOutputNames_0(long var0, List<String> var2);

    private static native void setInputParams_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17);

    private static native void setInputParams_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16);

    private static native void setInputParams_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native void setInputParams_3(long var0, double var2, double var4, double var6);

    private static native void setInputParams_4(long var0, double var2);

    private static native void setInputParams_5(long var0);

    private static native void predict_0(long var0, long var2, long var4);

    private static native long setPreferableBackend_0(long var0, int var2);

    private static native long setPreferableTarget_0(long var0, int var2);

    private static native long enableWinograd_0(long var0, boolean var2);

    private static native void delete(long var0);
}

