package org.openqa.selenium.devtools.v141.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Stores the byte data of the advertisement packet sent by a Bluetooth device.
 */
public class ScanRecord {

    private final java.util.Optional<java.lang.String> name;

    private final java.util.Optional<java.util.List<java.lang.String>> uuids;

    private final java.util.Optional<java.lang.Integer> appearance;

    private final java.util.Optional<java.lang.Integer> txPower;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v141.bluetoothemulation.model.ManufacturerData>> manufacturerData;

    public ScanRecord(java.util.Optional<java.lang.String> name, java.util.Optional<java.util.List<java.lang.String>> uuids, java.util.Optional<java.lang.Integer> appearance, java.util.Optional<java.lang.Integer> txPower, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v141.bluetoothemulation.model.ManufacturerData>> manufacturerData) {
        this.name = name;
        this.uuids = uuids;
        this.appearance = appearance;
        this.txPower = txPower;
        this.manufacturerData = manufacturerData;
    }

    public java.util.Optional<java.lang.String> getName() {
        return name;
    }

    public java.util.Optional<java.util.List<java.lang.String>> getUuids() {
        return uuids;
    }

    /**
     * Stores the external appearance description of the device.
     */
    public java.util.Optional<java.lang.Integer> getAppearance() {
        return appearance;
    }

    /**
     * Stores the transmission power of a broadcasting device.
     */
    public java.util.Optional<java.lang.Integer> getTxPower() {
        return txPower;
    }

    /**
     * Key is the company identifier and the value is an array of bytes of
     * manufacturer specific data.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v141.bluetoothemulation.model.ManufacturerData>> getManufacturerData() {
        return manufacturerData;
    }

    private static ScanRecord fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> name = java.util.Optional.empty();
        java.util.Optional<java.util.List<java.lang.String>> uuids = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> appearance = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> txPower = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v141.bluetoothemulation.model.ManufacturerData>> manufacturerData = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "uuids":
                    uuids = java.util.Optional.ofNullable(input.readArray(java.lang.String.class));
                    break;
                case "appearance":
                    appearance = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "txPower":
                    txPower = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "manufacturerData":
                    manufacturerData = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v141.bluetoothemulation.model.ManufacturerData.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ScanRecord(name, uuids, appearance, txPower, manufacturerData);
    }
}
