package org.openqa.selenium.devtools.v141.css.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class ComputedStyleExtraFields {

    private final java.lang.Boolean isAppearanceBase;

    public ComputedStyleExtraFields(java.lang.Boolean isAppearanceBase) {
        this.isAppearanceBase = java.util.Objects.requireNonNull(isAppearanceBase, "isAppearanceBase is required");
    }

    /**
     * Returns whether or not this node is being rendered with base appearance,
     * which happens when it has its appearance property set to base/base-select
     * or it is in the subtree of an element being rendered with base appearance.
     */
    public java.lang.Boolean getIsAppearanceBase() {
        return isAppearanceBase;
    }

    private static ComputedStyleExtraFields fromJson(JsonInput input) {
        java.lang.Boolean isAppearanceBase = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "isAppearanceBase":
                    isAppearanceBase = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ComputedStyleExtraFields(isAppearanceBase);
    }
}
