package org.openqa.selenium.devtools.v141.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration data for the highlighting of Flex item elements.
 */
public class FlexItemHighlightConfig {

    private final java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.BoxStyle> baseSizeBox;

    private final java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.LineStyle> baseSizeBorder;

    private final java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.LineStyle> flexibilityArrow;

    public FlexItemHighlightConfig(java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.BoxStyle> baseSizeBox, java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.LineStyle> baseSizeBorder, java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.LineStyle> flexibilityArrow) {
        this.baseSizeBox = baseSizeBox;
        this.baseSizeBorder = baseSizeBorder;
        this.flexibilityArrow = flexibilityArrow;
    }

    /**
     * Style of the box representing the item's base size
     */
    public java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.BoxStyle> getBaseSizeBox() {
        return baseSizeBox;
    }

    /**
     * Style of the border around the box representing the item's base size
     */
    public java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.LineStyle> getBaseSizeBorder() {
        return baseSizeBorder;
    }

    /**
     * Style of the arrow representing if the item grew or shrank
     */
    public java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.LineStyle> getFlexibilityArrow() {
        return flexibilityArrow;
    }

    private static FlexItemHighlightConfig fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.BoxStyle> baseSizeBox = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.LineStyle> baseSizeBorder = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v141.overlay.model.LineStyle> flexibilityArrow = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "baseSizeBox":
                    baseSizeBox = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v141.overlay.model.BoxStyle.class));
                    break;
                case "baseSizeBorder":
                    baseSizeBorder = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v141.overlay.model.LineStyle.class));
                    break;
                case "flexibilityArrow":
                    flexibilityArrow = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v141.overlay.model.LineStyle.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FlexItemHighlightConfig(baseSizeBox, baseSizeBorder, flexibilityArrow);
    }
}
