package org.openqa.selenium.devtools.v139.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Indicates the various types of characteristic operation.
 */
public enum CharacteristicOperationType {

    READ("read"), WRITE("write"), SUBSCRIBE_TO_NOTIFICATIONS("subscribe-to-notifications"), UNSUBSCRIBE_FROM_NOTIFICATIONS("unsubscribe-from-notifications");

    private String value;

    CharacteristicOperationType(String value) {
        this.value = value;
    }

    public static CharacteristicOperationType fromString(String s) {
        return java.util.Arrays.stream(CharacteristicOperationType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CharacteristicOperationType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CharacteristicOperationType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
