package org.openqa.selenium.devtools.v140.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum PropertyRuleIssueReason {

    INVALIDSYNTAX("InvalidSyntax"), INVALIDINITIALVALUE("InvalidInitialValue"), INVALIDINHERITS("InvalidInherits"), INVALIDNAME("InvalidName");

    private String value;

    PropertyRuleIssueReason(String value) {
        this.value = value;
    }

    public static PropertyRuleIssueReason fromString(String s) {
        return java.util.Arrays.stream(PropertyRuleIssueReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PropertyRuleIssueReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PropertyRuleIssueReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
