package net.sourceforge.jaad.aac.filterbank;

/**
 * This class is part of JAAD ( jaadec.sourceforge.net ) that is distributed
 * under the Public Domain license. Code changes provided by the JCodec project
 * are distributed under FreeBSD license.
 * 
 * @author in-somnia
 */
interface MDCTTables {

	float[][] MDCT_TABLE_2048 = {
		{0.031249997702054f, 0.000011984224612f},
		{0.031249813866531f, 0.000107857810004f},
		{0.031249335895858f, 0.000203730380198f},
		{0.031248563794535f, 0.000299601032804f},
		{0.031247497569829f, 0.000395468865451f},
		{0.031246137231775f, 0.000491332975794f},
		{0.031244482793177f, 0.000587192461525f},
		{0.031242534269608f, 0.000683046420376f},
		{0.031240291679407f, 0.000778893950134f},
		{0.031237755043684f, 0.000874734148645f},
		{0.031234924386313f, 0.000970566113826f},
		{0.031231799733938f, 0.001066388943669f},
		{0.031228381115970f, 0.001162201736253f},
		{0.031224668564585f, 0.001258003589751f},
		{0.031220662114728f, 0.001353793602441f},
		{0.031216361804108f, 0.001449570872710f},
		{0.031211767673203f, 0.001545334499065f},
		{0.031206879765253f, 0.001641083580144f},
		{0.031201698126266f, 0.001736817214719f},
		{0.031196222805014f, 0.001832534501709f},
		{0.031190453853031f, 0.001928234540186f},
		{0.031184391324617f, 0.002023916429386f},
		{0.031178035276836f, 0.002119579268713f},
		{0.031171385769513f, 0.002215222157753f},
		{0.031164442865236f, 0.002310844196278f},
		{0.031157206629353f, 0.002406444484258f},
		{0.031149677129975f, 0.002502022121865f},
		{0.031141854437973f, 0.002597576209488f},
		{0.031133738626977f, 0.002693105847734f},
		{0.031125329773375f, 0.002788610137442f},
		{0.031116627956316f, 0.002884088179689f},
		{0.031107633257703f, 0.002979539075801f},
		{0.031098345762200f, 0.003074961927355f},
		{0.031088765557222f, 0.003170355836197f},
		{0.031078892732942f, 0.003265719904442f},
		{0.031068727382288f, 0.003361053234488f},
		{0.031058269600939f, 0.003456354929021f},
		{0.031047519487329f, 0.003551624091024f},
		{0.031036477142640f, 0.003646859823790f},
		{0.031025142670809f, 0.003742061230921f},
		{0.031013516178519f, 0.003837227416347f},
		{0.031001597775203f, 0.003932357484328f},
		{0.030989387573042f, 0.004027450539462f},
		{0.030976885686963f, 0.004122505686697f},
		{0.030964092234638f, 0.004217522031340f},
		{0.030951007336485f, 0.004312498679058f},
		{0.030937631115663f, 0.004407434735897f},
		{0.030923963698074f, 0.004502329308281f},
		{0.030910005212362f, 0.004597181503027f},
		{0.030895755789908f, 0.004691990427350f},
		{0.030881215564835f, 0.004786755188872f},
		{0.030866384674000f, 0.004881474895632f},
		{0.030851263256996f, 0.004976148656090f},
		{0.030835851456154f, 0.005070775579142f},
		{0.030820149416533f, 0.005165354774124f},
		{0.030804157285929f, 0.005259885350819f},
		{0.030787875214864f, 0.005354366419469f},
		{0.030771303356593f, 0.005448797090784f},
		{0.030754441867095f, 0.005543176475946f},
		{0.030737290905077f, 0.005637503686619f},
		{0.030719850631972f, 0.005731777834961f},
		{0.030702121211932f, 0.005825998033626f},
		{0.030684102811835f, 0.005920163395780f},
		{0.030665795601276f, 0.006014273035101f},
		{0.030647199752570f, 0.006108326065793f},
		{0.030628315440748f, 0.006202321602594f},
		{0.030609142843557f, 0.006296258760782f},
		{0.030589682141455f, 0.006390136656185f},
		{0.030569933517616f, 0.006483954405188f},
		{0.030549897157919f, 0.006577711124743f},
		{0.030529573250956f, 0.006671405932375f},
		{0.030508961988022f, 0.006765037946194f},
		{0.030488063563118f, 0.006858606284900f},
		{0.030466878172949f, 0.006952110067791f},
		{0.030445406016919f, 0.007045548414774f},
		{0.030423647297133f, 0.007138920446372f},
		{0.030401602218392f, 0.007232225283733f},
		{0.030379270988192f, 0.007325462048634f},
		{0.030356653816724f, 0.007418629863497f},
		{0.030333750916869f, 0.007511727851390f},
		{0.030310562504198f, 0.007604755136040f},
		{0.030287088796968f, 0.007697710841838f},
		{0.030263330016124f, 0.007790594093851f},
		{0.030239286385293f, 0.007883404017824f},
		{0.030214958130781f, 0.007976139740197f},
		{0.030190345481576f, 0.008068800388104f},
		{0.030165448669342f, 0.008161385089390f},
		{0.030140267928416f, 0.008253892972610f},
		{0.030114803495809f, 0.008346323167047f},
		{0.030089055611203f, 0.008438674802711f},
		{0.030063024516947f, 0.008530947010354f},
		{0.030036710458054f, 0.008623138921475f},
		{0.030010113682202f, 0.008715249668328f},
		{0.029983234439732f, 0.008807278383932f},
		{0.029956072983640f, 0.008899224202078f},
		{0.029928629569580f, 0.008991086257336f},
		{0.029900904455860f, 0.009082863685067f},
		{0.029872897903441f, 0.009174555621425f},
		{0.029844610175929f, 0.009266161203371f},
		{0.029816041539579f, 0.009357679568679f},
		{0.029787192263292f, 0.009449109855944f},
		{0.029758062618606f, 0.009540451204587f},
		{0.029728652879702f, 0.009631702754871f},
		{0.029698963323395f, 0.009722863647900f},
		{0.029668994229134f, 0.009813933025633f},
		{0.029638745879000f, 0.009904910030891f},
		{0.029608218557702f, 0.009995793807363f},
		{0.029577412552575f, 0.010086583499618f},
		{0.029546328153577f, 0.010177278253107f},
		{0.029514965653285f, 0.010267877214177f},
		{0.029483325346896f, 0.010358379530076f},
		{0.029451407532220f, 0.010448784348962f},
		{0.029419212509679f, 0.010539090819911f},
		{0.029386740582307f, 0.010629298092923f},
		{0.029353992055740f, 0.010719405318933f},
		{0.029320967238220f, 0.010809411649818f},
		{0.029287666440590f, 0.010899316238403f},
		{0.029254089976290f, 0.010989118238474f},
		{0.029220238161353f, 0.011078816804778f},
		{0.029186111314406f, 0.011168411093039f},
		{0.029151709756664f, 0.011257900259961f},
		{0.029117033811927f, 0.011347283463239f},
		{0.029082083806579f, 0.011436559861563f},
		{0.029046860069582f, 0.011525728614630f},
		{0.029011362932476f, 0.011614788883150f},
		{0.028975592729373f, 0.011703739828853f},
		{0.028939549796957f, 0.011792580614500f},
		{0.028903234474475f, 0.011881310403886f},
		{0.028866647103744f, 0.011969928361855f},
		{0.028829788029135f, 0.012058433654299f},
		{0.028792657597583f, 0.012146825448172f},
		{0.028755256158571f, 0.012235102911499f},
		{0.028717584064137f, 0.012323265213377f},
		{0.028679641668864f, 0.012411311523990f},
		{0.028641429329882f, 0.012499241014612f},
		{0.028602947406859f, 0.012587052857618f},
		{0.028564196262001f, 0.012674746226488f},
		{0.028525176260050f, 0.012762320295819f},
		{0.028485887768276f, 0.012849774241331f},
		{0.028446331156478f, 0.012937107239875f},
		{0.028406506796976f, 0.013024318469437f},
		{0.028366415064615f, 0.013111407109155f},
		{0.028326056336751f, 0.013198372339315f},
		{0.028285430993258f, 0.013285213341368f},
		{0.028244539416515f, 0.013371929297933f},
		{0.028203381991411f, 0.013458519392807f},
		{0.028161959105334f, 0.013544982810971f},
		{0.028120271148172f, 0.013631318738598f},
		{0.028078318512309f, 0.013717526363062f},
		{0.028036101592619f, 0.013803604872943f},
		{0.027993620786463f, 0.013889553458039f},
		{0.027950876493687f, 0.013975371309367f},
		{0.027907869116616f, 0.014061057619178f},
		{0.027864599060052f, 0.014146611580959f},
		{0.027821066731270f, 0.014232032389445f},
		{0.027777272540012f, 0.014317319240622f},
		{0.027733216898487f, 0.014402471331737f},
		{0.027688900221361f, 0.014487487861307f},
		{0.027644322925762f, 0.014572368029123f},
		{0.027599485431266f, 0.014657111036262f},
		{0.027554388159903f, 0.014741716085090f},
		{0.027509031536144f, 0.014826182379271f},
		{0.027463415986904f, 0.014910509123778f},
		{0.027417541941533f, 0.014994695524894f},
		{0.027371409831816f, 0.015078740790225f},
		{0.027325020091965f, 0.015162644128704f},
		{0.027278373158618f, 0.015246404750603f},
		{0.027231469470833f, 0.015330021867534f},
		{0.027184309470088f, 0.015413494692460f},
		{0.027136893600268f, 0.015496822439704f},
		{0.027089222307671f, 0.015580004324954f},
		{0.027041296040997f, 0.015663039565269f},
		{0.026993115251345f, 0.015745927379091f},
		{0.026944680392213f, 0.015828666986247f},
		{0.026895991919487f, 0.015911257607961f},
		{0.026847050291442f, 0.015993698466859f},
		{0.026797855968734f, 0.016075988786976f},
		{0.026748409414401f, 0.016158127793763f},
		{0.026698711093851f, 0.016240114714099f},
		{0.026648761474864f, 0.016321948776289f},
		{0.026598561027585f, 0.016403629210082f},
		{0.026548110224519f, 0.016485155246669f},
		{0.026497409540530f, 0.016566526118696f},
		{0.026446459452830f, 0.016647741060271f},
		{0.026395260440982f, 0.016728799306966f},
		{0.026343812986890f, 0.016809700095831f},
		{0.026292117574797f, 0.016890442665397f},
		{0.026240174691280f, 0.016971026255683f},
		{0.026187984825246f, 0.017051450108208f},
		{0.026135548467924f, 0.017131713465990f},
		{0.026082866112867f, 0.017211815573560f},
		{0.026029938255941f, 0.017291755676967f},
		{0.025976765395322f, 0.017371533023784f},
		{0.025923348031494f, 0.017451146863116f},
		{0.025869686667242f, 0.017530596445607f},
		{0.025815781807646f, 0.017609881023449f},
		{0.025761633960080f, 0.017688999850383f},
		{0.025707243634204f, 0.017767952181715f},
		{0.025652611341960f, 0.017846737274313f},
		{0.025597737597568f, 0.017925354386623f},
		{0.025542622917522f, 0.018003802778671f},
		{0.025487267820581f, 0.018082081712071f},
		{0.025431672827768f, 0.018160190450031f},
		{0.025375838462365f, 0.018238128257362f},
		{0.025319765249906f, 0.018315894400484f},
		{0.025263453718173f, 0.018393488147432f},
		{0.025206904397193f, 0.018470908767865f},
		{0.025150117819228f, 0.018548155533070f},
		{0.025093094518776f, 0.018625227715971f},
		{0.025035835032562f, 0.018702124591135f},
		{0.024978339899534f, 0.018778845434780f},
		{0.024920609660858f, 0.018855389524780f},
		{0.024862644859912f, 0.018931756140672f},
		{0.024804446042284f, 0.019007944563666f},
		{0.024746013755764f, 0.019083954076646f},
		{0.024687348550337f, 0.019159783964183f},
		{0.024628450978184f, 0.019235433512536f},
		{0.024569321593670f, 0.019310902009663f},
		{0.024509960953345f, 0.019386188745225f},
		{0.024450369615932f, 0.019461293010596f},
		{0.024390548142329f, 0.019536214098866f},
		{0.024330497095598f, 0.019610951304848f},
		{0.024270217040961f, 0.019685503925087f},
		{0.024209708545799f, 0.019759871257867f},
		{0.024148972179639f, 0.019834052603212f},
		{0.024088008514157f, 0.019908047262901f},
		{0.024026818123164f, 0.019981854540467f},
		{0.023965401582609f, 0.020055473741208f},
		{0.023903759470567f, 0.020128904172192f},
		{0.023841892367236f, 0.020202145142264f},
		{0.023779800854935f, 0.020275195962052f},
		{0.023717485518092f, 0.020348055943974f},
		{0.023654946943242f, 0.020420724402244f},
		{0.023592185719023f, 0.020493200652878f},
		{0.023529202436167f, 0.020565484013703f},
		{0.023465997687496f, 0.020637573804361f},
		{0.023402572067918f, 0.020709469346314f},
		{0.023338926174419f, 0.020781169962854f},
		{0.023275060606058f, 0.020852674979108f},
		{0.023210975963963f, 0.020923983722044f},
		{0.023146672851322f, 0.020995095520475f},
		{0.023082151873380f, 0.021066009705072f},
		{0.023017413637435f, 0.021136725608363f},
		{0.022952458752826f, 0.021207242564742f},
		{0.022887287830934f, 0.021277559910478f},
		{0.022821901485173f, 0.021347676983716f},
		{0.022756300330983f, 0.021417593124488f},
		{0.022690484985827f, 0.021487307674717f},
		{0.022624456069185f, 0.021556819978223f},
		{0.022558214202547f, 0.021626129380729f},
		{0.022491760009405f, 0.021695235229869f},
		{0.022425094115252f, 0.021764136875192f},
		{0.022358217147572f, 0.021832833668171f},
		{0.022291129735838f, 0.021901324962204f},
		{0.022223832511501f, 0.021969610112625f},
		{0.022156326107988f, 0.022037688476709f},
		{0.022088611160696f, 0.022105559413676f},
		{0.022020688306983f, 0.022173222284699f},
		{0.021952558186166f, 0.022240676452909f},
		{0.021884221439510f, 0.022307921283403f},
		{0.021815678710228f, 0.022374956143245f},
		{0.021746930643469f, 0.022441780401478f},
		{0.021677977886316f, 0.022508393429127f},
		{0.021608821087780f, 0.022574794599206f},
		{0.021539460898790f, 0.022640983286719f},
		{0.021469897972190f, 0.022706958868676f},
		{0.021400132962735f, 0.022772720724087f},
		{0.021330166527077f, 0.022838268233979f},
		{0.021259999323769f, 0.022903600781391f},
		{0.021189632013250f, 0.022968717751391f},
		{0.021119065257845f, 0.023033618531071f},
		{0.021048299721754f, 0.023098302509561f},
		{0.020977336071050f, 0.023162769078031f},
		{0.020906174973670f, 0.023227017629698f},
		{0.020834817099409f, 0.023291047559828f},
		{0.020763263119915f, 0.023354858265748f},
		{0.020691513708680f, 0.023418449146848f},
		{0.020619569541038f, 0.023481819604585f},
		{0.020547431294155f, 0.023544969042494f},
		{0.020475099647023f, 0.023607896866186f},
		{0.020402575280455f, 0.023670602483363f},
		{0.020329858877078f, 0.023733085303813f},
		{0.020256951121327f, 0.023795344739427f},
		{0.020183852699437f, 0.023857380204193f},
		{0.020110564299439f, 0.023919191114211f},
		{0.020037086611150f, 0.023980776887692f},
		{0.019963420326171f, 0.024042136944968f},
		{0.019889566137877f, 0.024103270708495f},
		{0.019815524741412f, 0.024164177602859f},
		{0.019741296833681f, 0.024224857054779f},
		{0.019666883113346f, 0.024285308493120f},
		{0.019592284280817f, 0.024345531348888f},
		{0.019517501038246f, 0.024405525055242f},
		{0.019442534089523f, 0.024465289047500f},
		{0.019367384140264f, 0.024524822763141f},
		{0.019292051897809f, 0.024584125641809f},
		{0.019216538071215f, 0.024643197125323f},
		{0.019140843371246f, 0.024702036657681f},
		{0.019064968510369f, 0.024760643685063f},
		{0.018988914202748f, 0.024819017655836f},
		{0.018912681164234f, 0.024877158020562f},
		{0.018836270112363f, 0.024935064232003f},
		{0.018759681766343f, 0.024992735745123f},
		{0.018682916847054f, 0.025050172017095f},
		{0.018605976077037f, 0.025107372507308f},
		{0.018528860180486f, 0.025164336677369f},
		{0.018451569883247f, 0.025221063991110f},
		{0.018374105912805f, 0.025277553914591f},
		{0.018296468998280f, 0.025333805916107f},
		{0.018218659870421f, 0.025389819466194f},
		{0.018140679261596f, 0.025445594037630f},
		{0.018062527905790f, 0.025501129105445f},
		{0.017984206538592f, 0.025556424146920f},
		{0.017905715897192f, 0.025611478641598f},
		{0.017827056720375f, 0.025666292071285f},
		{0.017748229748511f, 0.025720863920056f},
		{0.017669235723550f, 0.025775193674260f},
		{0.017590075389012f, 0.025829280822525f},
		{0.017510749489986f, 0.025883124855762f},
		{0.017431258773116f, 0.025936725267170f},
		{0.017351603986600f, 0.025990081552242f},
		{0.017271785880180f, 0.026043193208768f},
		{0.017191805205132f, 0.026096059736841f},
		{0.017111662714267f, 0.026148680638861f},
		{0.017031359161915f, 0.026201055419541f},
		{0.016950895303924f, 0.026253183585908f},
		{0.016870271897651f, 0.026305064647313f},
		{0.016789489701954f, 0.026356698115431f},
		{0.016708549477186f, 0.026408083504269f},
		{0.016627451985187f, 0.026459220330167f},
		{0.016546197989277f, 0.026510108111806f},
		{0.016464788254250f, 0.026560746370212f},
		{0.016383223546365f, 0.026611134628757f},
		{0.016301504633341f, 0.026661272413168f},
		{0.016219632284346f, 0.026711159251530f},
		{0.016137607269996f, 0.026760794674288f},
		{0.016055430362340f, 0.026810178214254f},
		{0.015973102334858f, 0.026859309406613f},
		{0.015890623962454f, 0.026908187788922f},
		{0.015807996021446f, 0.026956812901119f},
		{0.015725219289558f, 0.027005184285527f},
		{0.015642294545918f, 0.027053301486856f},
		{0.015559222571044f, 0.027101164052208f},
		{0.015476004146842f, 0.027148771531083f},
		{0.015392640056594f, 0.027196123475380f},
		{0.015309131084956f, 0.027243219439406f},
		{0.015225478017946f, 0.027290058979875f},
		{0.015141681642938f, 0.027336641655915f},
		{0.015057742748656f, 0.027382967029073f},
		{0.014973662125164f, 0.027429034663317f},
		{0.014889440563862f, 0.027474844125040f},
		{0.014805078857474f, 0.027520394983066f},
		{0.014720577800046f, 0.027565686808654f},
		{0.014635938186934f, 0.027610719175499f},
		{0.014551160814797f, 0.027655491659740f},
		{0.014466246481592f, 0.027700003839960f},
		{0.014381195986567f, 0.027744255297195f},
		{0.014296010130247f, 0.027788245614933f},
		{0.014210689714436f, 0.027831974379120f},
		{0.014125235542201f, 0.027875441178165f},
		{0.014039648417870f, 0.027918645602941f},
		{0.013953929147020f, 0.027961587246792f},
		{0.013868078536476f, 0.028004265705534f},
		{0.013782097394294f, 0.028046680577462f},
		{0.013695986529763f, 0.028088831463351f},
		{0.013609746753390f, 0.028130717966461f},
		{0.013523378876898f, 0.028172339692540f},
		{0.013436883713214f, 0.028213696249828f},
		{0.013350262076462f, 0.028254787249062f},
		{0.013263514781960f, 0.028295612303478f},
		{0.013176642646205f, 0.028336171028814f},
		{0.013089646486871f, 0.028376463043317f},
		{0.013002527122799f, 0.028416487967743f},
		{0.012915285373990f, 0.028456245425361f},
		{0.012827922061597f, 0.028495735041960f},
		{0.012740438007915f, 0.028534956445849f},
		{0.012652834036379f, 0.028573909267859f},
		{0.012565110971550f, 0.028612593141354f},
		{0.012477269639111f, 0.028651007702224f},
		{0.012389310865858f, 0.028689152588899f},
		{0.012301235479693f, 0.028727027442343f},
		{0.012213044309615f, 0.028764631906065f},
		{0.012124738185712f, 0.028801965626115f},
		{0.012036317939156f, 0.028839028251097f},
		{0.011947784402191f, 0.028875819432161f},
		{0.011859138408130f, 0.028912338823015f},
		{0.011770380791341f, 0.028948586079925f},
		{0.011681512387245f, 0.028984560861718f},
		{0.011592534032306f, 0.029020262829785f},
		{0.011503446564022f, 0.029055691648087f},
		{0.011414250820918f, 0.029090846983152f},
		{0.011324947642537f, 0.029125728504087f},
		{0.011235537869437f, 0.029160335882573f},
		{0.011146022343175f, 0.029194668792871f},
		{0.011056401906305f, 0.029228726911828f},
		{0.010966677402371f, 0.029262509918876f},
		{0.010876849675891f, 0.029296017496036f},
		{0.010786919572361f, 0.029329249327922f},
		{0.010696887938235f, 0.029362205101743f},
		{0.010606755620926f, 0.029394884507308f},
		{0.010516523468793f, 0.029427287237024f},
		{0.010426192331137f, 0.029459412985906f},
		{0.010335763058187f, 0.029491261451573f},
		{0.010245236501099f, 0.029522832334255f},
		{0.010154613511943f, 0.029554125336796f},
		{0.010063894943698f, 0.029585140164654f},
		{0.009973081650240f, 0.029615876525905f},
		{0.009882174486340f, 0.029646334131247f},
		{0.009791174307650f, 0.029676512694001f},
		{0.009700081970699f, 0.029706411930116f},
		{0.009608898332881f, 0.029736031558168f},
		{0.009517624252453f, 0.029765371299366f},
		{0.009426260588521f, 0.029794430877553f},
		{0.009334808201034f, 0.029823210019210f},
		{0.009243267950778f, 0.029851708453456f},
		{0.009151640699363f, 0.029879925912053f},
		{0.009059927309220f, 0.029907862129408f},
		{0.008968128643591f, 0.029935516842573f},
		{0.008876245566520f, 0.029962889791254f},
		{0.008784278942845f, 0.029989980717805f},
		{0.008692229638191f, 0.030016789367235f},
		{0.008600098518961f, 0.030043315487212f},
		{0.008507886452329f, 0.030069558828062f},
		{0.008415594306230f, 0.030095519142772f},
		{0.008323222949351f, 0.030121196186994f},
		{0.008230773251129f, 0.030146589719046f},
		{0.008138246081733f, 0.030171699499915f},
		{0.008045642312067f, 0.030196525293257f},
		{0.007952962813750f, 0.030221066865402f},
		{0.007860208459119f, 0.030245323985357f},
		{0.007767380121212f, 0.030269296424803f},
		{0.007674478673766f, 0.030292983958103f},
		{0.007581504991203f, 0.030316386362302f},
		{0.007488459948628f, 0.030339503417126f},
		{0.007395344421816f, 0.030362334904989f},
		{0.007302159287206f, 0.030384880610993f},
		{0.007208905421891f, 0.030407140322928f},
		{0.007115583703613f, 0.030429113831278f},
		{0.007022195010752f, 0.030450800929220f},
		{0.006928740222316f, 0.030472201412626f},
		{0.006835220217939f, 0.030493315080068f},
		{0.006741635877866f, 0.030514141732814f},
		{0.006647988082948f, 0.030534681174838f},
		{0.006554277714635f, 0.030554933212813f},
		{0.006460505654964f, 0.030574897656119f},
		{0.006366672786553f, 0.030594574316845f},
		{0.006272779992593f, 0.030613963009786f},
		{0.006178828156839f, 0.030633063552447f},
		{0.006084818163601f, 0.030651875765048f},
		{0.005990750897737f, 0.030670399470520f},
		{0.005896627244644f, 0.030688634494512f},
		{0.005802448090250f, 0.030706580665388f},
		{0.005708214321004f, 0.030724237814232f},
		{0.005613926823871f, 0.030741605774849f},
		{0.005519586486321f, 0.030758684383764f},
		{0.005425194196321f, 0.030775473480228f},
		{0.005330750842327f, 0.030791972906214f},
		{0.005236257313276f, 0.030808182506425f},
		{0.005141714498576f, 0.030824102128288f},
		{0.005047123288102f, 0.030839731621963f},
		{0.004952484572181f, 0.030855070840339f},
		{0.004857799241589f, 0.030870119639036f},
		{0.004763068187541f, 0.030884877876411f},
		{0.004668292301681f, 0.030899345413553f},
		{0.004573472476075f, 0.030913522114288f},
		{0.004478609603205f, 0.030927407845180f},
		{0.004383704575956f, 0.030941002475530f},
		{0.004288758287610f, 0.030954305877381f},
		{0.004193771631837f, 0.030967317925516f},
		{0.004098745502689f, 0.030980038497461f},
		{0.004003680794587f, 0.030992467473486f},
		{0.003908578402316f, 0.031004604736602f},
		{0.003813439221017f, 0.031016450172571f},
		{0.003718264146176f, 0.031028003669899f},
		{0.003623054073616f, 0.031039265119839f},
		{0.003527809899492f, 0.031050234416394f},
		{0.003432532520278f, 0.031060911456318f},
		{0.003337222832760f, 0.031071296139114f},
		{0.003241881734029f, 0.031081388367037f},
		{0.003146510121474f, 0.031091188045095f},
		{0.003051108892766f, 0.031100695081051f},
		{0.002955678945860f, 0.031109909385419f},
		{0.002860221178978f, 0.031118830871473f},
		{0.002764736490604f, 0.031127459455239f},
		{0.002669225779478f, 0.031135795055501f},
		{0.002573689944583f, 0.031143837593803f},
		{0.002478129885137f, 0.031151586994444f},
		{0.002382546500589f, 0.031159043184484f},
		{0.002286940690606f, 0.031166206093743f},
		{0.002191313355067f, 0.031173075654800f},
		{0.002095665394051f, 0.031179651802998f},
		{0.001999997707835f, 0.031185934476438f},
		{0.001904311196878f, 0.031191923615985f},
		{0.001808606761820f, 0.031197619165268f},
		{0.001712885303465f, 0.031203021070678f},
		{0.001617147722782f, 0.031208129281370f},
		{0.001521394920889f, 0.031212943749264f},
		{0.001425627799047f, 0.031217464429043f},
		{0.001329847258653f, 0.031221691278159f},
		{0.001234054201231f, 0.031225624256825f},
		{0.001138249528420f, 0.031229263328024f},
		{0.001042434141971f, 0.031232608457502f},
		{0.000946608943736f, 0.031235659613775f},
		{0.000850774835656f, 0.031238416768124f},
		{0.000754932719759f, 0.031240879894597f},
		{0.000659083498149f, 0.031243048970010f},
		{0.000563228072993f, 0.031244923973948f},
		{0.000467367346520f, 0.031246504888762f},
		{0.000371502221008f, 0.031247791699571f},
		{0.000275633598775f, 0.031248784394264f},
		{0.000179762382174f, 0.031249482963498f},
		{0.000083889473581f, 0.031249887400697f}
	};
	float[][] MDCT_TABLE_128 = {
		{0.088387931675923f, 0.000271171628935f},
		{0.088354655998507f, 0.002440238387037f},
		{0.088268158780110f, 0.004607835236780f},
		{0.088128492123423f, 0.006772656498875f},
		{0.087935740158418f, 0.008933398165942f},
		{0.087690018991670f, 0.011088758687994f},
		{0.087391476636423f, 0.013237439756448f},
		{0.087040292923427f, 0.015378147086172f},
		{0.086636679392621f, 0.017509591195118f},
		{0.086180879165703f, 0.019630488181053f},
		{0.085673166799686f, 0.021739560494940f},
		{0.085113848121515f, 0.023835537710479f},
		{0.084503260043847f, 0.025917157289369f},
		{0.083841770362110f, 0.027983165341813f},
		{0.083129777532952f, 0.030032317381813f},
		{0.082367710434230f, 0.032063379076803f},
		{0.081556028106671f, 0.034075126991164f},
		{0.080695219477356f, 0.036066349323177f},
		{0.079785803065216f, 0.038035846634965f},
		{0.078828326668693f, 0.039982432574992f},
		{0.077823367035766f, 0.041904934592675f},
		{0.076771529516540f, 0.043802194644686f},
		{0.075673447698606f, 0.045673069892513f},
		{0.074529783025390f, 0.047516433390863f},
		{0.073341224397728f, 0.049331174766491f},
		{0.072108487758894f, 0.051116200887052f},
		{0.070832315663343f, 0.052870436519557f},
		{0.069513476829429f, 0.054592824978055f},
		{0.068152765676348f, 0.056282328760143f},
		{0.066751001845620f, 0.057937930171918f},
		{0.065309029707361f, 0.059558631940996f},
		{0.063827717851668f, 0.061143457817234f},
		{0.062307958565413f, 0.062691453160784f},
		{0.060750667294763f, 0.064201685517134f},
		{0.059156782093749f, 0.065673245178784f},
		{0.057527263059216f, 0.067105245733220f},
		{0.055863091752499f, 0.068496824596852f},
		{0.054165270608165f, 0.069847143534609f},
		{0.052434822330188f, 0.071155389164853f},
		{0.050672789275903f, 0.072420773449336f},
		{0.048880232828135f, 0.073642534167879f},
		{0.047058232755862f, 0.074819935377512f},
		{0.045207886563797f, 0.075952267855771f},
		{0.043330308831298f, 0.077038849527912f},
		{0.041426630540984f, 0.078079025877766f},
		{0.039497998397473f, 0.079072170341994f},
		{0.037545574136653f, 0.080017684687506f},
		{0.035570533825892f, 0.080914999371817f},
		{0.033574067155622f, 0.081763573886112f},
		{0.031557376722714f, 0.082562897080836f},
		{0.029521677306074f, 0.083312487473584f},
		{0.027468195134911f, 0.084011893539132f},
		{0.025398167150101f, 0.084660693981419f},
		{0.023312840259098f, 0.085258497987320f},
		{0.021213470584847f, 0.085804945462053f},
		{0.019101322709138f, 0.086299707246093f},
		{0.016977668910873f, 0.086742485313442f},
		{0.014843788399692f, 0.087133012951149f},
		{0.012700966545425f, 0.087471054919968f},
		{0.010550494103830f, 0.087756407596056f},
		{0.008393666439096f, 0.087988899093631f},
		{0.006231782743558f, 0.088168389368510f},
		{0.004066145255116f, 0.088294770302461f},
		{0.001898058472816f, 0.088367965768336f}
	};
	float[][] MDCT_TABLE_1920 = {
		{0.032274858518097f, 0.000013202404176f},
		{0.032274642494505f, 0.000118821372483f},
		{0.032274080835421f, 0.000224439068308f},
		{0.032273173546860f, 0.000330054360572f},
		{0.032271920638538f, 0.000435666118218f},
		{0.032270322123873f, 0.000541273210231f},
		{0.032268378019984f, 0.000646874505642f},
		{0.032266088347691f, 0.000752468873546f},
		{0.032263453131514f, 0.000858055183114f},
		{0.032260472399674f, 0.000963632303600f},
		{0.032257146184092f, 0.001069199104358f},
		{0.032253474520390f, 0.001174754454853f},
		{0.032249457447888f, 0.001280297224671f},
		{0.032245095009606f, 0.001385826283535f},
		{0.032240387252262f, 0.001491340501313f},
		{0.032235334226272f, 0.001596838748031f},
		{0.032229935985750f, 0.001702319893890f},
		{0.032224192588507f, 0.001807782809271f},
		{0.032218104096050f, 0.001913226364749f},
		{0.032211670573582f, 0.002018649431111f},
		{0.032204892090000f, 0.002124050879359f},
		{0.032197768717898f, 0.002229429580728f},
		{0.032190300533560f, 0.002334784406698f},
		{0.032182487616965f, 0.002440114229003f},
		{0.032174330051782f, 0.002545417919644f},
		{0.032165827925374f, 0.002650694350905f},
		{0.032156981328790f, 0.002755942395358f},
		{0.032147790356771f, 0.002861160925883f},
		{0.032138255107744f, 0.002966348815672f},
		{0.032128375683825f, 0.003071504938250f},
		{0.032118152190814f, 0.003176628167476f},
		{0.032107584738196f, 0.003281717377568f},
		{0.032096673439141f, 0.003386771443102f},
		{0.032085418410500f, 0.003491789239036f},
		{0.032073819772804f, 0.003596769640711f},
		{0.032061877650267f, 0.003701711523874f},
		{0.032049592170778f, 0.003806613764680f},
		{0.032036963465906f, 0.003911475239711f},
		{0.032023991670893f, 0.004016294825985f},
		{0.032010676924657f, 0.004121071400967f},
		{0.031997019369789f, 0.004225803842586f},
		{0.031983019152549f, 0.004330491029241f},
		{0.031968676422869f, 0.004435131839816f},
		{0.031953991334348f, 0.004539725153692f},
		{0.031938964044252f, 0.004644269850758f},
		{0.031923594713510f, 0.004748764811426f},
		{0.031907883506716f, 0.004853208916638f},
		{0.031891830592124f, 0.004957601047881f},
		{0.031875436141648f, 0.005061940087200f},
		{0.031858700330859f, 0.005166224917208f},
		{0.031841623338985f, 0.005270454421097f},
		{0.031824205348907f, 0.005374627482653f},
		{0.031806446547156f, 0.005478742986267f},
		{0.031788347123916f, 0.005582799816945f},
		{0.031769907273017f, 0.005686796860323f},
		{0.031751127191935f, 0.005790733002674f},
		{0.031732007081789f, 0.005894607130928f},
		{0.031712547147340f, 0.005998418132675f},
		{0.031692747596989f, 0.006102164896182f},
		{0.031672608642773f, 0.006205846310406f},
		{0.031652130500364f, 0.006309461265002f},
		{0.031631313389067f, 0.006413008650337f},
		{0.031610157531816f, 0.006516487357501f},
		{0.031588663155172f, 0.006619896278321f},
		{0.031566830489325f, 0.006723234305370f},
		{0.031544659768083f, 0.006826500331981f},
		{0.031522151228878f, 0.006929693252258f},
		{0.031499305112758f, 0.007032811961088f},
		{0.031476121664387f, 0.007135855354151f},
		{0.031452601132040f, 0.007238822327937f},
		{0.031428743767604f, 0.007341711779751f},
		{0.031404549826572f, 0.007444522607730f},
		{0.031380019568042f, 0.007547253710853f},
		{0.031355153254712f, 0.007649903988952f},
		{0.031329951152882f, 0.007752472342725f},
		{0.031304413532445f, 0.007854957673748f},
		{0.031278540666888f, 0.007957358884484f},
		{0.031252332833290f, 0.008059674878300f},
		{0.031225790312316f, 0.008161904559473f},
		{0.031198913388214f, 0.008264046833205f},
		{0.031171702348814f, 0.008366100605636f},
		{0.031144157485525f, 0.008468064783849f},
		{0.031116279093331f, 0.008569938275893f},
		{0.031088067470786f, 0.008671719990782f},
		{0.031059522920014f, 0.008773408838517f},
		{0.031030645746705f, 0.008875003730092f},
		{0.031001436260110f, 0.008976503577507f},
		{0.030971894773039f, 0.009077907293780f},
		{0.030942021601857f, 0.009179213792959f},
		{0.030911817066483f, 0.009280421990133f},
		{0.030881281490382f, 0.009381530801444f},
		{0.030850415200566f, 0.009482539144097f},
		{0.030819218527589f, 0.009583445936373f},
		{0.030787691805541f, 0.009684250097643f},
		{0.030755835372048f, 0.009784950548375f},
		{0.030723649568268f, 0.009885546210147f},
		{0.030691134738883f, 0.009986036005661f},
		{0.030658291232103f, 0.010086418858753f},
		{0.030625119399655f, 0.010186693694402f},
		{0.030591619596781f, 0.010286859438745f},
		{0.030557792182239f, 0.010386915019088f},
		{0.030523637518292f, 0.010486859363916f},
		{0.030489155970710f, 0.010586691402906f},
		{0.030454347908763f, 0.010686410066936f},
		{0.030419213705216f, 0.010786014288099f},
		{0.030383753736329f, 0.010885502999714f},
		{0.030347968381849f, 0.010984875136338f},
		{0.030311858025010f, 0.011084129633775f},
		{0.030275423052523f, 0.011183265429088f},
		{0.030238663854579f, 0.011282281460612f},
		{0.030201580824838f, 0.011381176667967f},
		{0.030164174360430f, 0.011479949992062f},
		{0.030126444861948f, 0.011578600375117f},
		{0.030088392733446f, 0.011677126760663f},
		{0.030050018382430f, 0.011775528093563f},
		{0.030011322219859f, 0.011873803320018f},
		{0.029972304660138f, 0.011971951387578f},
		{0.029932966121114f, 0.012069971245157f},
		{0.029893307024070f, 0.012167861843041f},
		{0.029853327793724f, 0.012265622132901f},
		{0.029813028858222f, 0.012363251067801f},
		{0.029772410649132f, 0.012460747602215f},
		{0.029731473601443f, 0.012558110692033f},
		{0.029690218153558f, 0.012655339294575f},
		{0.029648644747289f, 0.012752432368600f},
		{0.029606753827855f, 0.012849388874320f},
		{0.029564545843872f, 0.012946207773407f},
		{0.029522021247356f, 0.013042888029011f},
		{0.029479180493710f, 0.013139428605762f},
		{0.029436024041725f, 0.013235828469789f},
		{0.029392552353570f, 0.013332086588727f},
		{0.029348765894794f, 0.013428201931728f},
		{0.029304665134313f, 0.013524173469475f},
		{0.029260250544412f, 0.013620000174189f},
		{0.029215522600735f, 0.013715681019643f},
		{0.029170481782283f, 0.013811214981173f},
		{0.029125128571406f, 0.013906601035686f},
		{0.029079463453801f, 0.014001838161674f},
		{0.029033486918505f, 0.014096925339225f},
		{0.028987199457889f, 0.014191861550031f},
		{0.028940601567655f, 0.014286645777401f},
		{0.028893693746829f, 0.014381277006273f},
		{0.028846476497755f, 0.014475754223221f},
		{0.028798950326094f, 0.014570076416472f},
		{0.028751115740811f, 0.014664242575910f},
		{0.028702973254178f, 0.014758251693091f},
		{0.028654523381760f, 0.014852102761253f},
		{0.028605766642418f, 0.014945794775326f},
		{0.028556703558297f, 0.015039326731945f},
		{0.028507334654823f, 0.015132697629457f},
		{0.028457660460698f, 0.015225906467935f},
		{0.028407681507891f, 0.015318952249187f},
		{0.028357398331639f, 0.015411833976768f},
		{0.028306811470432f, 0.015504550655988f},
		{0.028255921466016f, 0.015597101293927f},
		{0.028204728863381f, 0.015689484899442f},
		{0.028153234210760f, 0.015781700483179f},
		{0.028101438059619f, 0.015873747057582f},
		{0.028049340964652f, 0.015965623636907f},
		{0.027996943483779f, 0.016057329237229f},
		{0.027944246178133f, 0.016148862876456f},
		{0.027891249612061f, 0.016240223574335f},
		{0.027837954353113f, 0.016331410352467f},
		{0.027784360972039f, 0.016422422234315f},
		{0.027730470042780f, 0.016513258245214f},
		{0.027676282142466f, 0.016603917412384f},
		{0.027621797851405f, 0.016694398764938f},
		{0.027567017753080f, 0.016784701333894f},
		{0.027511942434143f, 0.016874824152183f},
		{0.027456572484404f, 0.016964766254662f},
		{0.027400908496833f, 0.017054526678124f},
		{0.027344951067546f, 0.017144104461307f},
		{0.027288700795801f, 0.017233498644904f},
		{0.027232158283994f, 0.017322708271577f},
		{0.027175324137651f, 0.017411732385960f},
		{0.027118198965418f, 0.017500570034678f},
		{0.027060783379060f, 0.017589220266351f},
		{0.027003077993454f, 0.017677682131607f},
		{0.026945083426576f, 0.017765954683088f},
		{0.026886800299502f, 0.017854036975468f},
		{0.026828229236397f, 0.017941928065456f},
		{0.026769370864511f, 0.018029627011808f},
		{0.026710225814170f, 0.018117132875340f},
		{0.026650794718768f, 0.018204444718934f},
		{0.026591078214767f, 0.018291561607551f},
		{0.026531076941680f, 0.018378482608238f},
		{0.026470791542075f, 0.018465206790142f},
		{0.026410222661558f, 0.018551733224515f},
		{0.026349370948775f, 0.018638060984730f},
		{0.026288237055398f, 0.018724189146286f},
		{0.026226821636121f, 0.018810116786819f},
		{0.026165125348656f, 0.018895842986112f},
		{0.026103148853718f, 0.018981366826109f},
		{0.026040892815028f, 0.019066687390916f},
		{0.025978357899296f, 0.019151803766819f},
		{0.025915544776223f, 0.019236715042290f},
		{0.025852454118485f, 0.019321420307998f},
		{0.025789086601733f, 0.019405918656817f},
		{0.025725442904582f, 0.019490209183837f},
		{0.025661523708606f, 0.019574290986376f},
		{0.025597329698327f, 0.019658163163984f},
		{0.025532861561211f, 0.019741824818458f},
		{0.025468119987662f, 0.019825275053848f},
		{0.025403105671008f, 0.019908512976470f},
		{0.025337819307501f, 0.019991537694913f},
		{0.025272261596305f, 0.020074348320047f},
		{0.025206433239491f, 0.020156943965039f},
		{0.025140334942028f, 0.020239323745355f},
		{0.025073967411776f, 0.020321486778774f},
		{0.025007331359476f, 0.020403432185395f},
		{0.024940427498748f, 0.020485159087650f},
		{0.024873256546079f, 0.020566666610309f},
		{0.024805819220816f, 0.020647953880491f},
		{0.024738116245157f, 0.020729020027676f},
		{0.024670148344147f, 0.020809864183709f},
		{0.024601916245669f, 0.020890485482816f},
		{0.024533420680433f, 0.020970883061607f},
		{0.024464662381971f, 0.021051056059087f},
		{0.024395642086630f, 0.021131003616670f},
		{0.024326360533561f, 0.021210724878181f},
		{0.024256818464715f, 0.021290218989868f},
		{0.024187016624830f, 0.021369485100415f},
		{0.024116955761430f, 0.021448522360944f},
		{0.024046636624808f, 0.021527329925030f},
		{0.023976059968027f, 0.021605906948708f},
		{0.023905226546906f, 0.021684252590480f},
		{0.023834137120014f, 0.021762366011328f},
		{0.023762792448662f, 0.021840246374720f},
		{0.023691193296893f, 0.021917892846620f},
		{0.023619340431478f, 0.021995304595495f},
		{0.023547234621902f, 0.022072480792330f},
		{0.023474876640361f, 0.022149420610628f},
		{0.023402267261751f, 0.022226123226426f},
		{0.023329407263659f, 0.022302587818300f},
		{0.023256297426359f, 0.022378813567377f},
		{0.023182938532797f, 0.022454799657339f},
		{0.023109331368588f, 0.022530545274437f},
		{0.023035476722006f, 0.022606049607496f},
		{0.022961375383975f, 0.022681311847926f},
		{0.022887028148061f, 0.022756331189727f},
		{0.022812435810462f, 0.022831106829504f},
		{0.022737599170003f, 0.022905637966469f},
		{0.022662519028125f, 0.022979923802453f},
		{0.022587196188874f, 0.023053963541915f},
		{0.022511631458899f, 0.023127756391950f},
		{0.022435825647437f, 0.023201301562294f},
		{0.022359779566306f, 0.023274598265338f},
		{0.022283494029900f, 0.023347645716133f},
		{0.022206969855176f, 0.023420443132400f},
		{0.022130207861645f, 0.023492989734537f},
		{0.022053208871367f, 0.023565284745628f},
		{0.021975973708940f, 0.023637327391451f},
		{0.021898503201489f, 0.023709116900488f},
		{0.021820798178663f, 0.023780652503931f},
		{0.021742859472618f, 0.023851933435691f},
		{0.021664687918017f, 0.023922958932406f},
		{0.021586284352013f, 0.023993728233451f},
		{0.021507649614247f, 0.024064240580942f},
		{0.021428784546832f, 0.024134495219750f},
		{0.021349689994350f, 0.024204491397504f},
		{0.021270366803840f, 0.024274228364600f},
		{0.021190815824791f, 0.024343705374213f},
		{0.021111037909128f, 0.024412921682298f},
		{0.021031033911210f, 0.024481876547605f},
		{0.020950804687815f, 0.024550569231683f},
		{0.020870351098134f, 0.024618998998889f},
		{0.020789674003759f, 0.024687165116394f},
		{0.020708774268678f, 0.024755066854194f},
		{0.020627652759262f, 0.024822703485116f},
		{0.020546310344257f, 0.024890074284826f},
		{0.020464747894775f, 0.024957178531837f},
		{0.020382966284284f, 0.025024015507516f},
		{0.020300966388600f, 0.025090584496093f},
		{0.020218749085876f, 0.025156884784668f},
		{0.020136315256592f, 0.025222915663218f},
		{0.020053665783549f, 0.025288676424605f},
		{0.019970801551857f, 0.025354166364584f},
		{0.019887723448925f, 0.025419384781811f},
		{0.019804432364452f, 0.025484330977848f},
		{0.019720929190419f, 0.025549004257175f},
		{0.019637214821078f, 0.025613403927192f},
		{0.019553290152943f, 0.025677529298230f},
		{0.019469156084779f, 0.025741379683559f},
		{0.019384813517595f, 0.025804954399392f},
		{0.019300263354632f, 0.025868252764895f},
		{0.019215506501354f, 0.025931274102193f},
		{0.019130543865439f, 0.025994017736379f},
		{0.019045376356769f, 0.026056482995518f},
		{0.018960004887419f, 0.026118669210657f},
		{0.018874430371648f, 0.026180575715833f},
		{0.018788653725892f, 0.026242201848076f},
		{0.018702675868750f, 0.026303546947421f},
		{0.018616497720974f, 0.026364610356909f},
		{0.018530120205464f, 0.026425391422602f},
		{0.018443544247254f, 0.026485889493583f},
		{0.018356770773502f, 0.026546103921965f},
		{0.018269800713483f, 0.026606034062902f},
		{0.018182634998576f, 0.026665679274589f},
		{0.018095274562256f, 0.026725038918274f},
		{0.018007720340083f, 0.026784112358263f},
		{0.017919973269692f, 0.026842898961926f},
		{0.017832034290785f, 0.026901398099707f},
		{0.017743904345116f, 0.026959609145127f},
		{0.017655584376488f, 0.027017531474792f},
		{0.017567075330734f, 0.027075164468401f},
		{0.017478378155718f, 0.027132507508750f},
		{0.017389493801313f, 0.027189559981742f},
		{0.017300423219401f, 0.027246321276391f},
		{0.017211167363854f, 0.027302790784828f},
		{0.017121727190533f, 0.027358967902310f},
		{0.017032103657269f, 0.027414852027226f},
		{0.016942297723858f, 0.027470442561102f},
		{0.016852310352050f, 0.027525738908608f},
		{0.016762142505537f, 0.027580740477564f},
		{0.016671795149944f, 0.027635446678948f},
		{0.016581269252819f, 0.027689856926900f},
		{0.016490565783622f, 0.027743970638730f},
		{0.016399685713714f, 0.027797787234924f},
		{0.016308630016347f, 0.027851306139149f},
		{0.016217399666655f, 0.027904526778260f},
		{0.016125995641641f, 0.027957448582309f},
		{0.016034418920170f, 0.028010070984544f},
		{0.015942670482954f, 0.028062393421421f},
		{0.015850751312545f, 0.028114415332610f},
		{0.015758662393324f, 0.028166136160998f},
		{0.015666404711489f, 0.028217555352697f},
		{0.015573979255046f, 0.028268672357047f},
		{0.015481387013797f, 0.028319486626627f},
		{0.015388628979331f, 0.028369997617257f},
		{0.015295706145012f, 0.028420204788004f},
		{0.015202619505968f, 0.028470107601191f},
		{0.015109370059084f, 0.028519705522399f},
		{0.015015958802984f, 0.028568998020472f},
		{0.014922386738030f, 0.028617984567529f},
		{0.014828654866302f, 0.028666664638963f},
		{0.014734764191593f, 0.028715037713449f},
		{0.014640715719398f, 0.028763103272951f},
		{0.014546510456900f, 0.028810860802724f},
		{0.014452149412962f, 0.028858309791325f},
		{0.014357633598114f, 0.028905449730613f},
		{0.014262964024545f, 0.028952280115756f},
		{0.014168141706090f, 0.028998800445240f},
		{0.014073167658220f, 0.029045010220868f},
		{0.013978042898030f, 0.029090908947771f},
		{0.013882768444231f, 0.029136496134411f},
		{0.013787345317136f, 0.029181771292585f},
		{0.013691774538648f, 0.029226733937433f},
		{0.013596057132255f, 0.029271383587441f},
		{0.013500194123014f, 0.029315719764447f},
		{0.013404186537539f, 0.029359741993647f},
		{0.013308035403995f, 0.029403449803598f},
		{0.013211741752084f, 0.029446842726223f},
		{0.013115306613032f, 0.029489920296820f},
		{0.013018731019584f, 0.029532682054063f},
		{0.012922016005985f, 0.029575127540008f},
		{0.012825162607977f, 0.029617256300097f},
		{0.012728171862781f, 0.029659067883165f},
		{0.012631044809089f, 0.029700561841444f},
		{0.012533782487056f, 0.029741737730567f},
		{0.012436385938281f, 0.029782595109573f},
		{0.012338856205805f, 0.029823133540913f},
		{0.012241194334091f, 0.029863352590452f},
		{0.012143401369021f, 0.029903251827477f},
		{0.012045478357878f, 0.029942830824699f},
		{0.011947426349339f, 0.029982089158259f},
		{0.011849246393462f, 0.030021026407731f},
		{0.011750939541676f, 0.030059642156129f},
		{0.011652506846768f, 0.030097935989909f},
		{0.011553949362874f, 0.030135907498976f},
		{0.011455268145464f, 0.030173556276684f},
		{0.011356464251335f, 0.030210881919845f},
		{0.011257538738598f, 0.030247884028732f},
		{0.011158492666665f, 0.030284562207083f},
		{0.011059327096240f, 0.030320916062102f},
		{0.010960043089307f, 0.030356945204470f},
		{0.010860641709118f, 0.030392649248343f},
		{0.010761124020182f, 0.030428027811361f},
		{0.010661491088253f, 0.030463080514646f},
		{0.010561743980319f, 0.030497806982812f},
		{0.010461883764593f, 0.030532206843968f},
		{0.010361911510496f, 0.030566279729717f},
		{0.010261828288652f, 0.030600025275167f},
		{0.010161635170872f, 0.030633443118931f},
		{0.010061333230142f, 0.030666532903129f},
		{0.009960923540617f, 0.030699294273397f},
		{0.009860407177603f, 0.030731726878888f},
		{0.009759785217550f, 0.030763830372273f},
		{0.009659058738038f, 0.030795604409750f},
		{0.009558228817767f, 0.030827048651045f},
		{0.009457296536545f, 0.030858162759415f},
		{0.009356262975275f, 0.030888946401653f},
		{0.009255129215945f, 0.030919399248091f},
		{0.009153896341616f, 0.030949520972603f},
		{0.009052565436412f, 0.030979311252611f},
		{0.008951137585505f, 0.031008769769084f},
		{0.008849613875105f, 0.031037896206544f},
		{0.008747995392451f, 0.031066690253072f},
		{0.008646283225794f, 0.031095151600306f},
		{0.008544478464390f, 0.031123279943448f},
		{0.008442582198486f, 0.031151074981266f},
		{0.008340595519310f, 0.031178536416098f},
		{0.008238519519057f, 0.031205663953853f},
		{0.008136355290878f, 0.031232457304017f},
		{0.008034103928871f, 0.031258916179656f},
		{0.007931766528065f, 0.031285040297416f},
		{0.007829344184412f, 0.031310829377528f},
		{0.007726837994772f, 0.031336283143813f},
		{0.007624249056906f, 0.031361401323680f},
		{0.007521578469457f, 0.031386183648135f},
		{0.007418827331946f, 0.031410629851778f},
		{0.007315996744755f, 0.031434739672811f},
		{0.007213087809115f, 0.031458512853036f},
		{0.007110101627101f, 0.031481949137863f},
		{0.007007039301610f, 0.031505048276306f},
		{0.006903901936357f, 0.031527810020993f},
		{0.006800690635862f, 0.031550234128164f},
		{0.006697406505433f, 0.031572320357675f},
		{0.006594050651161f, 0.031594068473000f},
		{0.006490624179905f, 0.031615478241233f},
		{0.006387128199278f, 0.031636549433095f},
		{0.006283563817639f, 0.031657281822929f},
		{0.006179932144080f, 0.031677675188707f},
		{0.006076234288412f, 0.031697729312034f},
		{0.005972471361157f, 0.031717443978146f},
		{0.005868644473532f, 0.031736818975914f},
		{0.005764754737440f, 0.031755854097848f},
		{0.005660803265456f, 0.031774549140098f},
		{0.005556791170816f, 0.031792903902453f},
		{0.005452719567407f, 0.031810918188350f},
		{0.005348589569753f, 0.031828591804869f},
		{0.005244402293001f, 0.031845924562742f},
		{0.005140158852914f, 0.031862916276347f},
		{0.005035860365855f, 0.031879566763717f},
		{0.004931507948778f, 0.031895875846539f},
		{0.004827102719212f, 0.031911843350155f},
		{0.004722645795254f, 0.031927469103567f},
		{0.004618138295554f, 0.031942752939435f},
		{0.004513581339303f, 0.031957694694082f},
		{0.004408976046222f, 0.031972294207493f},
		{0.004304323536549f, 0.031986551323320f},
		{0.004199624931030f, 0.032000465888879f},
		{0.004094881350902f, 0.032014037755158f},
		{0.003990093917884f, 0.032027266776813f},
		{0.003885263754166f, 0.032040152812170f},
		{0.003780391982394f, 0.032052695723232f},
		{0.003675479725661f, 0.032064895375674f},
		{0.003570528107494f, 0.032076751638847f},
		{0.003465538251839f, 0.032088264385780f},
		{0.003360511283053f, 0.032099433493181f},
		{0.003255448325892f, 0.032110258841438f},
		{0.003150350505494f, 0.032120740314619f},
		{0.003045218947373f, 0.032130877800478f},
		{0.002940054777404f, 0.032140671190449f},
		{0.002834859121810f, 0.032150120379653f},
		{0.002729633107153f, 0.032159225266897f},
		{0.002624377860318f, 0.032167985754674f},
		{0.002519094508504f, 0.032176401749168f},
		{0.002413784179212f, 0.032184473160250f},
		{0.002308448000231f, 0.032192199901481f},
		{0.002203087099626f, 0.032199581890114f},
		{0.002097702605728f, 0.032206619047093f},
		{0.001992295647121f, 0.032213311297057f},
		{0.001886867352628f, 0.032219658568338f},
		{0.001781418851302f, 0.032225660792960f},
		{0.001675951272410f, 0.032231317906644f},
		{0.001570465745428f, 0.032236629848809f},
		{0.001464963400018f, 0.032241596562566f},
		{0.001359445366028f, 0.032246217994727f},
		{0.001253912773470f, 0.032250494095799f},
		{0.001148366752513f, 0.032254424819990f},
		{0.001042808433471f, 0.032258010125204f},
		{0.000937238946789f, 0.032261249973045f},
		{0.000831659423030f, 0.032264144328817f},
		{0.000726070992868f, 0.032266693161525f},
		{0.000620474787068f, 0.032268896443871f},
		{0.000514871936481f, 0.032270754152261f},
		{0.000409263572030f, 0.032272266266801f},
		{0.000303650824695f, 0.032273432771295f},
		{0.000198034825504f, 0.032274253653254f},
		{0.000092416705518f, 0.032274728903884f}
	};
	float[][] MDCT_TABLE_240 = {
		{0.091286604111815f, 0.000298735779793f},
		{0.091247502481454f, 0.002688238127538f},
		{0.091145864370807f, 0.005075898091152f},
		{0.090981759437558f, 0.007460079287760f},
		{0.090755300151030f, 0.009839147718664f},
		{0.090466641715108f, 0.012211472889198f},
		{0.090115981961863f, 0.014575428926191f},
		{0.089703561215976f, 0.016929395692256f},
		{0.089229662130024f, 0.019271759896156f},
		{0.088694609490769f, 0.021600916198470f},
		{0.088098769996564f, 0.023915268311810f},
		{0.087442552006035f, 0.026213230094844f},
		{0.086726405258214f, 0.028493226639351f},
		{0.085950820564309f, 0.030753695349588f},
		{0.085116329471329f, 0.032993087013213f},
		{0.084223503897785f, 0.035209866863042f},
		{0.083272955741727f, 0.037402515628894f},
		{0.082265336461381f, 0.039569530578832f},
		{0.081201336628670f, 0.041709426549053f},
		{0.080081685455930f, 0.043820736961749f},
		{0.078907150296148f, 0.045902014830227f},
		{0.077678536117054f, 0.047951833750597f},
		{0.076396684949434f, 0.049968788879362f},
		{0.075062475310050f, 0.051951497896226f},
		{0.073676821599542f, 0.053898601951466f},
		{0.072240673475749f, 0.055808766597225f},
		{0.070755015202858f, 0.057680682702068f},
		{0.069220864976840f, 0.059513067348201f},
		{0.067639274227625f, 0.061304664710718f},
		{0.066011326898512f, 0.063054246918278f},
		{0.064338138703282f, 0.064760614894630f},
		{0.062620856361546f, 0.066422599180399f},
		{0.060860656812842f, 0.068039060734572f},
		{0.059058746410016f, 0.069608891715145f},
		{0.057216360092450f, 0.071131016238378f},
		{0.055334760539699f, 0.072604391116154f},
		{0.053415237306106f, 0.074028006570930f},
		{0.051459105937014f, 0.075400886927784f},
		{0.049467707067153f, 0.076722091283096f},
		{0.047442405501835f, 0.077990714149396f},
		{0.045384589281588f, 0.079205886075941f},
		{0.043295668730857f, 0.080366774244592f},
		{0.041177075491445f, 0.081472583040586f},
		{0.039030261541332f, 0.082522554597810f},
		{0.036856698199564f, 0.083515969318206f},
		{0.034657875117883f, 0.084452146364948f},
		{0.032435299259796f, 0.085330444129049f},
		{0.030190493867775f, 0.086150260669096f},
		{0.027924997419306f, 0.086911034123781f},
		{0.025640362572491f, 0.087612243096981f},
		{0.023338155101933f, 0.088253407015092f},
		{0.021019952825636f, 0.088834086456390f},
		{0.018687344523641f, 0.089353883452193f},
		{0.016341928849164f, 0.089812441759604f},
		{0.013985313232951f, 0.090209447105664f},
		{0.011619112781631f, 0.090544627402740f},
		{0.009244949170797f, 0.090817752935000f},
		{0.006864449533597f, 0.091028636515846f},
		{0.004479245345574f, 0.091177133616206f},
		{0.002090971306534f, 0.091263142463585f}
	};
}
