/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.flamegraph.views;

import io.github.bric3.fireplace.core.ui.Colors;
import io.github.bric3.fireplace.flamegraph.ColorMapper;
import io.github.bric3.fireplace.flamegraph.DimmingFrameColorProvider;
import io.github.bric3.fireplace.flamegraph.FlamegraphImage;
import io.github.bric3.fireplace.flamegraph.FlamegraphView;
import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameColorProvider;
import io.github.bric3.fireplace.flamegraph.FrameFontProvider;
import io.github.bric3.fireplace.flamegraph.FrameModel;
import io.github.bric3.fireplace.flamegraph.FrameTextsProvider;
import io.github.bric3.fireplace.flamegraph.animation.ZoomAnimation;
import io.github.bric3.fireplace.swt_awt.EmbeddingComposite;
import io.github.bric3.fireplace.swt_awt.SWT_AWTBridge;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.flightrecorder.flamegraph.MessagesUtils;
import org.openjdk.jmc.flightrecorder.flamegraph.views.StyledToolTip;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.Node;
import org.openjdk.jmc.flightrecorder.stacktrace.tree.StacktraceTreeModel;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.common.AttributeSelection;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.CoreImages;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class FlamegraphSwingView
extends ViewPart
implements ISelectionListener {
    private static final String DIR_ICONS = "icons/";
    private static final String PLUGIN_ID = "org.openjdk.jmc.flightrecorder.flamegraph";
    private static final String ATTRIBUTE_SELECTION_SEPARATOR_ID = "AttrSelectionSep";
    private static final int MODEL_EXECUTOR_THREADS_NUMBER = 3;
    private static final ExecutorService MODEL_EXECUTOR = Executors.newFixedThreadPool(3, new ThreadFactory(){
        private final ThreadGroup group = new ThreadGroup("FlamegraphModelCalculationGroup");
        private final AtomicInteger counter = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "FlamegraphModelCalculation-" + this.counter.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    });
    private static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    private static final String JVM_BROWSER_VIEW_ID = "org.openjdk.jmc.browser.views.JVMBrowserView";
    private FrameSeparator frameSeparator;
    private EmbeddingComposite embeddingComposite;
    private FlamegraphView<Node> flamegraphView;
    private ExportAction[] exportActions;
    private boolean threadRootAtTop = true;
    private boolean icicleViewActive = true;
    private IItemCollection currentItems;
    private volatile ModelState modelState = ModelState.NONE;
    private ModelRebuildRunnable modelRebuildRunnable;
    private IAttribute<IQuantity> currentAttribute;
    private AttributeSelection attributeSelection;
    private IToolBarManager toolBar;
    private boolean traverseAlready = false;

    private void createAttributeSelection(String attrName, Collection<Pair<String, IAttribute<IQuantity>>> items) {
        if (this.attributeSelection != null) {
            this.toolBar.remove(this.attributeSelection.getId());
        }
        this.attributeSelection = new AttributeSelection(items, attrName, this::getCurrentAttribute, this::setCurrentAttribute, () -> this.triggerRebuildTask(this.currentItems));
        this.toolBar.insertAfter(ATTRIBUTE_SELECTION_SEPARATOR_ID, (IAction)this.attributeSelection);
        this.toolBar.update(true);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.frameSeparator = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);
        IMenuManager siteMenu = site.getActionBars().getMenuManager();
        siteMenu.add((IContributionItem)new Separator("group.top"));
        siteMenu.add((IContributionItem)new Separator("group.viewerSetup"));
        this.toolBar = site.getActionBars().getToolBarManager();
        this.toolBar.add((IAction)new ResetZoomAction());
        this.toolBar.add((IAction)new ToggleMinimapAction());
        this.toolBar.add((IContributionItem)new Separator());
        ViewModeAction[] groupByFlamegraphActions = new ViewModeAction[]{new ViewModeAction(GroupActionType.FLAME_GRAPH), new ViewModeAction(GroupActionType.ICICLE_GRAPH)};
        Stream.of(groupByFlamegraphActions).forEach(arg_0 -> ((IToolBarManager)this.toolBar).add(arg_0));
        this.toolBar.add((IContributionItem)new Separator());
        GroupByAction[] groupByActions = new GroupByAction[]{new GroupByAction(GroupActionType.LAST_FRAME), new GroupByAction(GroupActionType.THREAD_ROOT)};
        Stream.of(groupByActions).forEach(arg_0 -> ((IToolBarManager)this.toolBar).add(arg_0));
        this.toolBar.add((IContributionItem)new Separator());
        this.exportActions = new ExportAction[]{new ExportAction(ExportActionType.SAVE_AS)};
        Stream.of(this.exportActions).forEach(action -> action.setEnabled(false));
        Stream.of(this.exportActions).forEach(arg_0 -> ((IToolBarManager)this.toolBar).add(arg_0));
        this.toolBar.add((IContributionItem)new Separator(ATTRIBUTE_SELECTION_SEPARATOR_ID));
        this.createAttributeSelection(null, Collections.emptyList());
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        SashForm container = new SashForm(parent, 256);
        this.embeddingComposite = new EmbeddingComposite((Composite)container);
        container.setMaximizedControl((Control)this.embeddingComposite);
        Color bgColorAwtColor = SWT_AWTBridge.toAWTColor((org.eclipse.swt.graphics.Color)container.getBackground());
        StyledToolTip tooltip = new StyledToolTip((Control)this.embeddingComposite, 2, true);
        tooltip.setPopupDelay(500);
        tooltip.setShift(new Point(10, 5));
        this.embeddingComposite.addListener(7, event -> Display.getDefault().timerExec(300, () -> ((StyledToolTip)tooltip).hide()));
        this.embeddingComposite.init(() -> {
            JPanel panel = new JPanel(new BorderLayout());
            JComponent searchControl = this.createSearchControl();
            searchControl.setBackground(bgColorAwtColor);
            panel.add((Component)searchControl, "North");
            this.flamegraphView = this.createFlameGraph((Composite)this.embeddingComposite, tooltip);
            new ZoomAnimation().install(this.flamegraphView);
            JComponent flamegraphComponent = this.flamegraphView.component;
            flamegraphComponent.setBackground(bgColorAwtColor);
            this.setFocusTraversalProperties(flamegraphComponent);
            this.addKeyListenerForFwdFocusToSWT(flamegraphComponent);
            panel.add((Component)flamegraphComponent, "Center");
            panel.setBackground(bgColorAwtColor);
            this.setFocusTraversalProperties(panel);
            this.addKeyListenerForBkwdFocusToSWT(panel);
            return panel;
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            IItemCollection items = (IItemCollection)AdapterUtil.getAdapter((Object)first, IItemCollection.class);
            if (items == null) {
                this.triggerRebuildTask(ItemCollectionToolkit.build(Stream.empty()));
            } else if (!items.equals(this.currentItems)) {
                this.triggerRebuildTask(items);
            }
        }
    }

    public void setFocus() {
        this.embeddingComposite.setFocus();
    }

    private JComponent createSearchControl() {
        JTextField searchField = new JTextField("", 60);
        searchField.addActionListener(e -> {
            String searched = searchField.getText();
            if (searched.isBlank() && this.flamegraphView != null) {
                this.flamegraphView.highlightFrames(Collections.emptySet(), searched);
                return;
            }
            CompletableFuture.runAsync(() -> {
                try {
                    if (this.flamegraphView == null) {
                        return;
                    }
                    Set matches = this.flamegraphView.getFrames().stream().filter(frame -> {
                        IMCMethod method = ((Node)frame.actualNode).getFrame().getMethod();
                        return method.getMethodName().contains(searched) || method.getType().getTypeName().contains(searched) || method.getType().getPackage().getName() != null && method.getType().getPackage().getName().contains(searched) || method.getType().getPackage().getModule() != null && method.getType().getPackage().getModule().getName() != null && method.getType().getPackage().getModule().getName().contains(searched) || method.getFormalDescriptor().replace('/', '.').contains(searched);
                    }).collect(Collectors.toCollection(() -> Collections.newSetFromMap(new IdentityHashMap())));
                    this.flamegraphView.highlightFrames(matches, searched);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        });
        this.setFocusTraversalProperties(searchField);
        this.addKeyListener(searchField);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new JLabel(MessagesUtils.getFlamegraphMessage("FLAMEVIEW_SEARCH", new Object[0])));
        this.setFocusTraversalProperties(panel);
        this.addKeyListener(panel);
        panel.add(searchField);
        return panel;
    }

    private void setFocusBackToSWT() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IViewPart outlineView = activePage.showView(FlamegraphSwingView.OUTLINE_VIEW_ID);
                    if (activePage.getActiveEditor() != null) {
                        outlineView.setFocus();
                    } else {
                        IViewPart showView = activePage.showView(FlamegraphSwingView.JVM_BROWSER_VIEW_ID);
                        showView.setFocus();
                    }
                }
                catch (PartInitException e) {
                    FlightRecorderUI.getDefault().getLogger().log(Level.INFO, "Failed to set focus", e);
                }
            }
        });
    }

    private void addKeyListener(JComponent comp) {
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if ((e.getModifiersEx() & 0x40) != 0) {
                        e.getComponent().transferFocusBackward();
                    } else {
                        e.getComponent().transferFocus();
                    }
                    e.consume();
                }
            }
        });
    }

    private void addKeyListenerForFwdFocusToSWT(JComponent comp) {
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if ((e.getModifiersEx() & 0x40) != 0) {
                        e.getComponent().transferFocusBackward();
                    } else {
                        boolean bl = FlamegraphSwingView.this.traverseAlready = !FlamegraphSwingView.this.traverseAlready;
                        if (FlamegraphSwingView.this.traverseAlready) {
                            FlamegraphSwingView.this.setFocusBackToSWT();
                        } else {
                            e.getComponent().transferFocus();
                        }
                    }
                    e.consume();
                }
            }
        });
    }

    private void addKeyListenerForBkwdFocusToSWT(JComponent comp) {
        comp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    if ((e.getModifiersEx() & 0x40) != 0) {
                        boolean bl = FlamegraphSwingView.this.traverseAlready = !FlamegraphSwingView.this.traverseAlready;
                        if (FlamegraphSwingView.this.traverseAlready) {
                            FlamegraphSwingView.this.setFocusBackToSWT();
                        } else {
                            e.getComponent().transferFocusBackward();
                        }
                    } else {
                        e.getComponent().transferFocus();
                    }
                    e.consume();
                }
            }
        });
    }

    private void setFocusTraversalProperties(JComponent comp) {
        comp.setFocusTraversalKeys(0, Collections.emptySet());
        comp.setFocusTraversalKeys(1, Collections.emptySet());
        comp.setFocusable(true);
        comp.setFocusTraversalKeysEnabled(true);
    }

    private FlamegraphView<Node> createFlameGraph(Composite owner, DefaultToolTip tooltip) {
        FlamegraphView fg = new FlamegraphView();
        fg.putClientProperty(FlamegraphView.SHOW_STATS, (Object)false);
        fg.setShowMinimap(false);
        fg.setRenderConfiguration(FrameTextsProvider.of((Function[])new Function[]{frame -> frame.isRoot() ? "" : ((Node)frame.actualNode).getFrame().getHumanReadableShortString(), frame -> frame.isRoot() ? "" : FormatToolkit.getHumanReadable((IMCMethod)((Node)frame.actualNode).getFrame().getMethod(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false), frame -> frame.isRoot() ? "" : ((Node)frame.actualNode).getFrame().getMethod().getMethodName()}), (FrameColorProvider)new DimmingFrameColorProvider(frame -> ColorMapper.ofObjectHashUsing((Color[])Colors.Palette.DATADOG.colors()).apply((Object)((Node)frame.actualNode).getFrame().getMethod().getType().getPackage())), FrameFontProvider.defaultFontProvider());
        fg.setHoverListener((frameBox, frameRect, mouseEvent) -> {
            Integer frameLineNumber;
            JScrollPane scrollPane = (JScrollPane)mouseEvent.getComponent();
            Component canvas = scrollPane.getViewport().getView();
            java.awt.Point pointOnCanvas = SwingUtilities.convertPoint(scrollPane, mouseEvent.getPoint(), canvas);
            pointOnCanvas.y = frameRect.y + frameRect.height;
            java.awt.Point componentPoint = SwingUtilities.convertPoint(canvas, pointOnCanvas, this.flamegraphView.component);
            if (frameBox.isRoot()) {
                return;
            }
            IMCMethod method = ((Node)frameBox.actualNode).getFrame().getMethod();
            String escapedMethod = ((Node)frameBox.actualNode).getFrame().getHumanReadableShortString().replace("<", "&lt;").replace(">", "&gt;");
            StringBuilder sb = new StringBuilder().append("<form><p>").append("<b>").append(escapedMethod).append("</b><br/>");
            IMCPackage packageName = method.getType().getPackage();
            if (packageName != null) {
                sb.append(packageName).append("<br/>");
            }
            sb.append("<hr/>Weight: ").append(((Node)frameBox.actualNode).getCumulativeWeight()).append("<br/>").append("Type: ").append(((Node)frameBox.actualNode).getFrame().getType()).append("<br/>");
            Integer bci = ((Node)frameBox.actualNode).getFrame().getBCI();
            if (bci != null) {
                sb.append("BCI: ").append(bci).append("<br/>");
            }
            if ((frameLineNumber = ((Node)frameBox.actualNode).getFrame().getFrameLineNumber()) != null) {
                sb.append("Line number: ").append(frameLineNumber).append("<br/>");
            }
            sb.append("</p></form>");
            String text = sb.toString();
            Display.getDefault().asyncExec(() -> {
                Control control = Display.getDefault().getCursorControl();
                if (Objects.equals(owner, control)) {
                    tooltip.setText(text);
                    tooltip.hide();
                    tooltip.show(SWT_AWTBridge.toSWTPoint((java.awt.Point)componentPoint));
                }
            });
        });
        return fg;
    }

    private void triggerRebuildTask(IItemCollection items) {
        if (this.modelRebuildRunnable != null) {
            this.modelRebuildRunnable.setInvalid();
        }
        this.currentItems = items;
        this.modelState = ModelState.NOT_STARTED;
        this.modelRebuildRunnable = new ModelRebuildRunnable(this, items, this.currentAttribute);
        if (!this.modelRebuildRunnable.isInvalid) {
            MODEL_EXECUTOR.execute(this.modelRebuildRunnable);
        }
    }

    private IAttribute<IQuantity> getCurrentAttribute() {
        return this.currentAttribute;
    }

    private void setCurrentAttribute(IAttribute<IQuantity> attr) {
        this.currentAttribute = attr;
    }

    private void setModel(IItemCollection items, List<FrameBox<Node>> flatFrameList, String rootFrameDescription) {
        if (ModelState.FINISHED.equals((Object)this.modelState) && items.equals(this.currentItems)) {
            SwingUtilities.invokeLater(() -> {
                this.flamegraphView.setModel(new FrameModel(rootFrameDescription, (frameA, frameB) -> Objects.equals(((Node)frameA.actualNode).getFrame(), ((Node)frameB.actualNode).getFrame()), flatFrameList));
                Display.getDefault().asyncExec(() -> {
                    if (this.embeddingComposite.isDisposed()) {
                        return;
                    }
                    Stream.of(this.exportActions).forEach(action -> action.setEnabled(!flatFrameList.isEmpty()));
                });
            });
        }
    }

    private void saveFlamegraph() {
        CompletableFuture future = new CompletableFuture();
        DisplayToolkit.inDisplayThread().execute(() -> {
            FileDialog fd = new FileDialog(this.embeddingComposite.getShell(), 8192);
            fd.setText(MessagesUtils.getFlamegraphMessage("FLAMEVIEW_SAVE_FLAME_GRAPH_AS", new Object[0]));
            fd.setFilterNames(new String[]{MessagesUtils.getFlamegraphMessage("FLAMEVIEW_PNG_IMAGE", new Object[0]), MessagesUtils.getFlamegraphMessage("FLAMEVIEW_JPEG_IMAGE", new Object[0])});
            fd.setFilterExtensions(new String[]{"*.png", "*.jpg"});
            fd.setFileName("flame_graph");
            fd.setOverwrite(true);
            if (fd.open() == null) {
                future.cancel(true);
                return;
            }
            String fileName = fd.getFileName().toLowerCase();
            if (!(fileName.endsWith(".jpg") || fileName.endsWith(".jpeg") || fileName.endsWith(".png"))) {
                future.completeExceptionally(new UnsupportedOperationException("Unsupported image format"));
                return;
            }
            future.complete(Paths.get(fd.getFilterPath(), fd.getFileName()));
        });
        Supplier<RenderedImage> generator = () -> {
            FlamegraphImage fgImage = new FlamegraphImage(FrameTextsProvider.of((Function[])new Function[]{frame -> frame.isRoot() ? "" : ((Node)frame.actualNode).getFrame().getHumanReadableShortString(), frame -> frame.isRoot() ? "" : FormatToolkit.getHumanReadable((IMCMethod)((Node)frame.actualNode).getFrame().getMethod(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false), frame -> frame.isRoot() ? "" : ((Node)frame.actualNode).getFrame().getMethod().getMethodName()}), (FrameColorProvider)new DimmingFrameColorProvider(frame -> ColorMapper.ofObjectHashUsing((Color[])Colors.Palette.DATADOG.colors()).apply((Object)((Node)frame.actualNode).getFrame().getMethod().getType().getPackage())), FrameFontProvider.defaultFontProvider());
            return fgImage.generate(this.flamegraphView.getFrameModel(), this.flamegraphView.getMode(), 2000);
        };
        Optional.of(future).map(f -> {
            try {
                return (Path)f.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException | ExecutionException e) {
                FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to save flame graph", e);
            }
            return null;
        }).ifPresent(destinationPath -> {
            String type = Optional.ofNullable(destinationPath.getFileName()).map(p -> p.toString().toLowerCase()).map(f -> switch (f.substring(f.lastIndexOf(46) + 1)) {
                case "jpg", "jpeg" -> "jpg";
                case "png" -> "png";
                default -> null;
            }).orElseThrow(() -> new IllegalStateException("Unhandled type for " + destinationPath));
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(destinationPath, new OpenOption[0]));){
                    RenderedImage renderImg = (RenderedImage)generator.get();
                    RenderedImage img = switch (type) {
                        case "png" -> renderImg;
                        case "jpg" -> {
                            BufferedImage newBufferedImage = new BufferedImage(renderImg.getWidth(), renderImg.getHeight(), 1);
                            renderImg.copyData(newBufferedImage.getRaster());
                            yield newBufferedImage;
                        }
                        default -> throw new IllegalStateException("Type is checked above");
                    };
                    ImageIO.write(img, type, os);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Failed to save flame graph", e);
            }
        });
    }

    private static ImageDescriptor flamegraphImageDescriptor(String iconName) {
        return ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)(DIR_ICONS + iconName)).orElse(null);
    }

    static /* synthetic */ void access$0(FlamegraphSwingView flamegraphSwingView) {
        flamegraphSwingView.saveFlamegraph();
    }

    private class ExportAction
    extends Action {
        private final ExportActionType actionType;

        private ExportAction(ExportActionType actionType) {
            super(actionType.message, actionType.action);
            this.actionType = actionType;
            this.setToolTipText(actionType.message);
            this.setImageDescriptor(actionType.imageDescriptor);
            this.setDisabledImageDescriptor(actionType.disabledImageDescriptor);
        }

        public void run() {
            switch (this.actionType) {
                case SAVE_AS: {
                    Executors.newSingleThreadExecutor().execute(() -> FlamegraphSwingView.access$0(FlamegraphSwingView.this));
                    break;
                }
            }
        }
    }

    private static enum ExportActionType {
        SAVE_AS(MessagesUtils.getFlamegraphMessage("FLAMEVIEW_SAVE_AS", new Object[0]), 1, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVEAS_EDIT_DISABLED")),
        PRINT(MessagesUtils.getFlamegraphMessage("FLAMEVIEW_PRINT", new Object[0]), 1, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_PRINT_EDIT"), PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_PRINT_EDIT_DISABLED"));

        private final String message;
        private final int action;
        private final ImageDescriptor imageDescriptor;
        private final ImageDescriptor disabledImageDescriptor;

        private ExportActionType(String message, int action, ImageDescriptor imageDescriptor, ImageDescriptor disabledImageDescriptor) {
            this.message = message;
            this.action = action;
            this.imageDescriptor = imageDescriptor;
            this.disabledImageDescriptor = disabledImageDescriptor;
        }
    }

    private static enum GroupActionType {
        THREAD_ROOT(Messages.STACKTRACE_VIEW_THREAD_ROOT, 8, CoreImages.THREAD),
        LAST_FRAME(Messages.STACKTRACE_VIEW_LAST_FRAME, 8, CoreImages.METHOD_NON_OPTIMIZED),
        ICICLE_GRAPH(MessagesUtils.getFlamegraphMessage("FLAMEVIEW_ICICLE_GRAPH", new Object[0]), 8, FlamegraphSwingView.flamegraphImageDescriptor("icicleflip.png")),
        FLAME_GRAPH(MessagesUtils.getFlamegraphMessage("FLAMEVIEW_FLAME_GRAPH", new Object[0]), 8, FlamegraphSwingView.flamegraphImageDescriptor("flameflip.png"));

        private final String message;
        private final int action;
        private final ImageDescriptor imageDescriptor;

        private GroupActionType(String message, int action, ImageDescriptor imageDescriptor) {
            this.message = message;
            this.action = action;
            this.imageDescriptor = imageDescriptor;
        }
    }

    private class GroupByAction
    extends Action {
        private final GroupActionType actionType;

        GroupByAction(GroupActionType actionType) {
            super(actionType.message, actionType.action);
            this.actionType = actionType;
            this.setToolTipText(actionType.message);
            this.setImageDescriptor(actionType.imageDescriptor);
            this.setChecked(GroupActionType.THREAD_ROOT.equals((Object)actionType) == FlamegraphSwingView.this.threadRootAtTop);
        }

        public void run() {
            boolean newValue;
            boolean bl = newValue = this.isChecked() == GroupActionType.THREAD_ROOT.equals((Object)this.actionType);
            if (newValue != FlamegraphSwingView.this.threadRootAtTop) {
                FlamegraphSwingView.this.threadRootAtTop = newValue;
                FlamegraphSwingView.this.triggerRebuildTask(FlamegraphSwingView.this.currentItems);
            }
        }
    }

    private static class ModelRebuildRunnable
    implements Runnable {
        private final FlamegraphSwingView view;
        private final IItemCollection items;
        private final IAttribute<IQuantity> attribute;
        private volatile boolean isInvalid;

        private ModelRebuildRunnable(FlamegraphSwingView view, IItemCollection items, IAttribute<IQuantity> attribute) {
            this.view = view;
            this.items = items;
            this.attribute = attribute;
        }

        private void setInvalid() {
            this.isInvalid = true;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            try {
                this.view.modelState = ModelState.STARTED;
                if (this.isInvalid) {
                    return;
                }
                IItemCollection filteredItems = this.items;
                if (this.attribute != null) {
                    filteredItems = filteredItems.apply(ItemFilters.hasAttribute(this.attribute));
                }
                StacktraceTreeModel treeModel = new StacktraceTreeModel(filteredItems, this.view.frameSeparator, !this.view.threadRootAtTop, this.attribute, () -> this.isInvalid);
                if (this.isInvalid) {
                    return;
                }
                String rootFrameDescription = ModelRebuildRunnable.createRootNodeDescription(this.items);
                List<FrameBox<Node>> frameBoxList = ModelRebuildRunnable.convert(treeModel);
                if (!this.isInvalid) {
                    this.view.modelState = ModelState.FINISHED;
                    this.view.setModel(this.items, frameBoxList, rootFrameDescription);
                    DisplayToolkit.inDisplayThread().execute(() -> {
                        List attributeList = AttributeSelection.extractAttributes((IItemCollection)this.items);
                        String attrName = this.attribute != null ? this.attribute.getName() : null;
                        this.view.createAttributeSelection(attrName, attributeList);
                    });
                }
            }
            finally {
                Duration duration = Duration.ofMillis(System.currentTimeMillis() - start);
                FlightRecorderUI.getDefault().getLogger().info("model rebuild with isInvalid:" + this.isInvalid + " in " + duration);
            }
        }

        private static List<FrameBox<Node>> convert(StacktraceTreeModel model) {
            ArrayList<FrameBox<Node>> nodes = new ArrayList<FrameBox<Node>>();
            FrameBox.flattenAndCalculateCoordinate(nodes, (Object)model.getRoot(), Node::getChildren, Node::getCumulativeWeight, node -> node.getChildren().stream().mapToDouble(Node::getCumulativeWeight).sum(), (double)0.0, (double)1.0, (int)0);
            return nodes;
        }

        private static String createRootNodeDescription(IItemCollection items) {
            Map<String, Long> freq = ModelRebuildRunnable.eventTypeFrequency(items);
            long totalEvents = freq.values().stream().mapToLong(Long::longValue).sum();
            if (totalEvents == 0L) {
                return "Stack Trace not available";
            }
            StringBuilder description = new StringBuilder(String.valueOf(totalEvents) + " event(s) of " + freq.size() + " type(s): ");
            int i = 0;
            for (Map.Entry<String, Long> e : freq.entrySet()) {
                description.append(e.getKey()).append("[").append(e.getValue()).append("]");
                if (i < freq.size() - 1 && i < 3) {
                    description.append(", ");
                }
                if (i >= 3) {
                    description.append(", ...");
                    break;
                }
                ++i;
            }
            return description.toString();
        }

        private static Map<String, Long> eventTypeFrequency(IItemCollection items) {
            HashMap<String, Long> eventCountByType = new HashMap<String, Long>();
            for (IItemIterable eventIterable : items) {
                if (eventIterable.getItemCount() == 0L) continue;
                eventCountByType.compute(eventIterable.getType().getName(), (k, v) -> (v == null ? 0L : v) + eventIterable.getItemCount());
            }
            return eventCountByType.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
    }

    private static enum ModelState {
        NOT_STARTED,
        STARTED,
        FINISHED,
        NONE;

    }

    private class ResetZoomAction
    extends Action {
        private ResetZoomAction() {
            super(MessagesUtils.getFlamegraphMessage("FLAMEVIEW_RESET_ZOOM", new Object[0]), 1);
            this.setToolTipText(MessagesUtils.getFlamegraphMessage("FLAMEVIEW_RESET_ZOOM", new Object[0]));
            this.setImageDescriptor(FlamegraphSwingView.flamegraphImageDescriptor("reset-zoom.png"));
        }

        public void run() {
            SwingUtilities.invokeLater(() -> FlamegraphSwingView.this.flamegraphView.resetZoom());
        }
    }

    private class ToggleMinimapAction
    extends Action {
        private ToggleMinimapAction() {
            super(MessagesUtils.getFlamegraphMessage("FLAMEVIEW_TOGGLE_MINIMAP", new Object[0]), 2);
            this.setToolTipText(MessagesUtils.getFlamegraphMessage("FLAMEVIEW_TOGGLE_MINIMAP", new Object[0]));
            this.setImageDescriptor(FlamegraphSwingView.flamegraphImageDescriptor("map.png"));
            this.setChecked(false);
        }

        public void run() {
            boolean toggleMinimap = !FlamegraphSwingView.this.flamegraphView.isShowMinimap();
            SwingUtilities.invokeLater(() -> FlamegraphSwingView.this.flamegraphView.setShowMinimap(toggleMinimap));
            this.setChecked(toggleMinimap);
        }
    }

    private class ViewModeAction
    extends Action {
        private final GroupActionType actionType;

        ViewModeAction(GroupActionType actionType) {
            super(actionType.message, actionType.action);
            this.actionType = actionType;
            this.setToolTipText(actionType.message);
            this.setImageDescriptor(actionType.imageDescriptor);
            this.setChecked(GroupActionType.ICICLE_GRAPH.equals((Object)actionType) == FlamegraphSwingView.this.icicleViewActive);
        }

        public void run() {
            FlamegraphSwingView.this.icicleViewActive = GroupActionType.ICICLE_GRAPH.equals((Object)this.actionType);
            SwingUtilities.invokeLater(() -> FlamegraphSwingView.this.flamegraphView.setMode(FlamegraphSwingView.this.icicleViewActive ? FlamegraphView.Mode.ICICLEGRAPH : FlamegraphView.Mode.FLAMEGRAPH));
        }
    }
}

