/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.AbstractAsyncExecutionStrategy;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataLoaderDispatchStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResultPath;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.introspection.Introspection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@PublicApi
public class AsyncSerialExecutionStrategy
extends AbstractAsyncExecutionStrategy {
    public AsyncSerialExecutionStrategy() {
        super(new SimpleDataFetcherExceptionHandler());
    }

    public AsyncSerialExecutionStrategy(DataFetcherExceptionHandler exceptionHandler) {
        super(exceptionHandler);
    }

    @Override
    public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        DataLoaderDispatchStrategy dataLoaderDispatcherStrategy = executionContext.getDataLoaderDispatcherStrategy();
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationExecutionStrategyParameters instrumentationParameters = new InstrumentationExecutionStrategyParameters(executionContext, parameters);
        InstrumentationContext<ExecutionResult> executionStrategyCtx = SimpleInstrumentationContext.nonNullCtx(instrumentation.beginExecutionStrategy(instrumentationParameters, executionContext.getInstrumentationState()));
        MergedSelectionSet fields = parameters.getFields();
        ImmutableList<String> fieldNames = ImmutableList.copyOf(fields.keySet());
        Optional<ExecutionResult> isNotSensible = Introspection.isIntrospectionSensible(fields, executionContext);
        if (isNotSensible.isPresent()) {
            return CompletableFuture.completedFuture(isNotSensible.get());
        }
        CompletableFuture resultsFuture = Async.eachSequentially(fieldNames, (fieldName, prevResults) -> {
            MergedField currentField = fields.getSubField((String)fieldName);
            ResultPath fieldPath = parameters.getPath().segment(AsyncSerialExecutionStrategy.mkNameForPath(currentField));
            ExecutionStrategyParameters newParameters = parameters.transform(currentField, fieldPath);
            return this.resolveSerialField(executionContext, dataLoaderDispatcherStrategy, newParameters);
        });
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        executionStrategyCtx.onDispatched();
        resultsFuture.whenComplete(this.handleResults(executionContext, fieldNames, overallResult));
        overallResult.whenComplete(executionStrategyCtx::onCompleted);
        return overallResult;
    }

    private Object resolveSerialField(ExecutionContext executionContext, DataLoaderDispatchStrategy dataLoaderDispatcherStrategy, ExecutionStrategyParameters newParameters) {
        dataLoaderDispatcherStrategy.executionSerialStrategy(executionContext, newParameters);
        Object fieldWithInfo = this.resolveFieldWithInfo(executionContext, newParameters);
        if (fieldWithInfo instanceof CompletableFuture) {
            return ((CompletableFuture)fieldWithInfo).thenCompose(fvi -> {
                dataLoaderDispatcherStrategy.executionStrategyOnFieldValuesInfo(List.of(fvi));
                CompletableFuture<Object> fieldValueFuture = fvi.getFieldValueFuture();
                return fieldValueFuture;
            });
        }
        FieldValueInfo fvi2 = (FieldValueInfo)fieldWithInfo;
        dataLoaderDispatcherStrategy.executionStrategyOnFieldValuesInfo(List.of(fvi2));
        return fvi2.getFieldValueObject();
    }
}

