/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Internal;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.SourceLocation;
import graphql.org.antlr.v4.runtime.BailErrorStrategy;
import graphql.org.antlr.v4.runtime.Parser;
import graphql.org.antlr.v4.runtime.RecognitionException;
import graphql.org.antlr.v4.runtime.Token;
import graphql.org.antlr.v4.runtime.misc.ParseCancellationException;
import graphql.parser.AntlrHelper;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.MultiSourceReader;
import graphql.parser.ParserEnvironment;
import graphql.parser.exceptions.MoreTokensSyntaxException;

@Internal
public class ExtendedBailStrategy
extends BailErrorStrategy {
    private final MultiSourceReader multiSourceReader;
    private final ParserEnvironment environment;

    public ExtendedBailStrategy(MultiSourceReader multiSourceReader, ParserEnvironment environment) {
        this.multiSourceReader = multiSourceReader;
        this.environment = environment;
    }

    @Override
    public void recover(Parser recognizer, RecognitionException e) {
        try {
            super.recover(recognizer, e);
        }
        catch (ParseCancellationException parseException) {
            throw this.mkException(recognizer, e);
        }
    }

    @Override
    public Token recoverInline(Parser recognizer) throws RecognitionException {
        try {
            return super.recoverInline(recognizer);
        }
        catch (ParseCancellationException parseException) {
            throw this.mkException(recognizer, null);
        }
    }

    InvalidSyntaxException mkMoreTokensException(Token token) {
        SourceLocation sourceLocation = AntlrHelper.createSourceLocation(this.multiSourceReader, token);
        if (this.environment.getParserOptions().isRedactTokenParserErrorMessages()) {
            return new MoreTokensSyntaxException(this.environment.getI18N(), sourceLocation);
        }
        String sourcePreview = AntlrHelper.createPreview(this.multiSourceReader, token.getLine());
        return new MoreTokensSyntaxException(this.environment.getI18N(), sourceLocation, token.getText(), sourcePreview);
    }

    private InvalidSyntaxException mkException(Parser recognizer, RecognitionException cause) {
        ImmutableList<Object> args;
        String msgKey;
        SourceLocation location;
        String sourcePreview;
        String offendingToken;
        SourceLocation sourceLocation;
        Token currentToken = recognizer.getCurrentToken();
        if (currentToken != null) {
            sourceLocation = AntlrHelper.createSourceLocation(this.multiSourceReader, currentToken);
            offendingToken = currentToken.getText();
            sourcePreview = AntlrHelper.createPreview(this.multiSourceReader, currentToken.getLine());
        } else {
            sourcePreview = null;
            offendingToken = null;
            sourceLocation = null;
        }
        SourceLocation sourceLocation2 = location = sourceLocation == null ? SourceLocation.EMPTY : sourceLocation;
        if (offendingToken == null || this.environment.getParserOptions().isRedactTokenParserErrorMessages()) {
            msgKey = "InvalidSyntaxBail.noToken";
            args = ImmutableList.of(Integer.valueOf(location.getLine()), Integer.valueOf(location.getColumn()));
        } else {
            msgKey = "InvalidSyntaxBail.full";
            args = ImmutableList.of(offendingToken, Integer.valueOf(sourceLocation.getLine()), Integer.valueOf(sourceLocation.getColumn()));
        }
        String msg = this.environment.getI18N().msg(msgKey, args);
        return new InvalidSyntaxException(msg, sourceLocation, offendingToken, sourcePreview, cause);
    }
}

