/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized.nf;

import graphql.Assert;
import graphql.ExperimentalApi;
import graphql.GraphQLContext;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableCollection;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableListMultimap;
import graphql.com.google.common.collect.ImmutableMap;
import graphql.com.google.common.collect.ImmutableMultimap;
import graphql.com.google.common.collect.ImmutableSet;
import graphql.execution.AbortExecutionException;
import graphql.execution.MergedField;
import graphql.execution.conditional.ConditionalNodes;
import graphql.execution.directives.QueryDirectives;
import graphql.introspection.Introspection;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.NodeUtil;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.normalized.nf.NormalizedDocument;
import graphql.normalized.nf.NormalizedField;
import graphql.normalized.nf.NormalizedFieldsMerger;
import graphql.normalized.nf.NormalizedOperation;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.impl.SchemaUtil;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@ExperimentalApi
public class NormalizedDocumentFactory {
    private static final ConditionalNodes conditionalNodes = new ConditionalNodes();

    private NormalizedDocumentFactory() {
    }

    public static NormalizedDocument createNormalizedDocument(GraphQLSchema graphQLSchema, Document document) {
        return NormalizedDocumentFactory.createNormalizedDocument(graphQLSchema, document, Options.defaultOptions());
    }

    public static NormalizedDocument createNormalizedDocument(GraphQLSchema graphQLSchema, Document document, Options options) {
        return new NormalizedDocumentFactoryImpl(graphQLSchema, document, options).createNormalizedQueryImpl();
    }

    private static class NormalizedDocumentFactoryImpl {
        private final GraphQLSchema graphQLSchema;
        private final Document document;
        private final Options options;
        private final Map<String, FragmentDefinition> fragments;
        private final List<PossibleMerger> possibleMergerList = new ArrayList<PossibleMerger>();
        private ImmutableListMultimap.Builder<Field, NormalizedField> fieldToNormalizedField = ImmutableListMultimap.builder();
        private ImmutableMap.Builder<NormalizedField, MergedField> normalizedFieldToMergedField = ImmutableMap.builder();
        private ImmutableMap.Builder<NormalizedField, QueryDirectives> normalizedFieldToQueryDirectives = ImmutableMap.builder();
        private ImmutableListMultimap.Builder<FieldCoordinates, NormalizedField> coordinatesToNormalizedFields = ImmutableListMultimap.builder();
        private int fieldCount = 0;
        private int maxDepthSeen = 0;
        private final List<NormalizedField> rootEnfs = new ArrayList<NormalizedField>();
        private final Set<String> skipIncludeVariableNames = new LinkedHashSet<String>();
        private Map<String, Boolean> assumedSkipIncludeVariableValues;

        private NormalizedDocumentFactoryImpl(GraphQLSchema graphQLSchema, Document document, Options options) {
            this.graphQLSchema = graphQLSchema;
            this.document = document;
            this.options = options;
            this.fragments = NodeUtil.getFragmentsByName(document);
        }

        private NormalizedDocument createNormalizedQueryImpl() {
            ArrayList<NormalizedDocument.NormalizedOperationWithAssumedSkipIncludeVariables> normalizedOperations = new ArrayList<NormalizedDocument.NormalizedOperationWithAssumedSkipIncludeVariables>();
            for (OperationDefinition operationDefinition : this.document.getDefinitionsOfType(OperationDefinition.class)) {
                this.assumedSkipIncludeVariableValues = null;
                this.skipIncludeVariableNames.clear();
                NormalizedOperation normalizedOperation = this.createNormalizedOperation(operationDefinition);
                if (this.skipIncludeVariableNames.size() == 0) {
                    normalizedOperations.add(new NormalizedDocument.NormalizedOperationWithAssumedSkipIncludeVariables(null, normalizedOperation));
                    continue;
                }
                int combinations = (int)Math.pow(2.0, this.skipIncludeVariableNames.size());
                for (int i = 0; i < combinations; ++i) {
                    this.assumedSkipIncludeVariableValues = new LinkedHashMap<String, Boolean>();
                    int variableIndex = 0;
                    for (String variableName : this.skipIncludeVariableNames) {
                        this.assumedSkipIncludeVariableValues.put(variableName, (i & 1 << variableIndex++) != 0);
                    }
                    NormalizedOperation operationWithAssumedVariables = this.createNormalizedOperation(operationDefinition);
                    normalizedOperations.add(new NormalizedDocument.NormalizedOperationWithAssumedSkipIncludeVariables(this.assumedSkipIncludeVariableValues, operationWithAssumedVariables));
                }
            }
            return new NormalizedDocument(normalizedOperations);
        }

        private NormalizedOperation createNormalizedOperation(OperationDefinition operationDefinition) {
            this.rootEnfs.clear();
            this.fieldCount = 0;
            this.maxDepthSeen = 0;
            this.possibleMergerList.clear();
            this.fieldToNormalizedField = ImmutableListMultimap.builder();
            this.normalizedFieldToMergedField = ImmutableMap.builder();
            this.normalizedFieldToQueryDirectives = ImmutableMap.builder();
            this.coordinatesToNormalizedFields = ImmutableListMultimap.builder();
            this.buildNormalizedFieldsRecursively(null, operationDefinition, null, 0);
            for (PossibleMerger possibleMerger : this.possibleMergerList) {
                List<NormalizedField> childrenWithSameResultKey = possibleMerger.parent.getChildrenWithSameResultKey(possibleMerger.resultKey);
                NormalizedFieldsMerger.merge(possibleMerger.parent, childrenWithSameResultKey, this.graphQLSchema);
            }
            NormalizedOperation normalizedOperation = new NormalizedOperation(operationDefinition.getOperation(), operationDefinition.getName(), new ArrayList<NormalizedField>(this.rootEnfs), (ImmutableListMultimap<Field, NormalizedField>)this.fieldToNormalizedField.build(), this.normalizedFieldToMergedField.build(), this.normalizedFieldToQueryDirectives.build(), (ImmutableListMultimap<FieldCoordinates, NormalizedField>)this.coordinatesToNormalizedFields.build(), this.fieldCount, this.maxDepthSeen);
            return normalizedOperation;
        }

        private void captureMergedField(NormalizedField enf, MergedField mergedFld) {
            this.normalizedFieldToMergedField.put(enf, mergedFld);
        }

        private void buildNormalizedFieldsRecursively(@Nullable NormalizedField normalizedField, @Nullable OperationDefinition operationDefinition, @Nullable ImmutableList<CollectedField> fieldAndAstParents, int curLevel) {
            ArrayList<CollectedField> collectedFields;
            ImmutableSet<GraphQLObjectType> possibleObjects;
            if (this.maxDepthSeen < curLevel) {
                this.maxDepthSeen = curLevel;
                this.checkMaxDepthExceeded(curLevel);
            }
            if (normalizedField == null) {
                GraphQLObjectType rootType = SchemaUtil.getOperationRootType(this.graphQLSchema, operationDefinition);
                possibleObjects = ImmutableSet.of(rootType);
                collectedFields = new ArrayList<CollectedField>();
                this.collectFromSelectionSet(operationDefinition.getSelectionSet(), collectedFields, rootType, possibleObjects);
            } else {
                List<GraphQLFieldDefinition> fieldDefs = normalizedField.getFieldDefinitions(this.graphQLSchema);
                possibleObjects = this.resolvePossibleObjects(fieldDefs);
                if (possibleObjects.isEmpty()) {
                    return;
                }
                collectedFields = new ArrayList();
                for (CollectedField fieldAndAstParent : fieldAndAstParents) {
                    if (fieldAndAstParent.field.getSelectionSet() == null) continue;
                    GraphQLFieldDefinition fieldDefinition = Introspection.getFieldDef(this.graphQLSchema, fieldAndAstParent.astTypeCondition, fieldAndAstParent.field.getName());
                    GraphQLCompositeType selectionSetType = (GraphQLCompositeType)((Object)GraphQLTypeUtil.unwrapAll(fieldDefinition.getType()));
                    this.collectFromSelectionSet(fieldAndAstParent.field.getSelectionSet(), collectedFields, selectionSetType, possibleObjects);
                }
            }
            Map<String, List<CollectedField>> fieldsByName = this.fieldsByResultKey(collectedFields);
            ImmutableList.Builder<NormalizedField> resultNFs = ImmutableList.builder();
            ImmutableListMultimap.Builder<NormalizedField, CollectedField> normalizedFieldToAstFields = ImmutableListMultimap.builder();
            this.createNFs(resultNFs, fieldsByName, normalizedFieldToAstFields, curLevel + 1, normalizedField);
            ImmutableCollection nextLevelChildren = resultNFs.build();
            ImmutableMultimap nextLevelNormalizedFieldToAstFields = normalizedFieldToAstFields.build();
            for (NormalizedField childENF : nextLevelChildren) {
                if (normalizedField == null) {
                    this.rootEnfs.add(childENF);
                } else {
                    normalizedField.addChild(childENF);
                }
                ImmutableCollection childFieldAndAstParents = ((ImmutableListMultimap)nextLevelNormalizedFieldToAstFields).get(childENF);
                MergedField mergedField = NormalizedDocumentFactoryImpl.newMergedField((ImmutableList<CollectedField>)childFieldAndAstParents);
                this.captureMergedField(childENF, mergedField);
                this.updateFieldToNFMap(childENF, (ImmutableList<CollectedField>)childFieldAndAstParents);
                this.updateCoordinatedToNFMap(childENF);
                this.buildNormalizedFieldsRecursively(childENF, null, (ImmutableList<CollectedField>)childFieldAndAstParents, curLevel + 1);
            }
        }

        private void checkMaxDepthExceeded(int depthSeen) {
            if (depthSeen > this.options.getMaxChildrenDepth()) {
                throw new AbortExecutionException("Maximum query depth exceeded. " + depthSeen + " > " + this.options.getMaxChildrenDepth());
            }
        }

        private static MergedField newMergedField(ImmutableList<CollectedField> fieldAndAstParents) {
            return MergedField.newMergedField(ImmutableKit.map(fieldAndAstParents, fieldAndAstParent -> fieldAndAstParent.field)).build();
        }

        private void updateFieldToNFMap(NormalizedField NormalizedField2, ImmutableList<CollectedField> mergedField) {
            for (CollectedField astField : mergedField) {
                this.fieldToNormalizedField.put((Object)astField.field, (Object)NormalizedField2);
            }
        }

        private void updateCoordinatedToNFMap(NormalizedField topLevel) {
            for (String objectType : topLevel.getObjectTypeNames()) {
                FieldCoordinates coordinates = FieldCoordinates.coordinates(objectType, topLevel.getFieldName());
                this.coordinatesToNormalizedFields.put((Object)coordinates, (Object)topLevel);
            }
        }

        private Map<String, List<CollectedField>> fieldsByResultKey(List<CollectedField> collectedFields) {
            LinkedHashMap<String, List<CollectedField>> fieldsByName = new LinkedHashMap<String, List<CollectedField>>();
            for (CollectedField collectedField : collectedFields) {
                fieldsByName.computeIfAbsent(collectedField.field.getResultKey(), ignored -> new ArrayList()).add(collectedField);
            }
            return fieldsByName;
        }

        private void createNFs(ImmutableList.Builder<NormalizedField> nfListBuilder, Map<String, List<CollectedField>> fieldsByName, ImmutableListMultimap.Builder<NormalizedField, CollectedField> normalizedFieldToAstFields, int level, NormalizedField parent) {
            for (String resultKey : fieldsByName.keySet()) {
                List<CollectedField> fieldsWithSameResultKey = fieldsByName.get(resultKey);
                List<CollectedFieldGroup> commonParentsGroups = this.groupByCommonParents(fieldsWithSameResultKey);
                for (CollectedFieldGroup fieldGroup : commonParentsGroups) {
                    NormalizedField nf = this.createNF(fieldGroup, level, parent);
                    if (nf == null) continue;
                    for (CollectedField collectedField : fieldGroup.fields) {
                        normalizedFieldToAstFields.put((Object)nf, (Object)collectedField);
                    }
                    nfListBuilder.add((Object)nf);
                }
                if (commonParentsGroups.size() <= 1) continue;
                this.possibleMergerList.add(new PossibleMerger(parent, resultKey));
            }
        }

        private NormalizedField createNF(CollectedFieldGroup collectedFieldGroup, int level, NormalizedField parent) {
            ++this.fieldCount;
            if (this.fieldCount > this.options.getMaxFieldsCount()) {
                throw new AbortExecutionException("Maximum field count exceeded. " + this.fieldCount + " > " + this.options.getMaxFieldsCount());
            }
            Set<GraphQLObjectType> objectTypes = collectedFieldGroup.objectTypes;
            Field field = collectedFieldGroup.fields.iterator().next().field;
            List<Directive> directives = collectedFieldGroup.fields.stream().flatMap(f -> f.field.getDirectives().stream()).collect(Collectors.toList());
            String fieldName = field.getName();
            ImmutableList<String> objectTypeNames = ImmutableKit.map(objectTypes, GraphQLObjectType::getName);
            return NormalizedField.newNormalizedField().alias(field.getAlias()).astArguments(field.getArguments()).astDirectives(directives).objectTypeNames(objectTypeNames).fieldName(fieldName).level(level).parent(parent).build();
        }

        private List<CollectedFieldGroup> groupByCommonParents(Collection<CollectedField> fields) {
            ImmutableSet.Builder objectTypes = ImmutableSet.builder();
            for (CollectedField collectedField : fields) {
                objectTypes.addAll(collectedField.objectTypes);
            }
            ImmutableCollection allRelevantObjects = objectTypes.build();
            Map<GraphQLType, ImmutableList<CollectedField>> groupByAstParent = FpKit.groupingBy(fields, fieldAndType -> fieldAndType.astTypeCondition);
            if (groupByAstParent.size() == 1) {
                return Collections.singletonList(new CollectedFieldGroup(ImmutableSet.copyOf(fields), (Set<GraphQLObjectType>)((Object)allRelevantObjects)));
            }
            ImmutableList.Builder result = ImmutableList.builder();
            for (GraphQLObjectType objectType : allRelevantObjects) {
                Set<CollectedField> relevantFields = FpKit.filterSet(fields, field -> field.objectTypes.contains(objectType));
                result.add(new CollectedFieldGroup(relevantFields, Collections.singleton(objectType)));
            }
            return result.build();
        }

        private void collectFromSelectionSet(SelectionSet selectionSet, List<CollectedField> result, GraphQLCompositeType astTypeCondition, Set<GraphQLObjectType> possibleObjects) {
            for (Selection selection : selectionSet.getSelections()) {
                if (selection instanceof Field) {
                    this.collectField(result, (Field)selection, possibleObjects, astTypeCondition);
                    continue;
                }
                if (selection instanceof InlineFragment) {
                    this.collectInlineFragment(result, (InlineFragment)selection, possibleObjects, astTypeCondition);
                    continue;
                }
                if (!(selection instanceof FragmentSpread)) continue;
                this.collectFragmentSpread(result, (FragmentSpread)selection, possibleObjects);
            }
        }

        private void collectFragmentSpread(List<CollectedField> result, FragmentSpread fragmentSpread, Set<GraphQLObjectType> possibleObjects) {
            FragmentDefinition fragmentDefinition = Assert.assertNotNull(this.fragments.get(fragmentSpread.getName()));
            GraphQLCompositeType newAstTypeCondition = (GraphQLCompositeType)Assert.assertNotNull(this.graphQLSchema.getType(fragmentDefinition.getTypeCondition().getName()));
            Set<GraphQLObjectType> newPossibleObjects = this.narrowDownPossibleObjects(possibleObjects, newAstTypeCondition);
            this.collectFromSelectionSet(fragmentDefinition.getSelectionSet(), result, newAstTypeCondition, newPossibleObjects);
        }

        private void collectInlineFragment(List<CollectedField> result, InlineFragment inlineFragment, Set<GraphQLObjectType> possibleObjects, GraphQLCompositeType astTypeCondition) {
            Set<GraphQLObjectType> newPossibleObjects = possibleObjects;
            GraphQLCompositeType newAstTypeCondition = astTypeCondition;
            if (inlineFragment.getTypeCondition() != null) {
                newAstTypeCondition = (GraphQLCompositeType)this.graphQLSchema.getType(inlineFragment.getTypeCondition().getName());
                newPossibleObjects = this.narrowDownPossibleObjects(possibleObjects, newAstTypeCondition);
            }
            this.collectFromSelectionSet(inlineFragment.getSelectionSet(), result, newAstTypeCondition, newPossibleObjects);
        }

        private void collectField(List<CollectedField> result, Field field, Set<GraphQLObjectType> possibleObjectTypes, GraphQLCompositeType astTypeCondition) {
            if (this.assumedSkipIncludeVariableValues == null) {
                Boolean shouldInclude = conditionalNodes.shouldIncludeWithoutVariables(field);
                if (shouldInclude == null) {
                    String skipVariableName = conditionalNodes.getSkipVariableName(field);
                    String includeVariableName = conditionalNodes.getIncludeVariableName(field);
                    if (skipVariableName != null) {
                        this.skipIncludeVariableNames.add(skipVariableName);
                    }
                    if (includeVariableName != null) {
                        this.skipIncludeVariableNames.add(includeVariableName);
                    }
                }
                if (shouldInclude != null && !shouldInclude.booleanValue()) {
                    return;
                }
            } else if (!conditionalNodes.shouldInclude(field, this.assumedSkipIncludeVariableValues, this.graphQLSchema, null)) {
                return;
            }
            if (possibleObjectTypes.isEmpty()) {
                return;
            }
            result.add(new CollectedField(field, possibleObjectTypes, astTypeCondition));
        }

        private Set<GraphQLObjectType> narrowDownPossibleObjects(Set<GraphQLObjectType> currentOnes, GraphQLCompositeType typeCondition) {
            ImmutableSet<GraphQLObjectType> resolvedTypeCondition = this.resolvePossibleObjects(typeCondition);
            if (currentOnes.isEmpty()) {
                return resolvedTypeCondition;
            }
            return FpKit.intersection(currentOnes, resolvedTypeCondition);
        }

        private ImmutableSet<GraphQLObjectType> resolvePossibleObjects(List<GraphQLFieldDefinition> defs) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (GraphQLFieldDefinition def : defs) {
                GraphQLUnmodifiedType outputType = GraphQLTypeUtil.unwrapAll(def.getType());
                if (!(outputType instanceof GraphQLCompositeType)) continue;
                builder.addAll(this.resolvePossibleObjects((GraphQLCompositeType)((Object)outputType)));
            }
            return builder.build();
        }

        private ImmutableSet<GraphQLObjectType> resolvePossibleObjects(GraphQLCompositeType type) {
            if (type instanceof GraphQLObjectType) {
                return ImmutableSet.of((GraphQLObjectType)type);
            }
            if (type instanceof GraphQLInterfaceType) {
                return ImmutableSet.copyOf(this.graphQLSchema.getImplementations((GraphQLInterfaceType)type));
            }
            if (type instanceof GraphQLUnionType) {
                List<GraphQLNamedOutputType> unionTypes = ((GraphQLUnionType)type).getTypes();
                return ImmutableSet.copyOf(ImmutableKit.map(unionTypes, GraphQLObjectType.class::cast));
            }
            return (ImmutableSet)Assert.assertShouldNeverHappen();
        }

        private static class CollectedFieldGroup {
            Set<GraphQLObjectType> objectTypes;
            Set<CollectedField> fields;

            public CollectedFieldGroup(Set<CollectedField> fields, Set<GraphQLObjectType> objectTypes) {
                this.fields = fields;
                this.objectTypes = objectTypes;
            }
        }

        private static class CollectedField {
            Field field;
            Set<GraphQLObjectType> objectTypes;
            GraphQLCompositeType astTypeCondition;

            public CollectedField(Field field, Set<GraphQLObjectType> objectTypes, GraphQLCompositeType astTypeCondition) {
                this.field = field;
                this.objectTypes = objectTypes;
                this.astTypeCondition = astTypeCondition;
            }
        }

        private static class PossibleMerger {
            NormalizedField parent;
            String resultKey;

            public PossibleMerger(NormalizedField parent, String resultKey) {
                this.parent = parent;
                this.resultKey = resultKey;
            }
        }
    }

    public static class Options {
        private final GraphQLContext graphQLContext;
        private final Locale locale;
        private final int maxChildrenDepth;
        private final int maxFieldsCount;
        private final boolean deferSupport;
        public static final int DEFAULT_MAX_FIELDS_COUNT = 100000;
        private static Options defaultOptions = new Options(GraphQLContext.getDefault(), Locale.getDefault(), Integer.MAX_VALUE, 100000, false);

        private Options(GraphQLContext graphQLContext, Locale locale, int maxChildrenDepth, int maxFieldsCount, boolean deferSupport) {
            this.graphQLContext = graphQLContext;
            this.locale = locale;
            this.maxChildrenDepth = maxChildrenDepth;
            this.deferSupport = deferSupport;
            this.maxFieldsCount = maxFieldsCount;
        }

        public static void setDefaultOptions(Options options) {
            defaultOptions = Assert.assertNotNull(options);
        }

        public static Options defaultOptions() {
            return defaultOptions;
        }

        public Options locale(Locale locale) {
            return new Options(this.graphQLContext, locale, this.maxChildrenDepth, this.maxFieldsCount, this.deferSupport);
        }

        public Options graphQLContext(GraphQLContext graphQLContext) {
            return new Options(graphQLContext, this.locale, this.maxChildrenDepth, this.maxFieldsCount, this.deferSupport);
        }

        public Options maxChildrenDepth(int maxChildrenDepth) {
            return new Options(this.graphQLContext, this.locale, maxChildrenDepth, this.maxFieldsCount, this.deferSupport);
        }

        public Options maxFieldsCount(int maxFieldsCount) {
            return new Options(this.graphQLContext, this.locale, this.maxChildrenDepth, maxFieldsCount, this.deferSupport);
        }

        @ExperimentalApi
        public Options deferSupport(boolean deferSupport) {
            return new Options(this.graphQLContext, this.locale, this.maxChildrenDepth, this.maxFieldsCount, deferSupport);
        }

        public GraphQLContext getGraphQLContext() {
            return this.graphQLContext;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public int getMaxChildrenDepth() {
            return this.maxChildrenDepth;
        }

        public int getMaxFieldsCount() {
            return this.maxFieldsCount;
        }
    }
}

