/*
 * Decompiled with CFR 0.152.
 */
package org.dataloader.instrumentation;

import java.util.function.BiConsumer;
import org.dataloader.annotations.Internal;
import org.dataloader.instrumentation.DataLoaderInstrumentationContext;

@Internal
class SimpleDataLoaderInstrumentationContext<T>
implements DataLoaderInstrumentationContext<T> {
    private final BiConsumer<T, Throwable> codeToRunOnComplete;
    private final Runnable codeToRunOnDispatch;

    SimpleDataLoaderInstrumentationContext(Runnable codeToRunOnDispatch, BiConsumer<T, Throwable> codeToRunOnComplete) {
        this.codeToRunOnComplete = codeToRunOnComplete;
        this.codeToRunOnDispatch = codeToRunOnDispatch;
    }

    @Override
    public void onDispatched() {
        if (this.codeToRunOnDispatch != null) {
            this.codeToRunOnDispatch.run();
        }
    }

    @Override
    public void onCompleted(T result, Throwable t2) {
        if (this.codeToRunOnComplete != null) {
            this.codeToRunOnComplete.accept(result, t2);
        }
    }
}

