/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.stream.Collector;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonInputIterator;
import org.openqa.selenium.json.JsonTypeCoercer;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

public class CollectionCoercer<T extends Collection>
extends TypeCoercer<T> {
    private final Class<T> stereotype;
    private final JsonTypeCoercer coercer;
    private final Collector<Object, ?, ? extends T> collector;

    public CollectionCoercer(Class<T> stereotype, JsonTypeCoercer coercer, Collector<Object, ?, T> collector) {
        this.stereotype = (Class)Require.nonNull((String)"Stereotype", stereotype);
        this.coercer = (JsonTypeCoercer)Require.nonNull((String)"Coercer", (Object)coercer);
        this.collector = (Collector)Require.nonNull((String)"Collector", collector);
    }

    @Override
    public boolean test(Class<?> aClass) {
        return this.stereotype.isAssignableFrom(aClass);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, T> apply(Type type) {
        Object valueType;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            valueType = pt.getActualTypeArguments()[0];
        } else if (type instanceof Class) {
            valueType = Object.class;
        } else {
            throw new IllegalArgumentException("Unhandled type: " + String.valueOf(type.getClass()));
        }
        return (arg_0, arg_1) -> this.lambda$apply$1((Type)valueType, arg_0, arg_1);
    }

    private /* synthetic */ Collection lambda$apply$1(Type valueType, JsonInput jsonInput, PropertySetting setting) {
        jsonInput.beginArray();
        Collection toReturn = (Collection)new JsonInputIterator(jsonInput).asStream().map(in -> this.coercer.coerce((JsonInput)in, valueType, setting)).collect(this.collector);
        jsonInput.endArray();
        return toReturn;
    }
}

