/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Function;
import org.openqa.selenium.json.JsonException;

public class SimplePropertyDescriptor {
    private static final Function<Object, Object> GET_CLASS_NAME = obj -> {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Class) {
            return ((Class)obj).getName();
        }
        return obj.getClass().getName();
    };
    private final String name;
    private final Function<Object, Object> read;
    private final Method write;

    public SimplePropertyDescriptor(String name, Function<Object, Object> read, Method write) {
        this.name = name;
        this.read = read;
        this.write = write;
    }

    public String getName() {
        return this.name;
    }

    public Function<Object, Object> getReadMethod() {
        return this.read;
    }

    public Method getWriteMethod() {
        return this.write;
    }

    public static SimplePropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        HashMap<String, SimplePropertyDescriptor> properties = new HashMap<String, SimplePropertyDescriptor>();
        properties.put("class", new SimplePropertyDescriptor("class", GET_CLASS_NAME, null));
        for (Method m : clazz.getMethods()) {
            if (Class.class.equals(m.getDeclaringClass()) || Object.class.equals(m.getDeclaringClass())) continue;
            String methodName = m.getName();
            String propertyName = null;
            Method readMethod = null;
            Method writeMethod = null;
            if (SimplePropertyDescriptor.hasPrefix("is", methodName)) {
                readMethod = m;
                propertyName = SimplePropertyDescriptor.uncapitalize(methodName.substring(2));
            } else if (SimplePropertyDescriptor.hasPrefix("get", methodName) || SimplePropertyDescriptor.hasPrefix("has", methodName)) {
                readMethod = m;
                propertyName = SimplePropertyDescriptor.uncapitalize(methodName.substring(3));
            } else if (SimplePropertyDescriptor.hasPrefix("set", methodName) && m.getParameterCount() == 1) {
                writeMethod = m;
                propertyName = SimplePropertyDescriptor.uncapitalize(methodName.substring(3));
            }
            if (readMethod != null && readMethod.getParameterCount() != 0) {
                readMethod = null;
            }
            Function<Object, Object> read = null;
            if (readMethod != null) {
                Method finalReadMethod = readMethod;
                read = obj -> {
                    try {
                        finalReadMethod.setAccessible(true);
                        return finalReadMethod.invoke(obj, new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new JsonException(e);
                    }
                };
            }
            if (readMethod == null && writeMethod == null) continue;
            SimplePropertyDescriptor descriptor = properties.getOrDefault(propertyName, new SimplePropertyDescriptor(propertyName, null, null));
            properties.put(propertyName, new SimplePropertyDescriptor(propertyName, read != null ? read : descriptor.getReadMethod(), writeMethod != null ? writeMethod : descriptor.getWriteMethod()));
        }
        SimplePropertyDescriptor[] pdsArray = new SimplePropertyDescriptor[properties.size()];
        return properties.values().toArray(pdsArray);
    }

    private static String uncapitalize(String s) {
        return s.substring(0, 1).toLowerCase(Locale.ENGLISH) + s.substring(1);
    }

    private static boolean hasPrefix(String prefix, String methodName) {
        if (methodName.length() < prefix.length() + 1) {
            return false;
        }
        if (!methodName.startsWith(prefix)) {
            return false;
        }
        return Character.isUpperCase(methodName.charAt(prefix.length()));
    }
}

